//---------------------------------------------------------------------------
/* UnbindHandler.java
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class UnbindHandler extends TupleHandler {

  private P2Runtime runtime;

  private boolean dbg = false|| P2Runtime.verboseHandlers;
 
  public UnbindHandler(P2Runtime runtime){
    super("unbind");
    this.runtime = runtime;
  }

 
  public void handleTuple(Tuple tp) {
    //Env.dprintln(dbg, "handleUnbind: "+ tp);
    // <unbind, myOverlogId, objId, offset, length, ts, nodeId>
    ObjId objId;
    if(OverlogPolicy.P2VersionHasStringProblem){
      objId = new ObjId(tp.getItem(2).replaceAll("-", "/"));  
    }else {
      objId = new ObjId(tp.getItem(2));  
    }

    long offset = new Long(tp.getItem(3)).longValue();
    long length = new Long(tp.getItem(4)).longValue();
    long ts = new Long(tp.getItem(5)).longValue();
    NodeId nodeId = new NodeId(new Long(tp.getItem(6)).longValue());
    AcceptStamp as = new AcceptStamp(ts, nodeId);

    runtime.unbind(objId, offset, length, as);
  }
}

//---------------------------------------------------------------------------
/* $Log: UnbindHandler.java,v $
/* Revision 1.4  2007/09/12 19:08:13  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.3  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.2  2006/10/17 23:40:55  nalini
/* minor bug fixes and separated AS into individual components in overlog tuples
/*
/* Revision 1.1  2006/10/16 20:54:51  nalini
/* P2 tuple handler support added
/*
*/
//---------------------------------------------------------------------------