//---------------------------------------------------------------------------
/* ClientServerUnit_Server.java
 * 
 * Implements the Server side for the ClientServerUnit test
 *  - server to create objects
 *  - wiats for client to establish subscriptions
 *  - server to update objects
 *  - waits for client to reads the objects 
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------
import java.io.*;

public class ClientServerUnit_Server {

  BoundWriter bWriter;
  int myId;
  byte[] initialBytes;
  byte[] finalBytes;
  private static final boolean verbose = false;

//---------------------------------------------------------------------------
//  Basic constructor
//---------------------------------------------------------------------------

  public ClientServerUnit_Server() throws Exception{
    
    bWriter = new BoundWriter(ClientServerUnit.CONFIG_PATH,
			      ClientServerUnit.CONFIG_P2_PATH,
			      new NodeId(ClientServerUnit.WRITER_NODE_ID));
    myId = (int) ClientServerUnit.WRITER_NODE_ID;

    initialBytes = new byte[ClientServerUnit.sizeOfWrites];
    for(int i = 0; i < ClientServerUnit.sizeOfWrites; i++){
      initialBytes[i] = ClientServerUnit.initialValue;
    }

    finalBytes = new byte[ClientServerUnit.sizeOfWrites];
    for(int i = 0; i < ClientServerUnit.sizeOfWrites; i++){
      finalBytes[i] = ClientServerUnit.finalValue;
    }

  }


//---------------------------------------------------------------------------
// Write Objects 
//---------------------------------------------------------------------------

  public void writeStuff(byte[] b){

    for (int i=0; i < ClientServerUnit.numOfObjs; i++){
      ObjId objId = new ObjId("/"+ i);
      try{
	bWriter.write(objId, 0, ClientServerUnit.sizeOfWrites, b);
	}catch(Exception e){
	  e.printStackTrace();
	  assert(false);
	}
    }

  }

//---------------------------------------------------------------------------
// getID
//---------------------------------------------------------------------------
  public int getId(){
    return myId;
  }

//---------------------------------------------------------------------------
//  Main method - writes objects, waits for reader to subscribe,
//  writes objects again.
//
//---------------------------------------------------------------------------

  public static void main(String[] args){
    try{
      if (verbose) {
	System.out.println("ClientServerUnit_Server Starting...");
      }
      
      ClientServerUnit_Server server = new ClientServerUnit_Server();
      BarrierClient c =  new BarrierClient("localhost", 
					   ClientServerUnit.BARRIER_PORT,
					   server.getId());

      c.sendBarrierRequest(0, server.getId()); // Wait to "Go"
      server.writeStuff(server.initialBytes);
      if (verbose) {
	System.out.println("ClientServerUnit_Server wrote initial value");
      }


      c.sendBarrierRequest(0, server.getId()); // Inform server finished writiing data
      

      c.sendBarrierRequest(0, server.getId()); // Wait for client to establish subscriptions
      server.writeStuff(server.finalBytes);
      if (verbose) {
	System.out.println("ClientServerUnit_Server updated objects");
      }
      
      c.sendBarrierRequest(0, server.getId()); //Wait for client to read data      
      if (verbose) {
	System.out.println("ClientServerUnit_Server Exiting... Bye Bye");
      }

      System.exit(0); 
    } catch(Exception e){
      //ignore
    }
  }
  
}

//---------------------------------------------------------------------------
/* $Log: ClientServerUnit_Server.java,v $
/* Revision 1.3  2006/10/10 19:46:00  nalini
/* minor bug fix
/*
/* Revision 1.2  2006/08/30 21:38:56  nalini
/* Three node unit test added
/*
/* Revision 1.1  2006/08/24 23:08:53  nalini
/* Simple unit test created for P2Runtime
/*
*/
//---------------------------------------------------------------------------
