//---------------------------------------------------------------------------
/* DemandReadUnit_Server.java
 * 
 * Implements the Server side for the DemandReadUnit test
 *  - server to create objects
 *  - wiats for client to establish subscriptions
 *  - server to update objects
 *  - waits for client to reads the objects
 * 
 *  **Note**: Server makes unbound writes so client needs to demand read
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------
import java.io.*;

public class DemandReadUnit_Server {

  UnboundWriter unbWriter;
  int myId;
  byte[] initialBytes;
  byte[] finalBytes;
  private static final boolean verbose = false;

//---------------------------------------------------------------------------
//  Basic constructor
//---------------------------------------------------------------------------

  public DemandReadUnit_Server() throws Exception{
    
    unbWriter = new UnboundWriter(DemandReadUnit.CONFIG_PATH,
			      DemandReadUnit.CONFIG_P2_PATH,
			      new NodeId(DemandReadUnit.WRITER_NODE_ID));
    myId = (int) DemandReadUnit.WRITER_NODE_ID;

    initialBytes = new byte[DemandReadUnit.sizeOfWrites];
    for(int i = 0; i < DemandReadUnit.sizeOfWrites; i++){
      initialBytes[i] = DemandReadUnit.initialValue;
    }

    finalBytes = new byte[DemandReadUnit.sizeOfWrites];
    for(int i = 0; i < DemandReadUnit.sizeOfWrites; i++){
      finalBytes[i] = DemandReadUnit.finalValue;
    }

  }


//---------------------------------------------------------------------------
// Write Objects 
//---------------------------------------------------------------------------

  public void writeStuff(byte[] b){

    for (int i=0; i < DemandReadUnit.numOfObjs; i++){
      ObjId objId = new ObjId("/"+ i);
      try{
	unbWriter.write(objId, 0, DemandReadUnit.sizeOfWrites, b);
	}catch(Exception e){
	  e.printStackTrace();
	  assert(false);
	}
    }

  }



//---------------------------------------------------------------------------
// getID
//---------------------------------------------------------------------------
  public int getId(){
    return myId;
  }

//---------------------------------------------------------------------------
//  Main method - writes objects, waits for reader to subscribe,
//  writes objects again.
//
//---------------------------------------------------------------------------

  public static void main(String[] args){
    try{
      if (verbose) {
	System.out.println("DemandReadUnit_Server Starting...");
      }
      
      DemandReadUnit_Server server = new DemandReadUnit_Server();
      BarrierClient c =  new BarrierClient("localhost", 
					   DemandReadUnit.BARRIER_PORT,
					   server.getId());


      c.sendBarrierRequest(0, server.getId()); // Wait to "Go"
      server.writeStuff(server.initialBytes);
      if (verbose) {
	System.out.println("DemandReadUnit_Server wrote initial value");
      }


      c.sendBarrierRequest(0, server.getId()); // Inform server finished writiing data
      

      c.sendBarrierRequest(0, server.getId()); // Wait for client to establish subscriptions
      server.writeStuff(server.finalBytes);
      if (verbose) {
	System.out.println("DemandReadUnit_Server updated objects");
      }
      

      c.sendBarrierRequest(0, server.getId()); //Wait for client to read data      
      if (verbose) {
	System.out.println("DemandReadUnit_Server Exiting... Bye Bye");
      }

      System.exit(0); 
    } catch(Exception e){
      //ignore
    }
  }
  
}

//---------------------------------------------------------------------------
/* $Log: DemandReadUnit_Server.java,v $
/* Revision 1.3  2006/10/12 16:41:29  nalini
/* set verbose to false
/*
/* Revision 1.2  2006/09/26 05:34:10  nalini
/* added sync interface to policy and runtime
/*
/* Revision 1.1  2006/08/24 23:08:54  nalini
/* Simple unit test created for P2Runtime
/*
*/
//---------------------------------------------------------------------------
