//---------------------------------------------------------------------------
/* DevNull.java
 *
 *
 * Consume stdin and stderr or subprocesses so they
 * don't block when the buffer is full
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.util.*;
import java.io.*;

class DevNull extends Thread
{
  InputStream is;
  String who;

  DevNull(InputStream is, String who){
    this.is = is;
    this.who = who;
  }
  
  public void run(){
    try{
      InputStreamReader isr = new InputStreamReader(is);
      BufferedReader br = new BufferedReader(isr);
      String line = null;
      while((line = br.readLine()) != null){
        System.out.println(who + ": " + line);
      }
    }
    catch(IOException e){
      //e.printStackTrace();
    }
  }

}


//---------------------------------------------------------------------------
/* $Log: DevNull.java,v $
/* Revision 1.2  2006/10/12 16:38:42  nalini
/* minor update
/*
/* Revision 1.1  2006/08/24 23:08:54  nalini
/* Simple unit test created for P2Runtime
/*
 */
//---------------------------------------------------------------------------
