//---------------------------------------------------------------------------
/* NullReader.java
 * 
 * Sets up the program for testing.
 * Reader with Null Policy.
 * Provides a interface thro' which to read and write data.
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------
import java.io.*;

public class NullReader{

  Policy policy;
  P2Runtime runtime;
  AllReadBlockAllWriteBoundInterface localInterface;


  public NullReader(String PRACTIconfigPath, 
		     String p2ConfigPath, 
		     NodeId myId){
    Policy policy = new NullPolicy();
    runtime = new P2Runtime(PRACTIconfigPath, p2ConfigPath, 
			    myId, true, policy, false);
    policy.setRuntime(runtime);
    runtime.start();
    localInterface = new AllReadBlockAllWriteBoundInterface(runtime.getController(), 
					runtime.getCore());
  }

//---------------------------------------------------------------------------
//  Read Method - blocks for all invalid and imprecise reads
//---------------------------------------------------------------------------
  public ImmutableBytes
  read(ObjId objId, long offset, long length) 
    throws ObjNotFoundException, IOException, 
	   EOFException, ReadOfInvalidRangeException, ReadOfHoleException {
    
    return localInterface.read(objId, offset, length);
  }
    

//---------------------------------------------------------------------------
//  Write Method - bound writes
//---------------------------------------------------------------------------
  public long
  write(ObjId objId, 
        long offset, 
        long length, 
        byte[] buffer)
    throws IOException{
    return localInterface.write(objId, offset, length, buffer);
  }

//---------------------------------------------------------------------------
// getLocalInterface Method
//---------------------------------------------------------------------------
  public LocalInterface getLocalInterface(){
    return localInterface;
  }

//---------------------------------------------------------------------------
// getRuntime Method
//---------------------------------------------------------------------------
  public P2Runtime getRuntime(){
    return runtime;
  }

}

//---------------------------------------------------------------------------
/* $Log: NullReader.java,v $
/* Revision 1.5  2007/02/27 04:44:41  zjiandan
/* change readOfHole interface such that read of hole will throw an
/* ReadOfHoleException with the position of the next written byte.
/*
/* Revision 1.4  2007/02/12 06:19:49  zjiandan
/* Expose noSyncLog parameter, add more unittest for PRACTIFS, PangaeaFS.
/*
/* Revision 1.3  2006/12/08 23:13:18  nalini
/* reverted to old read interface
/*
/* Revision 1.1  2006/08/24 23:08:54  nalini
/* Simple unit test created for P2Runtime
/*
*/
//---------------------------------------------------------------------------
