//---------------------------------------------------------------------------
/* ProcessState.java
 * 
 * Object which makes threads wait until it has been notified
 * The object only stores the exit value the first time it is notified
 * The assumption is that if a process has a -1 exit value, it 
 * is the first one to exit.
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.lang.*;

public class ProcessState {
  private boolean notified = false;
  private Integer exitValue = null;

  public synchronized void  waitForProcess(){
    try{
      if(!notified) wait();
      //
      // Note: if the process state has been notified b4, no thread will
     // be asked to wait.
     //
    } catch(Exception e){
      //ignore
    }
  }

  public synchronized void notifyDone(int exitInt){
    try{
      notified = true;
      if (exitValue == null) {
	this.exitValue = new Integer(exitInt);
      }
      notifyAll();
    }catch(Exception e){
      //ignore
    }
  }

  public synchronized int exitValue() throws IllegalThreadStateException{
    if(exitValue == null) {
      throw new IllegalThreadStateException();
    }
    else return exitValue.intValue();
  }
}
    
//---------------------------------------------------------------------------
/* $Log: ProcessState.java,v $
/* Revision 1.1  2006/08/30 21:38:56  nalini
/* Three node unit test added
/*
*/
//---------------------------------------------------------------------------
