//---------------------------------------------------------------------------
/* ProcessThread.java
 * 
 * Runs a process in its own thread.
 * once the process is done, it will notify ProcessState
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.lang.*;

public class ProcessThread extends Thread{
  
  private String who; 
  private String command;
  private ProcessState state;
  private boolean finished = false;
  private Process p;


  public ProcessThread(String who, String command, ProcessState state){
    this.who = who;
    this.command = command;
    this.state = state;
  }


  public void run() {
    try{
 
      p = Runtime.getRuntime().exec(command);
      System.out.println(who + " started");
      
      Thread dn = new DevNull(p.getInputStream(), who + " stdout");
      dn.start();
      
      dn = new DevNull(p.getErrorStream(), who + " stderr");
      dn.start();
      
      p.waitFor();
      
      state.notifyDone(p.exitValue());

    } catch(Exception e){
      e.printStackTrace();
    }
  }
  
  public void destroyProcess(){
    p.destroy();
    System.out.println(who + " destroyed");
  }
	
  public int exitValue() throws IllegalThreadStateException{ 
    return p.exitValue();
  }
}


//---------------------------------------------------------------------------
/* $Log: ProcessThread.java,v $
/* Revision 1.2  2006/08/31 23:43:50  nalini
/* minor code changes
/*
/* Revision 1.1  2006/08/30 21:38:56  nalini
/* Three node unit test added
/*
*/
//---------------------------------------------------------------------------
