//---------------------------------------------------------------------------
/* StressTestClientPolicy
 * 
 * Poilcy for StressTestUnit_Client
 * 
 * demand read an obj whenever it receives an inval
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;
import java.util.Hashtable;

public class StressTestClientPolicy extends Policy{


  private boolean dbg = false;

 

//---------------------------------------------------------------------------
// interface to interact with safety module
//---------------------------------------------------------------------------

  // receiveMsg: called by safety to send a msg to liveness policy
  public void receiveMsg(String[] msg){
  }

//---------------------------------------------------------------------------
// starts the policy layer
//---------------------------------------------------------------------------
  public void start(){
  }


//---------------------------------------------------------------------------
// shuts down the policy layer
//---------------------------------------------------------------------------
  public void shutdown(){
  }


//---------------------------------------------------------------------------
// demand read whenever we receive an unbounded inval
//---------------------------------------------------------------------------


  public void informReceiveInval(NodeId senderNodeId, ObjId objId, long offset, long length,
                                 AcceptStamp as, boolean isBound, boolean isEmbargoed){
    Env.dprintln(dbg, "informReceiveInval"+objId+":"+offset+":"+length + "bound=" + isBound);

    if(!isBound) {
	runtime.demandRead(senderNodeId, objId, offset, length, as);
    }
  }


//---------------------------------------------------------------------------
// information of practi events
//---------------------------------------------------------------------------

  public void informLocalReadInvalid(ObjId objId, long offset, long length,
				     AcceptStamp inval){
    Env.dprintln(dbg, "informLocalReadInvalid:"+objId+":"+offset+":"+length);
  }

  public void informLocalReadImprecise(ObjId objId, long offset, long length){
    Env.dprintln(dbg, "informLocalReadImprecise:"+objId+":"+offset+":"+length);
  }

  public void informLocalWrite(ObjId objId, long offset, long length, AcceptStamp as,
                               boolean isBound, boolean isEmbargoed){
    Env.dprintln(dbg, "informLocalWrite"+objId+":"+offset+":"+length);
  }

  public void informLocalDelete(ObjId objId){
    Env.dprintln(dbg, "informLocalDelete"+objId);
  }


   public void informDemandReadSuccess(NodeId senderNodeId, ObjId objId, long offset,
				      long length,
				      AcceptStamp as) {
      Env.dprintln(dbg, "informDemandReadSuccess"+senderNodeId+":"+objId+":"+offset+":"+length 
		   + ":" + as.toString());
 
    
  }

  public void informDemandReadFailedMiss(NodeId senderNodeId, ObjId objId, 
                                         long offset, long length, 
					 AcceptStamp as) {
      Env.dprintln(dbg, "informDemandReadFailedMiss"+senderNodeId+":"+objId
		   +":"+offset+":"+length + ":" + as.toString());
  }
 
  public void informDemandReadFailedMaxRetries(NodeId senderNodeId, ObjId objId, 
                                               long offset,long length,
					       AcceptStamp as) {
    Env.dprintln(dbg, "informDemandReadFailedMaxRetries"
		 +senderNodeId+":"+objId+":"+offset+":"+length + ":" + as.toString());
  }

  public void recvSyncReply(NodeId senderNodeId, AcceptStamp acceptStamp) {
    Env.dprintln(dbg, "recvSyncReply "+senderNodeId+":"+acceptStamp);
  }


//---------------------------------------------------------------------------
// Subscription add events
//---------------------------------------------------------------------------

  public void informAddedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "InformAddedInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAttachedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "InformAttachedInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }


  public void informAddedBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informAddedBodySubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddedOutgoingInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informAddedOutgoingInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddedOutgoingBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "InformAddedOutgoingBodySubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

//---------------------------------------------------------------------------
// Subscription removed events
//---------------------------------------------------------------------------

  public void informRemovedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informRemovedBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedBodySbuscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }
  
  public void informRemovedOutgoingInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedOutgoingInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informRemovedOutgoingBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedOutgiongBodySubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

//---------------------------------------------------------------------------
// Subscription failed
//---------------------------------------------------------------------------
 
  public void informAddInvalSubscriptionFailed(NodeId senderNodeId, 
                                               NodeId receiverNodeId, 
                                               SubscriptionSet ss){
    Env.dprintln(dbg, "informAddInvalSubscriptionFailed"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddBodySubscriptionFailed(NodeId senderNodeId, 
                                              NodeId receiverNodeId, 
                                              SubscriptionSet ss){
   Env.dprintln(dbg, "informAddBodySubscriptionFailed"+senderNodeId+":"+receiverNodeId+":"+ss);
  }
  
  
}
//---------------------------------------------------------------------------
/* $Log: StressTestClientPolicy.java,v $
/* Revision 1.5  2007/11/28 08:11:34  nalini
/* safety policy module and example checked in
/*
/* Revision 1.4  2007/03/09 21:46:09  nalini
/* added 2 events: informAddInvalSubscriptionFailed & informAddBodySubscriptionFailed
/*
/* Revision 1.3  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.2  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.1  2006/10/13 20:48:22  nalini
/* StressTestUnit added
/*
*/
//---------------------------------------------------------------------------
