//---------------------------------------------------------------------------
/* TwoServerBayouClient.java
 * 
 * 2-Server Experiment for Bayou
 * -  measures the time it takes to propagate writes
 * -  Server Writes files
 * -  Client Sets up Subscriptions
 * -  Client mesures time to receive last update
 * -  The time retured includes the subscription set up cost
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;

public class TwoServerBayouClient{

  
  //---------------------------------------------------------------------------
  // Testing functions
  //---------------------------------------------------------------------------
 
  public static void main(String[] args){
    
    if(args.length < 4){
      System.out.println("Usage: TwoServerBayouClient <bchost> <bcport>" +
                         "<nWrites> <sizeOfWrites>");
      System.exit(-1);
    }

    String bcHost = args[0];
    int bcPort = (new Integer(args[1])).intValue();
    int nWrites = (new Integer(args[2])).intValue();
    int size = (new Integer(args[3])).intValue();
     
 

    String path = "BayouTest.db";
    String configPath = "BayouTest.config";
    String p2ConfigPath = "BayouTest.p2.config";   
    //setupConfig(configPath, p2ConfigPath);

    NodeId serverNodeId = new NodeId(0);
    NodeId myNodeId = new NodeId(1);
    BarrierClient bc = new BarrierClient(bcHost,bcPort, 1);
    Policy policy = new NullPolicy();
    P2Runtime runtime = new P2Runtime(configPath, p2ConfigPath, myNodeId, true, policy, false);
    policy.setRuntime(runtime);
    runtime.start();
    AllReadBlockAllWriteBoundInterface lInterface = 
      new AllReadBlockAllWriteBoundInterface(runtime.getController(), runtime.getCore());
   
    
   try{
     System.out.println("Barrier 1: Client waiting for server to start");
     bc.sendBarrierRequest(-1, -1); // wait for server to start
     
     System.out.println("Barrier 2: Waiting for Server to write data");
     bc.sendBarrierRequest(-1, -1); // wait for Server to write data

     //establish subscriptions
     long startTime = System.currentTimeMillis();
     SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
     runtime.addInvalSubscription(serverNodeId, ss, false);
     
    
     //make sure we have got all the writes
     while(true){
	 try{
	     lInterface.sync(new AcceptStamp(nWrites-1, serverNodeId));
	     break;
	 }catch(InterruptedException ie){
	     //ignore
	 }
     }
     long endTime = System.currentTimeMillis();
     System.out.println("Barrier 3: Received all the writes");
     bc.sendBarrierRequest(-1, -1); // wait for server to write data
     
     //Sanity Checking
     System.out.println("Sanity Checking:  trying to read data");
     
     ObjId o = new ObjId("/" + (nWrites-1));
     
     while(true){
	 try{
	     ImmutableBytes imb=lInterface.read(o, 0, size);
	     //System.out.println(o + ":" + imb);
	     break;
	 }catch(ObjNotFoundException e){
	     //ignore
	     Thread.currentThread().sleep(50);
	 }
     }

     bc.sendBarrierRequest(-1, -1); // Tell server that we are done
     
     System.out.println("Time to  propagate writes = " + (endTime - startTime) + " ms");
     System.out.println("BayouClient Done");
     System.exit(0);
   }catch(Exception e){
     e.printStackTrace();
   }
    
  }


  private static void setupConfig(String configPath, String p2ConfigPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                            Long.MAX_VALUE);

   Config.addOneNodeConfig(new NodeId(1),
                            "localhost",
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                            "/tmp/ufs1",
                            "/*",
                            -1L,
                            "localhost",
                            9893,
                            9894,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                             Long.MAX_VALUE);

    Config.addOneNodeConfig(new NodeId(2),
                            "localhost",
                            9788,
                            9789,
                            9791,
                            9792,
                            9790,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9793,
                            9794,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                            Long.MAX_VALUE);


   Config.writeToFile(configPath);

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(0), 5, 5, 3000, 3000, 2, 2, 2, 5, 5);
   P2Config.addOneNodeConfig(new NodeId(1), 5, 5, 3000, 3000, 2, 2, 2, 5, 5);
   P2Config.addOneNodeConfig(new NodeId(2), 5, 5, 3000, 3000, 2, 2, 2, 5, 5);
   P2Config.writeToFile(p2ConfigPath);
  }
}


//---------------------------------------------------------------------------
/* $Log: TwoServerBayouClient.java,v $
/* Revision 1.4  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.3  2007/03/09 03:01:38  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.2  2007/03/01 06:38:24  nalini
/* fixed compilation errors
/*
/* Revision 1.1  2006/04/23 20:06:43  nalini
/* *** empty log message ***
/*
/*
 */
//---------------------------------------------------------------------------
