//---------------------------------------------------------------------------
/* TwoServerBayouClient.java
 * 
 * 2-Server Experiment for Bayou
 * measures the time to takes to propagate writes
 * -  measures the time it takes to propagate writes
 * -  Server Writes files
 * -  Client Sets up Subscriptions
 * -  Client mesures time to receive last update
 * -  The time retured includes the subscription set up cost
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;

public class TwoServerBayouServer{

  //---------------------------------------------------------------------------
  // Testing functions
  //---------------------------------------------------------------------------
 
  public static void main(String[] args){
    
    if(args.length < 4){
      System.out.println("Usage: TwoServerBayouServer <bchost> <bcport>" +
                         "<nWrites> <sizeOfWrites>");
      System.exit(-1);
    }

    String bcHost = args[0];
    int bcPort = (new Integer(args[1])).intValue();
    int nWrites = (new Integer(args[2])).intValue();
    int size = (new Integer(args[3])).intValue();

    String path = "BayouTest.db";
    String configPath = "BayouTest.config";
    String p2ConfigPath = "BayouTest.p2.config";   
    setupConfig(configPath, p2ConfigPath);

     

    NodeId myNodeId = new NodeId(0);
    BarrierClient bc = new BarrierClient(bcHost,bcPort, 0);
    Policy policy = new NullPolicy();
    P2Runtime runtime = new P2Runtime(configPath, p2ConfigPath, myNodeId, true, policy, false);
    policy.setRuntime(runtime);
    runtime.start();
    AllReadBlockAllWriteBoundInterface lInterface = 
      new AllReadBlockAllWriteBoundInterface(runtime.getController(), runtime.getCore());
   
    
   try{
     byte b[] = new byte[size];
     for(int i = 0; i < size; i++){
       b[i]=(byte)66; //"B"
     }

    
     System.out.println("Barrier 1: waiting for server to start");
     bc.sendBarrierRequest(-1, -1); // wait for client to start
    
     //write the data
     for(int i = 0; i < nWrites; i++){
       ObjId o = new ObjId ("/"+i);
       lInterface.write(o, 0, size, b);
     }
     System.out.println("Barrier2: Finished Writing data");
     bc.sendBarrierRequest(-1, -1); // wait for client to read data
     
     System.out.println("Barrier 3: Waiting for Client to Read data");
     bc.sendBarrierRequest(-1, -1); //Client finished writing
  
     bc.sendBarrierRequest(-1, -1); // we are done
     
     System.out.println("TestServer Done");
     System.exit(0);
   }catch(Exception e){
     e.printStackTrace();
   }
    
  }


private static void setupConfig(String configPath, String p2ConfigPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                            Long.MAX_VALUE);

   Config.addOneNodeConfig(new NodeId(1),
                            "localhost",
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                            "/tmp/ufs1",
                            "/*",
                            -1L,
                            "localhost",
                            9893,
                            9894,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                             Long.MAX_VALUE);

    Config.addOneNodeConfig(new NodeId(2),
                            "localhost",
                            9788,
                            9789,
                            9791,
                            9792,
                            9790,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9793,
                            9794,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                            Long.MAX_VALUE);


   Config.writeToFile(configPath);

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(0), 5, 5, 3000, 3000, 2, 2, 2, 5, 5);
   P2Config.addOneNodeConfig(new NodeId(1), 5, 5, 3000, 3000, 2, 2, 2, 5, 5);
   P2Config.addOneNodeConfig(new NodeId(2), 5, 5, 3000, 3000, 2, 2, 2, 5, 5);
   P2Config.writeToFile(p2ConfigPath);
  }
}


//---------------------------------------------------------------------------
/* $Log: TwoServerBayouServer.java,v $
/* Revision 1.3  2007/03/09 03:01:38  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.2  2007/03/01 06:38:24  nalini
/* fixed compilation errors
/*
/* Revision 1.1  2006/04/23 20:06:43  nalini
/* *** empty log message ***
/*
 *
 */
//---------------------------------------------------------------------------
