//---------------------------------------------------------------------------
/* HandlerTest_Helper.java
 *
 * Writes objects
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.lang.*;

public class HandlerTest_Helper {
  
  static P2Runtime runtime;
  static LocalInterface localInterface;

 private static void startOverlogNode() throws Exception {
   OverlogPolicy overlogPolicy = new OverlogPolicy(HandlerTest.OVERLOG_PATH, 
                                                   new NodeId(HandlerTest.WRITER_NODE_ID),
                                                   HandlerTest.NODEID_MAP_PATH);
    runtime = new P2Runtime(HandlerTest.CONFIG_PATH, 
                            HandlerTest.CONFIG_P2_PATH, 
                            new NodeId( HandlerTest.WRITER_NODE_ID), 
                            true, overlogPolicy, false);
    overlogPolicy.setRuntime(runtime);
    runtime.start();
    overlogPolicy.startOverlog();

    localInterface = new LocalInterface(runtime.getController(), runtime.getCore());
  }

//---------------------------------------------------------------------------
// Write Objects 
//---------------------------------------------------------------------------

  public static void writeStuff(byte value){

    byte[] b = new byte[HandlerTest.sizeOfWrites];
    for(int i = 0; i < HandlerTest.sizeOfWrites; i++){
      b[i] = value;
    }

    ImmutableBytes imb = new ImmutableBytes(b);
    for (int i=0; i < HandlerTest.numOfObjs; i++){
      ObjId objId = new ObjId("/"+ i);
      try{
	localInterface.write(objId, 0, HandlerTest.sizeOfWrites, imb, false);
	}catch(Exception e){
	  e.printStackTrace();
	  assert(false);
	}
    }

  }

  public static void writeStuff2(byte value){

    byte[] b = new byte[HandlerTest.sizeOfWrites];
    for(int i = 0; i < HandlerTest.sizeOfWrites; i++){
      b[i] = value;
    }

    ImmutableBytes imb = new ImmutableBytes(b);
    for (int i=0; i < HandlerTest.numOfObjs; i++){
      ObjId objId = new ObjId("/"+ i);
      try{
	localInterface.write(objId, 0, HandlerTest.sizeOfWrites, imb, true);
	}catch(Exception e){
	  e.printStackTrace();
	  assert(false);
	}
    }
     System.out.println("finished bound write");

  }

  public static void writeStuff3(byte value){

    byte[] b = new byte[HandlerTest.sizeOfWrites];
    for(int i = 0; i < HandlerTest.sizeOfWrites; i++){
      b[i] = value;
    }

    ImmutableBytes imb = new ImmutableBytes(b);
    for (int i=0; i < HandlerTest.numOfObjs; i++){
      ObjId objId = new ObjId("/"+ i);
      try{
	localInterface.write(objId, 0, HandlerTest.sizeOfWrites, imb, false,Long.MAX_VALUE, true);
	}catch(Exception e){
	  e.printStackTrace();
	  assert(false);
	}
    }

     System.out.println("finished embargoed write");

  }


//---------------------------------------------------------------------------
// Main method  - implements the "writer"
//---------------------------------------------------------------------------
  public static void main(String[] args) {
    try{
      
      BarrierClient c =  new BarrierClient("localhost", 
                                          HandlerTest.BARRIER_PORT,
                                          1);
      c.sendBarrierRequest(0, 1); // Wait for env to be set up

      startOverlogNode();
      
      Thread.currentThread().sleep(10000); //wait for overlog to start
      c.sendBarrierRequest(0, 1); // Wait to "Go"
      
      System.out.println("Handler_Helper starting to write stuff");
      writeStuff(HandlerTest.initialValue);
      
      System.out.println("Handler_Helper finished writing stuff");
    
      c.sendBarrierRequest(0, 1); // finished writing


      c.sendBarrierRequest(0, 1); // Finished Reading Data

      writeStuff2(HandlerTest.secondValue);

      writeStuff3(HandlerTest.thirdValue);

          
    }catch(Exception e) {
      e.printStackTrace();
    }

  }
  
}

//---------------------------------------------------------------------------
/* $Log: HandlerTest_Helper.java,v $
/* Revision 1.3  2007/03/01 06:38:24  nalini
/* fixed compilation errors
/*
/* Revision 1.2  2006/10/18 18:40:12  nalini
/* embargo write works
/*
/* Revision 1.1  2006/10/17 23:39:51  nalini
/* handler test added
/*
*/
//---------------------------------------------------------------------------