//---------------------------------------------------------------------------
/* OverlogDemandReadTest.java
 *
 * Reads objects, if there is a read miss, demands read from server
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.util.*;
import java.io.*;
import java.lang.*;

public class OverlogDemandReadTest { 

  static private Process rmiRegistry;
  static private BarrierServer barrierServer;
  protected static int BARRIER_PORT = 3000;

  protected static String CONFIG_PATH = "test" + File.separatorChar + "tmp.OverlogDemandRead.config";
  protected static String CONFIG_P2_PATH = "test" + File.separatorChar + "tmp.OverlogDemandRead.p2config";
  protected static String NODEID_MAP_PATH = "test" + File.separatorChar + "tmp.OverlogDemandRead.map";
  protected static String OVERLOG_PATH = "DemandRead.olg";

  protected static long READER_NODE_ID = 0;
  protected static long WRITER_NODE_ID = 1;

  protected static int sizeOfWrites = 20;
  protected static int numOfObjs = 30;
  protected static byte initialValue = 65; //"A";
  protected static byte finalValue = 66; //"B"; 

  static URAOverlogNode uraNode;
  static AllReadBlockAllWriteUnboundInterface localInterface;

  private static void setUpEnv() throws Exception{

    try{
      Process p = Runtime.getRuntime().exec("./killRMIRegistry.sh");
      p.waitFor();
    }
    catch(Exception e){
      // Non-fatal exception; we just killed it to 
      // ensure we could start it. Now try starting it.
    }

    //
    // Start the registry
    //
    //rmiRegistry = Runtime.getRuntime().exec("rmiregistry");
    //System.out.println("rmiregistry started");
    Thread.sleep(2000);

    //
    // Start barrier server - for client and server to synch with each other
    //
    
    barrierServer = new BarrierServer(BARRIER_PORT, 2, 4);
    barrierServer.start();

    //
    // make the config files
    //
    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(NODEID_MAP_PATH);
  }

  private static void tearDown() throws Exception {
    rmiRegistry.destroy();
    System.out.println("rmiregistry terminated");
  }


  private static void startOverlogNode() throws Exception {
    uraNode =  new URAOverlogNode(CONFIG_PATH, CONFIG_P2_PATH, new NodeId(READER_NODE_ID), true,
                                  OVERLOG_PATH, NODEID_MAP_PATH, false);
    uraNode.start();
    Thread.currentThread().sleep(500); // wait for overlog to start

    localInterface = new AllReadBlockAllWriteUnboundInterface(uraNode.getP2Runtime().getController(), 
                                                              uraNode.getP2Runtime().getCore());
  }
    
  
//---------------------------------------------------------------------------
// Make configuration files
//---------------------------------------------------------------------------
  private static void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(READER_NODE_ID),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "tmp.DemandReadUnit-" + 
			    READER_NODE_ID + ".db",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(WRITER_NODE_ID),
                            "localhost",
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                           "test" + File.separatorChar + "tmp.DemandReadUnit-" + 
			   WRITER_NODE_ID+".db",
                            "/*",
                            -1L,
                            "localhost",
                            9893,
                            9894,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    
   Config.writeToFile(configPath);
  }

  private static void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(READER_NODE_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(WRITER_NODE_ID), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(new NodeId(READER_NODE_ID), new OverlogId("localhost:5000"));
    NodeIdMap.add(new NodeId(WRITER_NODE_ID), new OverlogId("localhost:5001"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }


//---------------------------------------------------------------------------
//  Reads each object and prints it out
//---------------------------------------------------------------------------

  public static void readStuff(){

    try{
      for (int i=0; i < numOfObjs; i++){
	ObjId objId = new ObjId("/"+ i);
	
	while(true){
	  try{
	    ImmutableBytes b = localInterface.read(objId, 0, sizeOfWrites);
            System.out.println(b);
	    break;
	  }catch(ObjNotFoundException e){
	    //ignore
	    System.out.println("Obj not found exception for "+objId);
	    Thread.currentThread().sleep(500);
	  }
	}
      }
    }catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
  }

//---------------------------------------------------------------------------
// Main method  - implements the "reader"
//---------------------------------------------------------------------------
  public static void main(String[] args) {
    try{
      
      BarrierClient c =  new BarrierClient("localhost", 
                                          BARRIER_PORT,
                                          0);
      //
      //set up stuff
      //
      setUpEnv();
      c.sendBarrierRequest(0, 0); // Inform helper that stuff has be set up

      startOverlogNode();

      c.sendBarrierRequest(0, 0); // Wait to "Go"
      
       c.sendBarrierRequest(0, 0); // Wait for server to write stuff

      System.out.println("OverlogDemandRead_Read starting to read stuff");
      readStuff();
     
      System.out.println("OverlogDemandRead_Reader finished reading stuff");
	
      c.sendBarrierRequest(0, 0); // Finished Reading Data
      
      System.out.println("OverlogDemandRead_Reader Exiting... Bye Bye");
	
      System.exit(0);

    }catch(Exception e) {
      e.printStackTrace();
    }

  }
  
}
//---------------------------------------------------------------------------
/* $Log: OverlogDemandReadTest.java,v $
/* Revision 1.7  2007/09/12 19:07:55  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.6  2007/03/09 03:01:38  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.5  2007/03/08 23:03:15  nalini
/* fixed bugs
/*
/* Revision 1.4  2007/03/01 06:38:24  nalini
/* fixed compilation errors
/*
/* Revision 1.3  2006/10/18 21:57:11  nalini
/* URAOverlogNode added to  make it easier to start overlog and practi in one class
/*
/* Revision 1.2  2006/10/16 20:14:28  nalini
/* updated P2Config
/*
/* Revision 1.1  2006/09/24 20:02:00  nalini
/* simple test scenarion in overlog added
/*
*/
//---------------------------------------------------------------------------
