//---------------------------------------------------------------------------
/* OverlogDemandReadTest_Helper.java
 *
 * Writes objects
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.lang.*;

public class OverlogDemandReadTest_Helper {
  
  static URAOverlogNode uraNode; 
  static AllReadBlockAllWriteUnboundInterface localInterface;

 private static void startOverlogNode() throws Exception {
   uraNode =  new URAOverlogNode(OverlogDemandReadTest.CONFIG_PATH, 
                                 OverlogDemandReadTest.CONFIG_P2_PATH, 
                                 new NodeId(OverlogDemandReadTest.WRITER_NODE_ID), 
                                 true,
                                 OverlogDemandReadTest.OVERLOG_PATH, 
                                 OverlogDemandReadTest.NODEID_MAP_PATH,
                                 false);
    uraNode.start();
    Thread.currentThread().sleep(500); // wait for overlog to start

    localInterface = new AllReadBlockAllWriteUnboundInterface(uraNode.getP2Runtime().getController(), 
                                                              uraNode.getP2Runtime().getCore());
  }

//---------------------------------------------------------------------------
// Write Objects 
//---------------------------------------------------------------------------

  public static void writeStuff(byte value){

    byte[] b = new byte[OverlogDemandReadTest.sizeOfWrites];
    for(int i = 0; i < OverlogDemandReadTest.sizeOfWrites; i++){
      b[i] = value;
    }

    for (int i=0; i < OverlogDemandReadTest.numOfObjs; i++){
      ObjId objId = new ObjId("/"+ i);
      try{
	localInterface.write(objId, 0, OverlogDemandReadTest.sizeOfWrites, b);
	}catch(Exception e){
	  e.printStackTrace();
	  assert(false);
	}
    }

  }


//---------------------------------------------------------------------------
// Main method  - implements the "writer"
//---------------------------------------------------------------------------
  public static void main(String[] args) {
    try{
      
      BarrierClient c =  new BarrierClient("localhost", 
                                          OverlogDemandReadTest.BARRIER_PORT,
                                          1);
      c.sendBarrierRequest(0, 1); // Wait for env to be set up

      startOverlogNode();
      
      Thread.currentThread().sleep(10000); //wait for overlog to start
      c.sendBarrierRequest(0, 1); // Wait to "Go"
      
      System.out.println("OverlogDemandRead_Helper starting to write stuff");
      writeStuff(OverlogDemandReadTest.initialValue);
      
      System.out.println("OverlogDemandRead_Helper finished writing stuff");
    
      c.sendBarrierRequest(0, 1); // finished writing


      c.sendBarrierRequest(0, 1); // Finished Reading Data

      System.exit(0);
    
    }catch(Exception e) {
      e.printStackTrace();
    }

  }
  
}

//---------------------------------------------------------------------------
/* $Log: OverlogDemandReadTest_Helper.java,v $
/* Revision 1.4  2007/09/12 19:07:55  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.3  2007/03/01 06:38:24  nalini
/* fixed compilation errors
/*
/* Revision 1.2  2006/10/18 21:57:11  nalini
/* URAOverlogNode added to  make it easier to start overlog and practi in one class
/*
/* Revision 1.1  2006/09/24 20:02:00  nalini
/* simple test scenarion in overlog added
/*
*/
//---------------------------------------------------------------------------