//---------------------------------------------------------------------------
/* PersistentInterfaceTest.java
 * 
 * To test the persistent tuple interface
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.util.*;
import java.io.*;

public class PersistentInterfaceTest {

  protected static String CONFIG_PATH = "test" + File.separatorChar + "tmp.PersistentTuplInterfaceTest.config";
  protected static String CONFIG_P2_PATH = "test" + File.separatorChar + "tmp.PersistentTupleInterfaceTest.p2config";
  protected static String NODEID_MAP_PATH = "test" + File.separatorChar + "tmp.PersistentTupleInterfaceTest.map";
  protected static String OVERLOG_PATH = "PersistentTuple.olg";
  protected NodeId nodeId = new NodeId(0);

  private Process rmiregistry;
  private URAOverlogNode overlogNode;


   
//---------------------------------------------------------------------------
//  Basic Constructor 
//---------------------------------------------------------------------------
  public PersistentInterfaceTest(){

    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
    makeNodeIdMap(NODEID_MAP_PATH);


    try{
      Process p = Runtime.getRuntime().exec("./killRMIRegistry.sh");
      p.waitFor();
    }
    catch(Exception e){
      // Non-fatal exception; we just killed it to 
      // ensure we could start it. Now try starting it.
    }
    
    //
    // Start the registry
    //
    try{
      rmiregistry = Runtime.getRuntime().exec("rmiregistry");
      System.out.println("rmiregistry started");      
      Thread.sleep(2000);
    }catch(Exception e){
      e.printStackTrace();
    }

    overlogNode = new URAOverlogNode(CONFIG_PATH,
                                  CONFIG_P2_PATH,
                                  nodeId,
                                  true,
                                  OVERLOG_PATH,
                                  NODEID_MAP_PATH,
                                  false);
                                  
  }  
  
//---------------------------------------------------------------------------
// start()
//---------------------------------------------------------------------------
  public void start(){
    try{
      overlogNode.start();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }  


//---------------------------------------------------------------------------
// shutdown()
//---------------------------------------------------------------------------
  public void shutdown(){
    try{
      overlogNode.shutdown();
      rmiregistry.destroy();
      Thread.sleep(2000);
      System.out.println("rmiregistry terminated");
    }catch(Exception e){
      // e.printStackTrace();
    }
  }  

//---------------------------------------------------------------------------
//  Makes the config file for the experiment
//---------------------------------------------------------------------------
  private void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(nodeId,
                            "localhost",
                            6788,
                            6789,
                            6791,
                            6792,
                            6790,
                            "test" + File.separatorChar + "tmp,OersistentInterfaceTest.db", 
                            "/*",
                            -1L,
                            "localhost",
                            6793,
                            6794,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    
   Config.writeToFile(configPath);
  }

//---------------------------------------------------------------------------
//  Makes the P2 config file for the experiment
//---------------------------------------------------------------------------
  private void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(nodeId, 2, 2, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

 private  void makeNodeIdMap(String nodeIdMapPath) {
    NodeIdMap.createEmptyMap();
    NodeIdMap.add(nodeId, new OverlogId("localhost:5000"));
    NodeIdMap.writeToFile(nodeIdMapPath);
  }

//---------------------------------------------------------------------------
// main method
//---------------------------------------------------------------------------
  public static void main(String[] args) {
    PersistentInterfaceTest test = new PersistentInterfaceTest();
    test.start();
  }
}

//---------------------------------------------------------------------------
/* $Log: PersistentInterfaceTest.java,v $
/* Revision 1.1  2007/07/13 20:10:25  nalini
/* persistentInterface test added
/*
 */
//---------------------------------------------------------------------------

    