//---------------------------------------------------------------------------
/*  PingTestP2Server_Helper.java
 * 
 *  Simple test which reports the time it takes to 
 *  make a local Ping and a remote Ping
 * 
 *  The Helper just starts the overlog file
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class PingTestP2Server_Helper {
  private String olgFilename;  
  private P2ServerInterface p2Server;

  public PingTestP2Server_Helper(String overlog) {
    olgFilename = overlog;
    p2Server = new P2ServerInterface(PingTestP2Server.p2ServerPort2,
				     PingTestP2Server.p2clientPort2,
				     olgFilename,
				     PingTestP2Server.remoteHost,
				     PingTestP2Server.remotePort);
    
  }

  public synchronized void startOverlog(){
    try{ 
      OverlogThread t = new OverlogThread(p2Server);
      t.start();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

  public static void main(String[] args) {
    if (args.length <1 ) {
      System.out.println("Usage: PingTestP2Server_Helper <overlogFilename>");
      return;
    }

    BarrierClient c = new BarrierClient(PingTestP2Server.localHost, PingTestP2Server.barrierPort, 1);

    PingTestP2Server_Helper pingTest_Helper = new PingTestP2Server_Helper(args[0]);
    System.out.println("Helper inititalized");
    c.sendBarrierRequest(0, 1); // wait for test to initialize
   
    pingTest_Helper.startOverlog();
    System.out.println("Overlog started");
    c.sendBarrierRequest(0, 1); // wait for overlog to start

    c.sendBarrierRequest(0, 1); // wait test to end
    System.out.println("bye bye");
    System.exit(0);
  }
}

//---------------------------------------------------------------------------
/* $Log: PingTestP2Server_Helper.java,v $
/* Revision 1.2  2007/03/18 04:44:20  nalini
/* minor update
/*
/* Revision 1.1  2007/03/18 04:12:22  nalini
/* updated ping test
/*
/*
*/
//---------------------------------------------------------------------------
