//---------------------------------------------------------------------------
/*  PingTest_Helper.java
 * 
 *  Simple test which reports the time it takes to 
 *  make a local Ping and a remote Ping
 * 
 *  The Helper just starts the overlog file
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class PingTest_Helper {
  private String olgFilename;  
  private P2JavaWrapper p2Wrapper;

  public PingTest_Helper(String overlog) {
    olgFilename = overlog;
    p2Wrapper = new P2JavaWrapper(olgFilename,
				  PingTest.remoteHost,
				  PingTest.remotePort);
    
  }

  public synchronized void startOverlog(){
    try{ 
      OverlogThread t = new OverlogThread(p2Wrapper);
      t.start();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

  public static void main(String[] args) {
    if (args.length <1 ) {
      System.out.println("Usage: PingTest_Helper <overlogFilename>");
      return;
    }

    BarrierClient c = new BarrierClient(PingTest.localHost, PingTest.barrierPort, 1);

    PingTest_Helper pingTest_Helper = new PingTest_Helper(args[0]);
    System.out.println("Helper inititalized");
    c.sendBarrierRequest(0, 1); // wait for test to initialize
   
    pingTest_Helper.startOverlog();
    System.out.println("Overlog started");
    c.sendBarrierRequest(0, 1); // wait for overlog to start

    c.sendBarrierRequest(0, 1); // wait test to end
    System.out.println("bye bye");
    System.exit(0);
  }
}

//---------------------------------------------------------------------------
/* $Log: PingTest_Helper.java,v $
/* Revision 1.1  2007/02/16 16:42:05  nalini
/* Test to measure ping performance added
/*
*/
//---------------------------------------------------------------------------
