//---------------------------------------------------------------------------
/*  PingThroughPut Test
 * 
 *  Simple test which reports the time and
 *  make NUM_PINGS local pings and remote pings
 *  thro the P2Server interface
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------


public class PingThroughputTest {

  public static String localHost = "riva";
  public static String localPort = "5000";
  public static String remoteHost = "rivera";
  public static String remotePort = "5001";
  public static int p2ServerPort1 = 4000;
  public static int p2ServerPort2 = 4001;
  public static int p2clientPort1 = 4500;
  public static int p2clientPort2 = 4501;
  public static int barrierPort = 8000;

  public static int NUM_PINGS = 5000;

  private String olgFilename;  
  private P2ServerInterface p2Server;
  private Watcher watcher;
  private Overlog overlog;
  private Tuple localPingTuple;
  private Tuple remotePingTuple;

  private long localPingStartTime;
  private long localPingEndTime;
  private long remotePingStartTime;
  private long remotePingEndTime;
 
    

  public PingThroughputTest(String overlog){
    this.olgFilename = overlog;

    p2Server = new P2ServerInterface(p2ServerPort1,
				     p2clientPort1,
				     olgFilename,
				     localHost,
				     localPort);

    watcher = new PingTestWatcher(this);
    String[] watchTuples = {"localPingReply", "remotePingReply"};

    p2Server.setWatchTuples(watchTuples);
    p2Server.setWatcher(watcher);

    String[] stringA = {"localPingRequest", 
			  localHost+ ":" + localPort};
    localPingTuple = new Tuple(stringA);

    stringA = new String[] {"remotePingRequest", 
                            localHost+ ":" + localPort,
                            remoteHost+ ":" + remotePort};
    remotePingTuple = new Tuple(stringA);
  }
   

  public synchronized void startOverlog() throws Exception{
    // starts overlog in another htread
    wait(1000);
    OverlogThread t = new OverlogThread(p2Server);
    t.start();
    wait(3000);
  }
				       

  public synchronized void localPing() {
    try{     
      localPingStartTime = System.currentTimeMillis();
      for(int i=0; i< NUM_PINGS; i++){
        p2Server.insertTuple(localPingTuple);
	// wait();
      }
      localPingEndTime = System.currentTimeMillis();
      System.out.println("LocalPing:" + (localPingEndTime - localPingStartTime) + "ms for " + NUM_PINGS + "pings");
      System.out.println("Throughput:" + NUM_PINGS * 1000/(localPingEndTime - localPingStartTime));
    }catch (Exception e) {
    }
  }

  public synchronized void receivedLocalPingReply() {
    notifyAll();
  }

  
  public synchronized void remotePing() {
    try{
      remotePingStartTime = System.currentTimeMillis();
      for(int i=0; i< NUM_PINGS; i++) {
        p2Server.insertTuple(remotePingTuple);
	// wait();
      }
      remotePingEndTime = System.currentTimeMillis();
      System.out.println("RemotPing:" + (remotePingEndTime - remotePingStartTime) + "ms for " +  NUM_PINGS + "pings");
      System.out.println("Throughput:" + NUM_PINGS*1000/(remotePingEndTime - remotePingStartTime));
    }catch (Exception e) {
    }
  }

  public synchronized void receivedRemotePingReply() {
    notifyAll();
  }
    
  public static void main(String[] args) {
    if (args.length <2 ) {
      System.out.println("Usage: PingThrouputTest <type=0|1> <overlogFilename>");
      return;
    }
    
    if ((new Integer(args[0])).intValue() == 0) {
      runLocalTest(args[1]);
    } else {
      runRemoteTest(args[1]);
    }
    
    System.out.println("Test ended");
    System.exit(0);
    
  }
      
 
   
  public static void runLocalTest(String olgFile) {
    try{
      PingThroughputTest pingTest = new PingThroughputTest(olgFile);
      System.out.println("PingTest Initialized");
      
      System.out.println("Starting overlog");
      pingTest.startOverlog();
      
      System.out.println("LocalPingTest ...");
      pingTest.localPing();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

  public static void runRemoteTest(String olgFile){
    try{
      BarrierServer bServer= new BarrierServer(barrierPort, 2, 3);
      bServer.start();
      
      BarrierClient c = new BarrierClient(localHost, barrierPort, 0);
      
      PingThroughputTest pingTest = new PingThroughputTest(olgFile);

      System.out.println("PingTest Initialized, waiting for Helper to start");
      c.sendBarrierRequest(0, 0); // wait for helper to initialize
      
      System.out.println("Starting overlog");
      pingTest.startOverlog();
      c.sendBarrierRequest(0, 0); // wait for overlog to start
      
      System.out.println("RemotePingTest ...");
      pingTest.remotePing();
      
      c.sendBarrierRequest(0, 0); // Test Ended
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

  class PingTestWatcher implements Watcher {
    PingThroughputTest test;

    public PingTestWatcher(PingThroughputTest test) {
      this.test = test;
    }

    public synchronized void receivedTuple(Tuple tp) {
      if(tp.getItem(0).equals("localPingReply")) {
	test.receivedLocalPingReply();
      } 
      else if(tp.getItem(0).equals("remotePingReply")){
	test.receivedRemotePingReply();
      }
      else {
        System.out.println("Unrecognized tuple received: " + tp);
      }
    } 
  }
}
    
//---------------------------------------------------------------------------
/* $Log: PingThroughputTest.java,v $
/* Revision 1.2  2007/03/19 20:04:33  nalini
/* updated throughput test
/*
/* Revision 1.1  2007/03/18 05:37:39  nalini
/* PingThroughputTest added
/*
*/
//---------------------------------------------------------------------------
