//---------------------------------------------------------------------------
/*  PingThroughputTest2_Helper.java
 * 
 *  Simple test which reports the time it takes to 
 *  make a local Ping and a remote Ping
 * 
 *  The Helper just starts the overlog file
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class PingThroughputTest2_Helper {
  private String olgFilename;  
  private P2JavaWrapper p2wrapper;

  public PingThroughputTest2_Helper(String overlog) {
    olgFilename = overlog;
    p2wrapper = new P2JavaWrapper(olgFilename,
                                  PingThroughputTest_2.remoteHost,
                                  PingThroughputTest_2.remotePort);
  }

  public synchronized void startOverlog(){
    try{ 
      OverlogThread t = new OverlogThread(p2wrapper);
      t.start();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

  public static void main(String[] args) {
    if (args.length <1 ) {
      System.out.println("Usage: PingThroughputTest2_Helper <overlogFilename>");
      return;
    }

    BarrierClient c = new BarrierClient(PingThroughputTest_2.localHost, 
                                        PingThroughputTest_2.barrierPort, 1);

    PingThroughputTest2_Helper pingTest_Helper = new PingThroughputTest2_Helper(args[0]);
    System.out.println("Helper inititalized");
    c.sendBarrierRequest(0, 1); // wait for test to initialize
   
    pingTest_Helper.startOverlog();
    System.out.println("Overlog started");
    c.sendBarrierRequest(0, 1); // wait for overlog to start

    c.sendBarrierRequest(0, 1); // wait test to end
    System.out.println("bye bye");
    System.exit(0);
  }
}

//---------------------------------------------------------------------------
/* $Log: PingThroughputTest2_Helper.java,v $
/* Revision 1.1  2007/03/18 05:58:59  nalini
/* Pingthroughput test 2 added
/*
*/
//---------------------------------------------------------------------------
