//---------------------------------------------------------------------------
/*  PingThroughPutTest_2
 * 
 *  Simple test which reports the time and
 *  make NUM_PINGS local pings and remote pings
 *  thro the P2JavaWrapper interface
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------


public class PingThroughputTest_2 {

  public static String localHost = "riva";
  public static String localPort = "5000";
  public static String remoteHost = "river";
  public static String remotePort = "5001";
 
  public static int barrierPort = 8000;

  public static int NUM_PINGS = 5000;

  private String olgFilename;  
  private P2JavaWrapper p2wrapper;
  private Watcher watcher;
  private Overlog overlog;
  private Tuple localPingTuple;
  private Tuple remotePingTuple;

  private long localPingStartTime;
  private long localPingEndTime;
  private long remotePingStartTime;
  private long remotePingEndTime;
 
    

  public PingThroughputTest_2(String overlog){
    this.olgFilename = overlog;

    p2wrapper = new P2JavaWrapper(olgFilename,
                                  localHost,
                                  localPort);

    watcher = new PingTestWatcher(this);
    String[] watchTuples = {"localPingReply", "remotePingReply"};

    p2wrapper.setWatchTuples(watchTuples);
    p2wrapper.setWatcher(watcher);

    String[] stringA = {"localPingRequest", 
			  localHost+ ":" + localPort};
    localPingTuple = new Tuple(stringA);

    stringA = new String[] {"remotePingRequest", 
                            localHost+ ":" + localPort,
                            remoteHost+ ":" + remotePort};
    remotePingTuple = new Tuple(stringA);
  }
   

  public synchronized void startOverlog() throws Exception{
    // starts overlog in another htread
    wait(1000);
    OverlogThread t = new OverlogThread(p2wrapper);
    t.start();
    wait(3000);
  }
				       

  public synchronized void localPing() {
    try{     
      localPingStartTime = System.currentTimeMillis();
      for(int i=0; i< NUM_PINGS; i++){
        p2wrapper.insertTuple(localPingTuple);
        //wait(1);
      }
      localPingEndTime = System.currentTimeMillis();
      System.out.println("LocalPing:" + (localPingEndTime - localPingStartTime) + "ms for " + NUM_PINGS + "pings");
      System.out.println("Throughput:" + NUM_PINGS * 1000/(localPingEndTime - localPingStartTime));
    }catch (Exception e) {
    }
  }

  public synchronized void receivedLocalPingReply() {
    notifyAll();
  }

  
  public synchronized void remotePing() {
    try{
      remotePingStartTime = System.currentTimeMillis();
      for(int i=0; i< NUM_PINGS; i++) {
        p2wrapper.insertTuple(remotePingTuple);
        ///wait();
      }
      remotePingEndTime = System.currentTimeMillis();
      System.out.println("RemotPing:" + (remotePingEndTime - remotePingStartTime) + "ms for " +  NUM_PINGS + "pings");
      System.out.println("Throughput:" + NUM_PINGS*1000/(remotePingEndTime - remotePingStartTime));
    }catch (Exception e) {
    }
  }

  public synchronized void receivedRemotePingReply() {
    notifyAll();
  }
    
  public static void main(String[] args) {
    if (args.length <2 ) {
      System.out.println("Usage: PingThrouputTest <type=0|1> <overlogFilename>");
      return;
    }
    
    if ((new Integer(args[0])).intValue() == 0) {
      runLocalTest(args[1]);
    } else {
      runRemoteTest(args[1]);
    }
    
    System.out.println("Test ended");
    System.exit(0);
    
  }
      
 
   
  public static void runLocalTest(String olgFile) {
    try{
      PingThroughputTest_2 pingTest = new PingThroughputTest_2(olgFile);
      System.out.println("PingTest Initialized");
      
      System.out.println("Starting overlog");
      pingTest.startOverlog();
      
      System.out.println("LocalPingTest ...");
      pingTest.localPing();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

  public static void runRemoteTest(String olgFile){
    try{
      BarrierServer bServer= new BarrierServer(barrierPort, 2, 3);
      bServer.start();
      
      BarrierClient c = new BarrierClient(localHost, barrierPort, 0);
      
      PingThroughputTest_2 pingTest = new PingThroughputTest_2(olgFile);

      System.out.println("PingTest Initialized, waiting for Helper to start");
      c.sendBarrierRequest(0, 0); // wait for helper to initialize
      
      System.out.println("Starting overlog");
      pingTest.startOverlog();
      c.sendBarrierRequest(0, 0); // wait for overlog to start
      
      System.out.println("RemotePingTest ...");
      pingTest.remotePing();
      
      c.sendBarrierRequest(0, 0); // Test Ended
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

  class PingTestWatcher implements Watcher {
    PingThroughputTest_2 test;

    public PingTestWatcher(PingThroughputTest_2 test) {
      this.test = test;
    }

    public synchronized void receivedTuple(Tuple tp) {
      if(tp.getItem(0).equals("localPingReply")) {
	test.receivedLocalPingReply();
      } 
      else if(tp.getItem(0).equals("remotePingReply")){
	test.receivedRemotePingReply();
      }
      else {
        System.out.println("Unrecognized tuple received: " + tp);
      }
    } 
  }
}
    
//---------------------------------------------------------------------------
/* $Log: PingThroughputTest_2.java,v $
/* Revision 1.2  2007/03/19 20:04:33  nalini
/* updated throughput test
/*
/* Revision 1.1  2007/03/18 05:58:59  nalini
/* Pingthroughput test 2 added
/*
*/
//---------------------------------------------------------------------------
