//---------------------------------------------------------------------------
/*  PingThroughputTest_Helper.java
 * 
 *  Simple test which reports the time it takes to 
 *  make a local Ping and a remote Ping
 * 
 *  The Helper just starts the overlog file
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class PingThroughputTest_Helper {
  private String olgFilename;  
  private P2ServerInterface p2Server;

  public PingThroughputTest_Helper(String overlog) {
    olgFilename = overlog;
    p2Server = new P2ServerInterface(PingThroughputTest.p2ServerPort2,
				     PingThroughputTest.p2clientPort2,
				     olgFilename,
				     PingThroughputTest.remoteHost,
				     PingThroughputTest.remotePort);
    
  }

  public synchronized void startOverlog(){
    try{ 
      OverlogThread t = new OverlogThread(p2Server);
      t.start();
    }catch(Exception e) {
      e.printStackTrace();
    }
  }

  public static void main(String[] args) {
    if (args.length <1 ) {
      System.out.println("Usage: PingThroughputTest_Helper <overlogFilename>");
      return;
    }

    BarrierClient c = new BarrierClient(PingThroughputTest.localHost, PingThroughputTest.barrierPort, 1);

    PingThroughputTest_Helper pingTest_Helper = new PingThroughputTest_Helper(args[0]);
    System.out.println("Helper inititalized");
    c.sendBarrierRequest(0, 1); // wait for test to initialize
   
    pingTest_Helper.startOverlog();
    System.out.println("Overlog started");
    c.sendBarrierRequest(0, 1); // wait for overlog to start

    c.sendBarrierRequest(0, 1); // wait test to end
    System.out.println("bye bye");
    System.exit(0);
  }
}

//---------------------------------------------------------------------------
/* $Log: PingThroughputTest_Helper.java,v $
/* Revision 1.1  2007/03/18 05:37:39  nalini
/* PingThroughputTest added
/*
*/
//---------------------------------------------------------------------------
