//---------------------------------------------------------------------------
/* PadreDemandReadTest
 * 
 * 
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------


public class PadreDemandReadTest {

  PadreNode node;
  SafetyPolicyModule safetyModule;
  boolean verbose = true;

  protected static String CONFIG_PATH = "DemandReadTest.config";
  protected static String CONFIG_P2_PATH = "DemandReadTest.p2config";

  protected  NodeId READER_NODE_ID = new NodeId(0);
  protected  NodeId  WRITER_NODE_ID = new NodeId(1);

  protected static int sizeOfWrites = 100;
  protected static int numObjs = 50; 
  protected static byte value = 65; //A

//---------------------------------------------------------------------------
//  Set up environment in which tests must run
//---------------------------------------------------------------------------
  protected void setUp()  {
    
    makePractiConfig(CONFIG_PATH);
    makeP2Config(CONFIG_P2_PATH);
  }

//---------------------------------------------------------------------------
//  Makes the config file for the experiment
//---------------------------------------------------------------------------
  private void makePractiConfig(String configPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(READER_NODE_ID,
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "DemandReadTest"+
			    READER_NODE_ID + ".db",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
    Config.addOneNodeConfig(WRITER_NODE_ID,
                            "localhost",
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                           "DemandReadTest" + 
			   WRITER_NODE_ID+".db",
                            "/*",
                            -1L,
                            "localhost",
                            9893,
                            9894,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    
   Config.writeToFile(configPath);
  }


//---------------------------------------------------------------------------
//  Makes the P2 config file for the experiment
//---------------------------------------------------------------------------
  private void makeP2Config(String p2ConfigPath){

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(READER_NODE_ID, 0, 0, 10000, 10000, 2, 2, 2, 5, 5);
   P2Config.addOneNodeConfig(WRITER_NODE_ID, 0, 0, 10000, 10000, 2, 2, 2, 5, 5);
   P2Config.writeToFile(p2ConfigPath);
  }

//---------------------------------------------------------------------------
//  Read object
//---------------------------------------------------------------------------

  public void readObj(ObjId objId, SafetyPolicyModule safetyModule){

    byte[] exp = new byte[sizeOfWrites];
    
    for(int i = 0; i < exp.length; i++){
      exp[i] = value;
    }
    ImmutableBytes expected = new ImmutableBytes(exp); 


    try{

      while(true){
        try{
          ImmutableBytes b = safetyModule.read(objId, 0, sizeOfWrites).getBody();
          if(verbose) {
            System.out.println("Obj read: "+ b);
          }
          assert(b.equals(expected)): "Read does not match expected in phase" ;
            break;
         
      }catch(ObjNotFoundException e){
          System.out.println("ObjNotFound");
          Thread.currentThread().sleep(100);
        }
      }
    }catch(Exception e){
      //  e.printStackTrace();
      // assert(false);
    }
  }


//---------------------------------------------------------------------------
// Write objects
//---------------------------------------------------------------------------

  public void writeObj(ObjId objId, ImmutableBytes imb, SafetyPolicyModule saftetyModule){


    try{
      safetyModule.write(objId, 0, imb.getLength(), imb);
    }catch(Exception e){
      e.printStackTrace();
      assert(false);
    }
    
  }

//---------------------------------------------------------------------------
// Start Reader
//---------------------------------------------------------------------------

  public synchronized void startReader(){ 
    try{
      safetyModule = new CausalSafetyModule();
      node = new PadreNode(CONFIG_PATH, CONFIG_P2_PATH, READER_NODE_ID, true, false, 
                           safetyModule,
                           new PadreDemandReadPolicy(WRITER_NODE_ID));
      
      node.start();
      // wait till it starts and connects to server
      System.out.println("Waiting to initialize");
      wait(10000);


      //wait till server finishes writes
      System.out.println("Waiting for server to finish writes");
      wait(5000);

      //reading objects
      System.out.println("Reading objects");
      for(int i = 0; i<numObjs; i++){
        readObj(new ObjId("/" + i), safetyModule);
      }

      System.out.println("Test finished");
    }catch(Exception e) {
      e.printStackTrace();
    }
  }
    

//---------------------------------------------------------------------------
// Start Writer
//---------------------------------------------------------------------------

 public synchronized void startWriter(){ 
    try{
      safetyModule = new CausalSafetyModule();
      node = new PadreNode(CONFIG_PATH, CONFIG_P2_PATH,  WRITER_NODE_ID, true, false, 
                           safetyModule,
                           new NullPolicy());
      
      node.start();
      // wait till it starts and connects to server
      System.out.println("Waiting to initialize");
      wait(5000);


    
      //do writes
      System.out.println("Writing objects");
      byte[] b = new byte[sizeOfWrites];
      for(int i = 0; i < b.length; i++){
        b[i] = value;
      }

      ImmutableBytes imb = new ImmutableBytes(b);
      for(int i = 0; i<numObjs; i++){
        writeObj(new ObjId("/" + i), imb, safetyModule);
      }

      System.out.println("Wait for reader to finish");
    }catch(Exception e) {
      e.printStackTrace();
    }
  }
    
//---------------------------------------------------------------------------
// Main method
//---------------------------------------------------------------------------

  public static void main(String args[]) {
    if (args.length < 1) {
      System.out.println("PadreDemandReadTest [0|1]") ;
      System.exit(0);
    }

    PadreDemandReadTest test = new PadreDemandReadTest();
    test.setUp();

    if(args[0].equals("0")){
      System.out.println("Starting Reader");
      test.startReader();
    }else {
      System.out.println("Starting Writer");
      test.startWriter();
    }
  }
}

//---------------------------------------------------------------------------
/* $Log: PadreDemandReadTest.java,v $
/* Revision 1.1  2007/11/28 08:11:34  nalini
/* safety policy module and example checked in
/*
*/
//---------------------------------------------------------------------------