//---------------------------------------------------------------------------
/* RMITestServer.java
 * 
 * A  3-node test.
 * -  Initiator sets up subscriptions from itself and client to server
 * -  Server makes bounded writes
 * -  Initiator and client read data
 * -  Initiator removes some subscriptions
 * -  Server makes unbounded writes
 * -  Initiator initiates demand reads
 * -  Initiator and client read data
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;

public class RMITestServer {

  //---------------------------------------------------------------------------
  // Testing functions
  //---------------------------------------------------------------------------
 
  public static void main(String[] args){
    
    if(args.length < 4){
      System.out.println("Usage: RMITestServer <bchost> <bcport>" +
                         "<nWrites> <sizeOfWrites>");
      System.exit(-1);
    }

    String bcHost = args[0];
    int bcPort = (new Integer(args[1])).intValue();
    int nWrites = (new Integer(args[2])).intValue();
    int size = (new Integer(args[3])).intValue();

    String path = "randomTest.db";
    String configPath = "randomTest.config";
    String p2ConfigPath = "randomTest.p2.config";   


    try{ 

      NodeId initiatorId = new NodeId(0);
      NodeId clientId =  new NodeId(1);
      NodeId serverId = new NodeId(2);

      NodeId myNodeId = serverId;

      BarrierClient bc = new BarrierClient(bcHost, bcPort, 2);
      Policy policy = new NullPolicy();
      P2Runtime runtime = new P2Runtime(configPath, p2ConfigPath, myNodeId, true, policy, false);
      policy.setRuntime(runtime);
      runtime.start();
      AllReadBlockAllWriteBoundInterface boundInterface = 
	new AllReadBlockAllWriteBoundInterface(runtime.getController(), runtime.getCore());
      AllReadBlockAllWriteUnboundInterface unBoundInterface = 
	new AllReadBlockAllWriteUnboundInterface(runtime.getController(), runtime.getCore());
   
      RuntimeRMIServerImpl runRMIServer = new RuntimeRMIServerImpl(runtime);
      runRMIServer.start();
      RuntimeRMIClient runRMIClient = new RuntimeRMIClient(runtime);


      SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");

      barrier(bc, "Waiting for everyone to start");

      barrier(bc, "Initiator Finished Setting up Subscriptions");
    
      byte b[] = new byte[size];
      for(int i = 0; i < size; i++){
	b[i]=(byte)65; //"A"
      }

      //write the data
      for(int i = 0; i < nWrites; i++){
	ObjId o = new ObjId ("/"+i);
	boundInterface.write(o, 0, size, b);
      }

      barrier(bc, "Server Finished Bound Writes");
      
      barrier(bc, "Finished trying to read data");

      barrier(bc, "Initiator removing Subscriptions");

      for(int i = 0; i < size; i++){
	b[i]=(byte)66; //"B"
      }

      //write the data
      for(int i = 0; i < nWrites; i++){
	ObjId o = new ObjId ("/"+i);
	unBoundInterface.write(o, 0, size, b);
      }

      barrier(bc, "Server Making Unbound Writes");
      
      barrier(bc, "Initiator invoking demand reads");

      barrier(bc, "Finished reading data");

      System.out.println("My Outgoing subscriptions:");
      System.out.println("- inval -" + runtime.getEstablishedOutgoingInvalSubscriptions());
      System.out.println("- body -" + runtime.getEstablishedOutgoingBodySubscriptions());
      System.out.println("Bye-Bye...");

      }catch (Exception e){
      e.printStackTrace();
    }
    
  }

  static int numBarrier = 0;

  public static void barrier(BarrierClient bc, String str){
    numBarrier++;
    System.out.println("Barrier "+numBarrier+" : "+str);
    bc.sendBarrierRequest(-1, -1);
  }

}


//---------------------------------------------------------------------------
/* $Log: RMITestServer.java,v $
/* Revision 1.3  2007/03/01 06:38:24  nalini
/* fixed compilation errors
/*
/* Revision 1.2  2006/10/10 19:46:00  nalini
/* minor bug fix
/*
/* Revision 1.1  2006/06/13 03:49:19  nalini
/* RMI for P2 Runtime Implemented
/*
 */
//---------------------------------------------------------------------------
