//---------------------------------------------------------------------------
/* RandomTestClient.java
 * 
 * Client for 2 server experiments
 * -  Client Sets up Subscriptions
 * -  Server Writes files
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;

public class RandomTestClient{

  static AllReadBlockAllWriteBoundInterface lInterface;

  //---------------------------------------------------------------------------
  // Testing functions
  //---------------------------------------------------------------------------
 
  public static void main(String[] args){
    
    if(args.length < 4){
      System.out.println("Usage: RandomTestClient <bchost> <bcport>" +
                         "<nWrites> <sizeOfWrites>");
      System.exit(-1);
    }

    String bcHost = args[0];
    int bcPort = (new Integer(args[1])).intValue();
    int nWrites = (new Integer(args[2])).intValue();
    int size = (new Integer(args[3])).intValue();
     
 

    String path = "randomTest.db";
    String configPath = "randomTest.config";
    String p2ConfigPath = "randomTest.p2.config";   
    setupConfig(configPath, p2ConfigPath);

    NodeId serverNodeId = new NodeId(0);
    NodeId myNodeId = new NodeId(1);
    BarrierClient bc = new BarrierClient(bcHost,bcPort, 1);
    Policy policy = new NullPolicy();
    P2Runtime runtime = new P2Runtime(configPath, p2ConfigPath, myNodeId, true, policy, false);
    policy.setRuntime(runtime);
    runtime.start();
    lInterface = 
      new AllReadBlockAllWriteBoundInterface(runtime.getController(), runtime.getCore());
   
    
   try{
     
     ObjId o = new ObjId("/0");

     System.out.println("Barrier 1: Client waiting for server to start");
     bc.sendBarrierRequest(-1, -1); // wait for server to start
     printObjStatus(o, size);

     //establish subscriptions
     SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
     runtime.addInvalSubscription(serverNodeId, ss, false);
     runtime.addBodySubscription(serverNodeId, ss);
     Thread.currentThread().sleep(500);
     System.out.println("After Adding subscriptions");
     printObjStatus(o, size);

     System.out.println("Barrier 2:Informing Server that I have set up subscription");
     bc.sendBarrierRequest(-1, -1);
 
     System.out.println("Barrier 3: Waiting for Server to write data");
     bc.sendBarrierRequest(-1, -1); // wait for Server to write data

         
    
     //make sure we have got all the writes
     while(true){
	 try{
	     lInterface.sync(new AcceptStamp(nWrites-1, serverNodeId));
	     break;
	 }catch(InterruptedException ie){
	     //ignore
	 }
     }
     printObjStatus(o, size);

     System.out.println("Barrier 4: Received all the writes");
     bc.sendBarrierRequest(-1, -1); // wait for server to write data
     
     Thread.currentThread().sleep(500);

   //Sanity Checking


     System.out.println("Sanity Checking:  trying to read obj" + o);     
     while(true){
	 try{
	     ImmutableBytes imb=lInterface.read(o, 0, size);
	     System.out.println(o + ":" + imb);
	     break;
	 }catch(ObjNotFoundException e){
	     //ignore
	     Thread.currentThread().sleep(50);
	 }
     }

     bc.sendBarrierRequest(-1, -1); // Tell server that we are done
     
     System.out.println("Client Done");


     System.exit(0);
   }catch(Exception e){
     e.printStackTrace();
   }
    
  }

  private static void printObjStatus(ObjId o, int size){
     try {
       if(lInterface.isPrecise(o)){
	 System.out.println(o + " is Precise");
       } 
       else System.out.println(o + " is Not Precise");
       
       if(lInterface.isValid(o, 0, size)){
	 System.out.println(o + "is Valid");
       } 
       else System.out.println(o + " is not Valid");
	  
     }catch(Exception e){
       System.out.println(e);
     }
  }

  private static void setupConfig(String configPath, String p2ConfigPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                            Long.MAX_VALUE);

   Config.addOneNodeConfig(new NodeId(1),
                            "localhost",
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                            "/tmp/ufs1",
                            "/*",
                            -1L,
                            "localhost",
                            9893,
                            9894,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                             Long.MAX_VALUE);

    Config.addOneNodeConfig(new NodeId(2),
                            "localhost",
                            9788,
                            9789,
                            9791,
                            9792,
                            9790,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9793,
                            9794,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                            Long.MAX_VALUE);


   Config.writeToFile(configPath);

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(0), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(1), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(2), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }
}


//---------------------------------------------------------------------------
/* $Log: RandomTestClient.java,v $
/* Revision 1.10  2007/09/12 19:08:13  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.9  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.8  2007/03/09 03:01:38  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.7  2007/03/01 06:38:24  nalini
/* fixed compilation errors
/*
/* Revision 1.6  2006/10/10 19:46:00  nalini
/* minor bug fix
/*
/* Revision 1.5  2006/08/24 23:08:54  nalini
/* Simple unit test created for P2Runtime
/*
/* Revision 1.4  2006/06/22 18:21:39  nalini
/* added isPrecise and isValid to LocalInterface
/*
/* Revision 1.3  2006/06/14 22:50:09  nalini
/* Changed nice sockets to normal sockets for outgoing body connections
/*
/* Revision 1.2  2006/06/02 22:40:02  nalini
/* merged support for adding and removing ss for outgoing body streams
/*
/* Revision 1.1.2.1  2006/06/02 22:18:39  nalini
/* Supports addition and removeal of SS from Outgoing Body Streams
/*
 */
//---------------------------------------------------------------------------
