//---------------------------------------------------------------------------
/* UnboundedWriteClient.java
 * 
 * Server which makes unbounded writes
 * -  Client Sets up Subscriptions
 * -  Server Writes files
 * -  Client tries to read files
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;

public class UnboundedWriteServer{

  //---------------------------------------------------------------------------
  // Testing functions
  //---------------------------------------------------------------------------
 
  public static void main(String[] args){
    
    if(args.length < 4){
      System.out.println("Usage: UnboundedWriteServer <bchost> <bcport>" +
                         "<nWrites> <sizeOfWrites>");
      System.exit(-1);
    }

    String bcHost = args[0];
    int bcPort = (new Integer(args[1])).intValue();
    int nWrites = (new Integer(args[2])).intValue();
    int size = (new Integer(args[3])).intValue();

    String path = "randomTest.db";
    String configPath = "randomTest.config";
    String p2ConfigPath = "randomTest.p2.config";   
    setupConfig(configPath, p2ConfigPath);

     

    NodeId myNodeId = new NodeId(0);
    BarrierClient bc = new BarrierClient(bcHost,bcPort, 0);
    Policy policy = new NullPolicy();
    P2Runtime runtime = new P2Runtime(configPath, p2ConfigPath, myNodeId, true, policy, false);
    policy.setRuntime(runtime);
    runtime.start();
    AllReadBlockAllWriteUnboundInterface lInterface = 
      new AllReadBlockAllWriteUnboundInterface(runtime.getController(), runtime.getCore());
   
    
   try{
     byte b[] = new byte[size];
     for(int i = 0; i < size; i++){
       b[i]=(byte)66; //"B"
     }

    
      //sleep to make sure subsriptions are done..
     System.out.println("Barrier 1: waiting for client to start");
     bc.sendBarrierRequest(-1, -1); // wait for client to start
    
     System.out.println("Barrier 2: waiting for client to set up subscriptions");
     bc.sendBarrierRequest(-1, -1); //waiting for subscriptions

     System.out.println("writing data");    
     //write the data
     for(int i = 0; i < nWrites; i++){
       ObjId o = new ObjId ("/"+i);
       lInterface.write(o, 0, size, b);
     }
     System.out.println("Barrier 3: Finished Writing data");
     bc.sendBarrierRequest(-1, -1); // wait for client to read data
     
     System.out.println("Barrier 4: Waiting for Client to Read data");
     bc.sendBarrierRequest(-1, -1); //Client finished reading
  
     bc.sendBarrierRequest(-1, -1); // we are done
     
     System.out.println("TestServer Done");
     System.exit(0);
   }catch(Exception e){
     e.printStackTrace();
   }
    
  }


private static void setupConfig(String configPath, String p2ConfigPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                            Long.MAX_VALUE);

   Config.addOneNodeConfig(new NodeId(1),
                            "localhost",
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                            "/tmp/ufs1",
                            "/*",
                            -1L,
                            "localhost",
                            9893,
                            9894,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                             Long.MAX_VALUE);

    Config.addOneNodeConfig(new NodeId(2),
                            "localhost",
                            9788,
                            9789,
                            9791,
                            9792,
                            9790,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9793,
                            9794,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                            Long.MAX_VALUE);


   Config.writeToFile(configPath);

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(0), 5, 5, 10000, 10000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(1), 5, 5, 10000, 10000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(2), 5, 5, 10000, 10000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }
}


//---------------------------------------------------------------------------
/* $Log: UnboundedWriteServer.java,v $
/* Revision 1.5  2007/03/09 03:01:38  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.4  2007/03/01 06:38:24  nalini
/* fixed compilation errors
/*
/* Revision 1.3  2006/10/10 19:46:00  nalini
/* minor bug fix
/*
/* Revision 1.2  2006/06/02 22:40:03  nalini
/* merged support for adding and removing ss for outgoing body streams
/*
/* Revision 1.1.2.1  2006/06/02 22:18:39  nalini
/* Supports addition and removeal of SS from Outgoing Body Streams
/*
 */
//---------------------------------------------------------------------------
