package code;
 /** 
 *  Interface that must be inherited by any class is designed to handle 
 *  changes in PreciseSets 
 **/ 

public interface PSController{

 /** 
 *  Called when the caller is about to apply an invalidate message to 
 *  all overlapping PreciseSets 
 **/ 
  public void
  notifyApplyingInvOverlap(GeneralInv gi, VVMap startVVs, AllPreciseSets aps);

 /** 
 *  Called when the caller is about to apply an invalidate message to 
 *  all non-overlapping PreciseSets 
 **/ 
  public void
  notifyApplyingInvNonOverlap(GeneralInv gi,
                              VVMap startVVs,
                              AllPreciseSets aps);
}
