package code;
 /** 
 *  An iterator used to iterate through all PreciseSets 
 **/ 
import java.util.Vector;
import java.util.LinkedList;

public class PSIterator{

 /** 
 *  Constructor 
 **/ 
  public
  PSIterator(PreciseSet rootPS){
    this.iterQueue = new LinkedList();
    this.iterQueue.addLast(rootPS);
    this.invalid = false;
  }

 /** 
 *  Return the next PS 
 **/ 
  public PreciseSet
  getNext(){
    Vector psChildren = null;
    PreciseSet ps = null;
    PreciseSet childPS = null;

    assert(!this.invalid);
    if(this.iterQueue.isEmpty()){
      ps = null;
    }else{
      ps = (PreciseSet)this.iterQueue.removeFirst();
      // Add all children to the queue
      psChildren = ps.getChildrenVector();
      this.iterQueue.addAll(psChildren);
    }
    return(ps);
  }

 /** 
 *  Return true if this iterator has more elements 
 **/ 
  public boolean
  hasNext(){
    return(!this.iterQueue.isEmpty());
  }

 /** 
 *  Invalidate this iterator (used only when asserts are turned on). 
 **/ 
  public synchronized void
  invalidate(){
    this.invalid = true;
  }

 /** 
 *  Return true if this iterator has been invalidated 
 **/ 
  public synchronized boolean
  isInvalidated(){
    return(this.invalid);
  }

 /** 
 *  Used for testing 
 **/ 
  public static void
  main(String[] argv){
    //moved to PSIteratorUnit.java
  }

 /** 
 *  Data members 
 **/ 
  private boolean invalid;
  private LinkedList iterQueue;
}

//---------------------------------------------------------------------------
/* $Log: PSIterator.java,v $
/* Revision 1.5  2007/06/25 05:21:29  zjiandan
/* Cleanup OutgoingConnection and add unit tests
/* */
//---------------------------------------------------------------------------