package code;
 /** 
 *  Unit test for PSIteratorUnit
 
 **/ 

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 */
public class PSIteratorUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  // private Process rmiregistry;
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public PSIteratorUnit (final String s) {
    super (s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /*
    //
    // Start the registry
    //
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    Env.dprintln(verbose, "rmiregistry started");
    Thread.sleep(2000);
    */
  }

  protected void tearDown() throws Exception{
    /*
    rmiregistry.destroy();
    */
    super.tearDown();
    
  }



 /** 
 *  Test basic functions
 
 **/ 
  public void testBasics(){
    Env.verifyAssertEnabled();
    if(verbose){
      System.out.println("Testing PSIterator.java...");
    }
    
    makePractiConfig();
    PSIterator psIter1 = null;
    PreciseSet ps1 = null;
    PreciseSet ps2 = null;
    PreciseSet ps3 = null;
    PreciseSet ps4 = null;
    AllPreciseSets aps1 = null;
    AcceptStamp[] as = new AcceptStamp[0];
    AcceptVV dummyvv = new AcceptVV(as);

    
    ps1 = new PreciseSet("", "", dummyvv, dummyvv);
    aps1 = new AllPreciseSets(ps1);
    aps1.split(ps1, "a");
    aps1.split(ps1, "b");
    assert(ps1.getChild("a") != null);
    assert(ps1.getChild("b") != null);
    assert(ps1.getChild("c") == null);

    // Test 1
    // Make sure that our iterator returns all three elements, "", "a",
    // and "b", and no more.
    psIter1 = new PSIterator(ps1);
    assert(psIter1.hasNext());
    ps2 = psIter1.getNext();
    assert((ps2.getName().equals("")) ||
           (ps2.getName().equals("a")) ||
           (ps2.getName().equals("b")));
    assert(psIter1.hasNext());
    ps3 = psIter1.getNext();
    assert((ps3.getName().equals("")) ||
           (ps3.getName().equals("a")) ||
           (ps3.getName().equals("b")));
    assert(psIter1.hasNext());
    ps4 = psIter1.getNext();
    assert((ps4.getName().equals("")) ||
           (ps4.getName().equals("a")) ||
           (ps4.getName().equals("b")));
    assert(!psIter1.hasNext());
    assert(psIter1.getNext() == null);
    assert((!ps2.getName().equals(ps3.getName())) &&
           (!ps2.getName().equals(ps4.getName())) &&
           (!ps3.getName().equals(ps4.getName())));

    // Test 2
    ps1 = new PreciseSet("", "", dummyvv, dummyvv);
    aps1 = new AllPreciseSets(ps1);
    ps2 = aps1.split(ps1, "a");
    aps1.split(ps2, "b");
    assert(ps1.getChild("a") != null);
    assert(ps1.getChild("b") == null);
    assert(ps2.getChild("b") != null);
    // Again, make sure we get "", "a", and "b" from the iterator
    psIter1 = new PSIterator(ps1);
    assert(psIter1.hasNext());
    ps2 = psIter1.getNext();
    assert((ps2.getName().equals("")) ||
           (ps2.getName().equals("a")) ||
           (ps2.getName().equals("b")));
    assert(psIter1.hasNext());
    ps3 = psIter1.getNext();
    assert((ps3.getName().equals("")) ||
           (ps3.getName().equals("a")) ||
           (ps3.getName().equals("b")));
    assert(psIter1.hasNext());
    ps4 = psIter1.getNext();
    assert((ps4.getName().equals("")) ||
           (ps4.getName().equals("a")) ||
           (ps4.getName().equals("b")));
    assert(!psIter1.hasNext());
    assert(psIter1.getNext() == null);
    assert((!ps2.getName().equals(ps3.getName())) &&
           (!ps2.getName().equals(ps4.getName())) &&
           (!ps3.getName().equals(ps4.getName())));

    // Test 3
    // Use the same test from before, but we invalidate the iterator
    // and make sure it is really invalidated.
    // NOTE: In a separate test, we tried to call PSIterator.getNext() to
    // make sure we get an assertion failure. This worked, but we removed
    // the test because we want to allow quick testing of our classes and
    // don't want to have to inform anyone that they should expect an
    // assertion failure.
    psIter1 = new PSIterator(ps1);
    assert(psIter1.hasNext());
    ps2 = psIter1.getNext();
    assert((ps2.getName().equals("")) ||
           (ps2.getName().equals("a")) ||
           (ps2.getName().equals("b")));
    assert(psIter1.hasNext());
    ps3 = psIter1.getNext();
    assert((ps3.getName().equals("")) ||
           (ps3.getName().equals("a")) ||
           (ps3.getName().equals("b")));
    psIter1.invalidate();
    assert(psIter1.hasNext());
    assert(psIter1.isInvalidated());
    assert(!ps2.getName().equals(ps3.getName()));
    if(verbose){
      System.out.println("...Finished");
    }
  }

  private static void makePractiConfig(){
    Config.createEmptyConfig();
    long NODE_0_ID = 0;
    long NODE_1_ID = 1;
    long NODE_2_ID = 2;
    long NODE_3_ID = 3;
    long NODE_4_ID = 4;
    String NODE_0_IP = "localhost";
    String NODE_1_IP = "localhost";
    String NODE_2_IP = "localhost";
    String NODE_3_IP = "localhost";
    String NODE_4_IP = "localhost";
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            NODE_0_IP,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "local-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            NODE_0_IP,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			   NODE_1_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_1_ID+".db",
			   "/*",
			   -1L,
			   NODE_1_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			   NODE_2_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_2_ID+".db",
			   "/*",
			   -1L,
			   NODE_2_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(NODE_3_ID),
			   NODE_3_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_3_ID+".db",
			   "/*",
			   -1L,
			   NODE_3_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   
   
   
   Config.addOneNodeConfig(new NodeId(NODE_4_ID),
			   NODE_4_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_4_ID+".db",
			   "/*",
			   -1L,
			   NODE_4_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   //Config.writeToFile(configPath);
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(PSIteratorUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java PSIteratorUnit foo" runs
   *   PSIteratorUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "PSIteratorUnit";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new PSIteratorUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
    System.exit(0); 
  }

}

//---------------------------------------------------------------------------
/* $Log: PSIteratorUnit.java,v $
/* Revision 1.1  2007/06/25 05:25:04  zjiandan
/* *** empty log message ***
/* */
//---------------------------------------------------------------------------