package code;
 /** 
 **/ 
public class PendingDemandRequest
{


private ObjId objId;
private long offset;
private long length;
private long requestId;
private int retryCount;
    private AcceptStamp as;
private static final long INITIAL_RETRY_MS = 2000;
public static final int MAX_RETRY_COUNT = 10;
private static final float retryIncreaseFactor = (float)1.4;

    public PendingDemandRequest(ObjId objId_, long offset_, long length_, long requestId_, AcceptStamp as)
{
    assert(offset_ >= 0);
    assert(length_ > 0);
    this.objId = objId_;
    this.offset = offset_;
    this.length = length_;
    this.requestId = requestId_;
    retryCount = 0;
    this.as = as;
}

public final synchronized long 
getTimeout()
{
    //assert(false);
    return (long)(INITIAL_RETRY_MS*Math.pow(retryIncreaseFactor,retryCount));
}

public final ObjId 
getObjId()
{
    return (ObjId)objId.clone();
}

public final long
getRequestId()
{
    return requestId;
}

public final long
getOffset()
{
    return offset;
}

public final long
getLength()
{
    return length;
}

public final synchronized int
getRetryCount()
{
    return retryCount;
}

public final synchronized void
incrementRetryCount()
{
    retryCount++;
}

public final synchronized void
chopStart(long reduceBy)
{
    assert(reduceBy < length);
    length -= reduceBy;
    assert(length > 0);
    offset += reduceBy;
}

public final synchronized void
setLength(long newLength)
{
    assert(newLength > 0);
    length = newLength;
}

    public AcceptStamp getAcceptStamp(){
	return this.as;
    }
public boolean
equals(Object o)
{
    assert(false); // Equals undefined on this object
    return false;
}
public int
hashCode()
{
    assert(false); // Hash undefined on this object
    return -1;
}


public static void main(String s[])
{
    System.err.print("PendingDemandRequest self test...");


    System.err.println("PendingDemandRequest self test PASSES");
    System.exit(0);
}
}


//---------------------------------------------------------------------------
/* $Log: PendingDemandRequest.java,v $
/* Revision 1.6  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.5  2004/05/22 10:10:12  arun
/* minor changes to notifyUpq logic. Correction of store behaviour while handling bound invals.
/*
/* Revision 1.4  2004/05/10 20:48:19  dahlin
/* Clarified RMI exceptions; full version of (stub) DemandReadWorker
/*
/* Revision 1.3  2004/05/10 20:35:31  dahlin
/* Fixed ^M formatting
/*
/* Revision 1.2  2004/05/10 18:56:31  dahlin
/* Created PendingDemandList and PendingDemandRequest (needed by SDIMSController)
/*
 */
//---------------------------------------------------------------------------
