 /** 
/* PicSharePerObjMeta.java
 * 
 * Per object metadata is <H(encryptedBody), 
 *                         time added to PRACTI (ms in getcurrenttime reference), 
 *                         length of file>
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 
import java.io.*;
import java.security.*;
import javax.crypto.*;

public class PicSharePerObjMeta implements Serializable{
  private ImmutableBytes hash;
  private long timeAddedMS;
  private long bodyLength;
  

 /** 
 *  Constructor -- generate the hash of the body and record the time
 
 *                 of thismetadata creation
 
 **/ 
  public PicSharePerObjMeta(String fileIdRelative, byte[] encryptedBody){
    hash = ImmutableBytes.dangerousCreateImmutableBytes(makeHash(encryptedBody));
    timeAddedMS = System.currentTimeMillis();
    bodyLength = encryptedBody.length;
  }

 /** 
 *  equals()
 
 **/ 
  public boolean equals(Object o){
    if(o == null){
      return false;
    }
    if(!(o instanceof PicSharePerObjMeta)){
      return false;
    }
    PicSharePerObjMeta m = (PicSharePerObjMeta)o;
    if(!(m.hash.equals(this.hash))){
      return false;
    }
    if(m.timeAddedMS != this.timeAddedMS){
      return false;
    }
    if(m.bodyLength != this.bodyLength){
      return false;
    }
    return true;
  }

 /** 
 *  getHash()
 
 **/ 
  public ImmutableBytes getHash(){
    return hash;
  }

 /** 
 *  getTimeAddedMS()
 
 **/ 
  public long getTimeAddedMS(){
    return timeAddedMS;
  }

 /** 
 *  getBodyLength()
 
 **/ 
  public long getBodyLength(){
    return bodyLength;
  }

 /** 
 *  makeHash -- compute the hash of the encrypted body
 
 **/ 
  private static byte[] makeHash(byte body[]){
    //System.out.println("STUB: PicSharePerObjMeta::makeHash()");
    int ii; 
    long dummy = 0;
    for(ii = 0; ii < body.length; ii++){
      dummy += new Integer(body[ii]).intValue();
    }
    byte dummy2[] = new byte[4];
    dummy2[0] = (byte)dummy;
    dummy2[1] = (byte)(dummy >> 8);
    dummy2[2] = (byte)(dummy >> 16);
    dummy2[3] = (byte)(dummy >> 24);
    return dummy2;
  }

 /** 
 *  toBytes() -- serialize this object and return byte array
 
 **/ 
  public byte[] toBytes(){
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    try{
      ObjectOutputStream oos = new ObjectOutputStream(baos);
      oos.writeObject(this);
      oos.close();
    }
    catch(IOException e){
      assert(false); // Should not get IO exception on write to byte array stream
    }
    return baos.toByteArray();
  }
}
