 /** 
/* PicShareWriteHistoryEntry.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
 **/ 

import java.io.*;

class PicShareWriteHistoryEntry implements Serializable{
  int seqNum;
  String relativeFileId;
  PicSharePerObjMeta objMeta;

  public PicShareWriteHistoryEntry(int seq, String id, PicSharePerObjMeta meta){
    seqNum = seq;
    relativeFileId = id;
    objMeta = meta;
  }


  public boolean equals(Object o){
    if(!(o instanceof PicShareWriteHistoryEntry)){
      return false;
    }
    PicShareWriteHistoryEntry e = (PicShareWriteHistoryEntry)o;
    if(this.seqNum != e.seqNum){
      return false;
    }
    if(!(this.relativeFileId.equals(e.relativeFileId))){
      return false;
    }
    if(!(this.objMeta.equals(e.objMeta))){
      return false;
    }
    return true;
  }

  int getSeqNum(){
    return seqNum;
  }
  String getRelativeFileId(){
    return relativeFileId;
  }
  PicSharePerObjMeta getObjMeta(){
    return objMeta;
  }
}
