 /** 
 *  Template for writing JUnit tests. To write the test for class
 
 *  Foo, copy this file to FooUnit.java and update as described
 
 *  below.
 
 **/ 

import junit.textui.TestRunner;
import junit.framework.*;
import java.io.*;
import java.util.*;

/**
 * TBD: Update class name
 */
public class PicShareWriteHistoryUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public PicShareWriteHistoryUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  private String CONFIG_PATH = "test" + File.separatorChar + "tmp.PicShareWriterUnit.config";
  private String CONFIG_P2_PATH = "test" + File.separatorChar + "tmp.PicShareWriterUnit.p2config";

  private LocalInterface localInterface;
  private ObjId historyId;
  Process rmiregistry;

  protected void setUp() throws Exception{
    super.setUp();
    
    try{
      Process p = Runtime.getRuntime().exec("./killRMIRegistry.sh");
      p.waitFor();
    }
    catch(Exception e){
      // Non-fatal exception; we just killed it to 
      // ensure we could start it. Now try starting it.
    }
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    System.out.println("rmiregistry started");
    Thread.sleep(2000);
  

    NodeId myId = new NodeId(1);
    makeDummyConfig(CONFIG_PATH, myId);
    makeDummyP2Config(CONFIG_P2_PATH, myId);
    NullPolicy policy = new NullPolicy();
    P2Runtime runtime = new P2Runtime(CONFIG_PATH, CONFIG_P2_PATH,
                                      myId, true, policy, false);
    policy.setRuntime(runtime);
    runtime.start();
    localInterface = new LocalInterface(runtime.getController(), 
					runtime.getCore());
    
    historyId = new ObjId("/PicShareWriteHistoryObj");
  }

  protected void  makeDummyConfig(String path, NodeId myId){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(myId, "localhost", 2378, 2379, 2380, 2381, 2382,
			    "test" + File.separatorChar + "tmp.PicShareWriteHistoryUnit.db",
			    "/*",
			    -1L,
			    "localhost",
			    2383,
			    2384,
			    -1, 
			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
    Config.writeToFile(path);
  }

  private void makeDummyP2Config(String path, NodeId myId){
    P2Config.createEmptyConfig();
    P2Config.addOneNodeConfig(myId, 10, 10, 
                              5000, 5000, 3, 3, 3, 3, 3);
    P2Config.writeToFile(path);
  }


  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

  /* 
   * Write a bunch of stuff in; now create a new history and make
   * sure the one built incrementally is the same as the one
   * recovered from the disk...
   */
  public void testWriteAndRecover(){
    PicShareWriteHistory h1 = new PicShareWriteHistory(localInterface, historyId);
    byte b[] = new byte[100];
    int ii;
    for(ii = 0; ii < 100; ii++){
      b[ii] = (byte)ii;
    }
    

    for(ii = 0; ii < 10; ii++){
      String id = "/" + (new Integer(ii)).toString();
      PicSharePerObjMeta m = new PicSharePerObjMeta(id, b);
      h1.update(m, id);
    }

    PicShareWriteHistory h2 = new PicShareWriteHistory(localInterface, historyId);

    assert(h1.equals(h2));
    h1 = null;
    
    for(ii = 0; ii < 10; ii++){
      String id = "/" + (new Integer(ii)).toString();
      PicSharePerObjMeta m = new PicSharePerObjMeta(id, b);
      h2.update(m, id);
    }
    h1 = new PicShareWriteHistory(localInterface, historyId);
    assert(h1.equals(h2));
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(PicShareWriteHistoryUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   PicShareWriteHistoryUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "PicShareWriteHistoryUnit";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new RandomAccessStateUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
    System.exit(0);
  }

}
