//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 */
public class PicShareWriterUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  Process rmiregistry;

  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public PicShareWriterUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
    try{
	Process p = Runtime.getRuntime().exec("./killRMIRegistry.sh");
	p.waitFor();
    }
    catch(Exception e){
	// Non-fatal exception; we just killed it to 
	// ensure we could start it. Now try starting it.
    }
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    System.out.println("rmiregistry started");
    Thread.sleep(2000);
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    rmiregistry.destroy();
    System.out.println("dont forget to: rmiregistry terminated");
    super.tearDown();
  }

  /* 
   * First write some stuff. Then read it back. Just
   * makes sure that PRACTI is present and accounted
   * for.
   */
  private String CONFIG_PATH = "test" + File.separatorChar + "tmp.PicShareWriterUnit.config";
  private String CONFIG_P2_PATH = "test" + File.separatorChar + "tmp.PicShareWriterUnit.p2config";
  protected String CONFIG_PICSHARE_PATH_WRITER = "test" + File.separatorChar + "tmp.PicShareWriterUnit.p2config.writer";
  protected String CONFIG_PICSHARE_PATH_READER = "test" + File.separatorChar + "tmp.PicShareWriterUnit.p2config.reader";
  protected String album = "PicShareWriterAlbum";
  protected String password = "87j24lkwdf";

  public void testWriteThenRead(){
      NodeId n1 = new NodeId(1);
      long length = 54;

      Env.dprintln(verbose, "PicShareWriterUnit::testWriteThenRead()");
      makeDummyConfig(CONFIG_PATH, n1, 613);
      makeDummyP2Config(CONFIG_P2_PATH, n1);
      PicShareConfig.createConfigFile(CONFIG_PICSHARE_PATH_WRITER, false, album,
                                      password, "IGNORE_THIS_PATH");
      PicShareConfig.createConfigFile(CONFIG_PICSHARE_PATH_READER, true, album,
                                      password, "IGNORE_THIS_PATH");
                                      

      PicShareWriter psw1 = new PicShareWriter(CONFIG_PATH, CONFIG_P2_PATH, 
					       CONFIG_PICSHARE_PATH_WRITER, 
                                               n1, true);
      try{
        LocalInterface li = psw1.getLocalInterface();
        ObjId o = new ObjId("/_test");
        byte b[] = new byte[(int)length];
        int ii;
        for(ii = 0; ii < length; ii++){
          b[ii] = (byte)(ii);
        }
        try{
	  long got = li.write(o, 0, length, b, false);
	  assert(got == length);
        }
        catch(IOException ioe){
	  assert(false);
        }
        try{
	  BodyMsg bm = li.read(o, 0, length, true, true);
	  assert(bm.getLength() == length);
	  ImmutableBytes ib = bm.getBody();
	  byte b2[] = ib.getCopyBytes();
	  for(ii = 0; ii < length; ii++){
            assert(b[ii] == b2[ii]);
	  }
        }
        catch(ObjNotFoundException n){
	  assert(false);
        }
        catch(IOException e){
	  assert(false);
        }
        catch(ReadOfInvalidRangeException roire){
	  assert(false);
        }
	catch(ReadOfHoleException rhe){
	  assert false;
	}
      }
      finally{
        psw1.shutdown();
      }
      Env.dprintln(verbose, "PicShareWriterUnit::testWriteThenRead() done");

  }

  /*
   * As we got PicShareReaderUnit working on 9.1.2006, we 
   * discovered that PersistentLog was cheating and not
   * syncing each transaction to disk. This is a quick
   * test to look at write performance now that we
   * fixed that. (Not really PicShare specific, but
   * this is an easy place to do it...)
   */
  public void testWritePerformance(){
    int nWrites = 1000;
    long startTimeMS, endTimeMS, differenceMS;
    NodeId n1 = new NodeId(1);
    long length = 1;

    Env.dprintln(verbose, "PicShareWriterUnit::testWritePerformance()");

    makeDummyConfig(CONFIG_PATH, n1, 432);
    makeDummyP2Config(CONFIG_P2_PATH, n1);
    PicShareConfig.createConfigFile(CONFIG_PICSHARE_PATH_WRITER, false, album,
                                    password, "IGNORE_THIS_PATH");
    PicShareConfig.createConfigFile(CONFIG_PICSHARE_PATH_READER, true, album,
                                    password, "IGNORE_THIS_PATH");
                                      

    PicShareWriter psw1 = new PicShareWriter(CONFIG_PATH, CONFIG_P2_PATH, 
                                             CONFIG_PICSHARE_PATH_WRITER, n1, true);

    try{
      LocalInterface li = psw1.getLocalInterface();
      byte b[] = new byte[(int)length];
      int ii;
      for(ii = 0; ii < length; ii++){
        b[ii] = (byte)(ii);
      }

      startTimeMS = System.currentTimeMillis();
      for(ii = 0; ii < nWrites; ii++){
        ObjId o = new ObjId("/PicShareWriterUnitWritePerformanceTest/"+ii);
        try{
          long got = li.write(o, 0, length, b, false);
          assert(got == length);
        }
        catch(IOException ioe){
          assert(false);
        }
      }
      endTimeMS = System.currentTimeMillis();
      differenceMS = endTimeMS - startTimeMS;

      System.out.println("Time to do " + nWrites + " writes is "
                         + differenceMS + " ms");
    }
    finally{
      psw1.shutdown();
    }
    Env.dprintln(verbose, "PicShareWriterUnit::testWritePerformance() done");

  }



    /*
     * Just make a 1-node config file on localhost in the 
     * specified path
     */
    private void  makeDummyConfig(String path, NodeId me, int offset){
      Config.createEmptyConfig();
      Config.addOneNodeConfig(me, "localhost", offset + 9378, offset + 9379, offset + 9380, 
                              offset + 9381, offset + 9382,
                              "test" + File.separatorChar + "tmp.PicShareWriterUnit.db",
                              "/*",
                              -1L,
                              "localhost.cs.utexas.edu",
                              offset + 9383,
                              offset + 9384,
                              -1, 
                              Config.CACHE_SIZE_BYTES_DEFAULT,
                              Config.MAX_LOG_DISK_SIZE_BYTES,
                              Config.MAX_LOG_MEM_SIZE_BYTES);
      Config.writeToFile(path);
    }

    private void makeDummyP2Config(String path, NodeId me){
	P2Config.makeOneNodeTestConfig(path, me.getIDint(), 10, 10, 
				       5000, 5000, 3, 3, 3, 3, 3);
    }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(PicShareWriterUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   PicShareWriterUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "PicShareWriterUnit";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new PicShareWriterUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}
