package code;
 /** 
 *  I am seeing 1second between send of message on outgoingconnection and
 
 *  receipt at incommingconnection. Try to diagnose this by pinging messages
 
 *  back and forth over the rather strange array of sockets we use...
 
 **/ 

//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;
import java.net.*;

/**
 * TBD: Update class name
 */
public class PingLatencyUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  private Process helper;
  private BarrierServer barrier;
  public static final int BARRIER_PORT = 9793;
  public static final int TEST_PORT = 8193;
  public static final int TEST_PORT2 = 8194;
  public static final int ITER = 1000;

  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public PingLatencyUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    if(verbose){
      System.out.println("PingLatencyUnit test...");
    }
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */


    //
    // Start barrier server
    //
    barrier = new BarrierServer(BARRIER_PORT, 2, BarrierServer.LOOP_FOREVER);
    barrier.start();


    //
    // Start helper process
    //
    startHelper();

  }





 /** 
 *  Start helper process. Set global writer to refer to helper process.
 
 **/ 
  private void startHelper(){
    //
    // Start the helper PRACTI node
    // "make foo.unit" runs "java foo" with appropriate arguments
    //
    // Use "make" to figure out what arguments needed to
    // set up class paths, etc. Grab the command line
    // rather than just run make b/c we want a handle
    // on the helper process so we can kill it later.
    //
    try{
      helper = Runtime.getRuntime().exec("make PingLatencyUnitHelper.unit");
      if(verbose){
        System.out.println("helper started");
      }
      setUpHelperIO(helper, "");
    }
    catch(Exception ex){
      ex.printStackTrace();
      assert(false);
    }
  }

 /** 
 *  Wait for the helper process to create the files
 
 *  I want to read. Spawn "/dev/null" threads to
 
 *  consume itstheir output so it doesn't block.
 
 **/ 
  private void setUpHelperIO(Process helper, String tag){
    InputStream is = helper.getInputStream();
    Thread dn = new DvNull(is, "PingLatencyUnitHelper " + tag + " stdout", 
                           verbose, vverbose);
    dn.start();
    is = helper.getErrorStream();
    dn = new DvNull(is, "PingLatencyUnitHelper " + tag + " stderr",
                    verbose, vverbose);
    dn.start();
  }



 /** 
 *  Kill helper process 
 
 **/ 
  protected void tearDown() throws Exception{
    if(helper != null){
      helper.destroy();
    }
    if(verbose){
      System.out.println("helper terminated");
    }
    
    super.tearDown();
  }






 /** 
 *  Test ping/pong latency
 
 * 
 
 **/ 
  public void testPing(){

    try{
      BarrierClient bc = new BarrierClient("127.0.0.1", BARRIER_PORT, 0);
      ServerSocket ss = new HeartbeatServerSocket(TEST_PORT2);
      bc.sendBarrierRequest(0, 0); // 1 We are up; helper is up    

      Socket sock = new HeartbeatSocket("127.0.0.1", TEST_PORT);
      sock.setTcpNoDelay(true);
      assert(sock.getTcpNoDelay());
      OutputStream os = new ConstrainedOutputStream(sock.getOutputStream(), -1);
      TaggedOutputStream tos = new TaggedOutputStream(os);
      String paths[] = new String[1];
      paths[0] = "/foo/bar/bas";
      SubscriptionSet subs = SubscriptionSet.makeSubscriptionSet(paths);
      AcceptStamp stamps[] = new AcceptStamp[1];
      stamps[0] = new AcceptStamp(92492912, new NodeId(23));
      AcceptVV av = new AcceptVV(stamps);
      CatchupStreamStartMsg ball = new CatchupStreamStartMsg(subs, av);


      Socket incoming = ss.accept();
      incoming.setTcpNoDelay(true);
      TaggedInputStream tis = new TaggedInputStream(incoming.getInputStream());

      int ii;
      long startAll = System.currentTimeMillis();
      long startOne, endOne;
      long endAll = 0;




      Integer ball2 = new Integer(42);

      for(ii = 0; ii < ITER; ii++){
        startOne = System.currentTimeMillis();
        tos.writeObject(ball2);
        try{
          ball2 = (Integer)tis.readTaggedObject();
        }
        catch(ClassNotFoundException cnf){
          assert(false);
        }
        endOne = System.currentTimeMillis();
        if(verbose){
          System.out.println("Iteration " + ii + " took " + (endOne - startOne) + " ms");
        }
      }
      endAll = System.currentTimeMillis();
    
      if(verbose){
        System.out.println("Done with Integer ball." + ITER + "iterations took " 
                           + (endAll - startAll) 
                           + " ms (avg = " + ((endAll-startAll)/ITER) + ")");
      }

      assert(endAll-startAll > 0);
      assert((endAll-startAll)/ITER < ITER); // 1ms per iter should be doable    
      try{
        Thread.sleep(2000);
      }
      catch(InterruptedException ie){
        // ignore
      }












      for(ii = 0; ii < ITER; ii++){
        startOne = System.currentTimeMillis();
        tos.writeObject(ball);
        try{
          ball = (CatchupStreamStartMsg)tis.readTaggedObject();
        }
        catch(ClassNotFoundException cnf){
          assert(false);
        }
        endOne = System.currentTimeMillis();
        if(verbose){
          System.out.println("Iteration " + ii + " took " + (endOne - startOne) + " ms");
        }
      }
      endAll = System.currentTimeMillis();
    
      if(verbose){
        System.out.println("Done with CatchupStreamStartMsg ball" + ITER 
                           + "iterations took " + (endAll - startAll) 
                           + " ms (avg = " + ((endAll-startAll)/ITER) + ")");
      }

      assert(endAll-startAll > 0);
      assert((endAll-startAll)/ITER < ITER); // 1ms per iter should be doable    
      try{
        Thread.sleep(2000);
      }
      catch(InterruptedException ie){
        // ignore
      }
    }
    catch(IOException e){
      assert(false);
    }

  }




  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(PingLatencyUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   PingLatencyUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "PingLatencyUnit";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new PingLatencyUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);

    System.exit(0);
  }

}



