package code;
/* PingLatencyUnitHelper.java
 * 
 * Helper for PingLatencyUnit 
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */

import java.util.*;
import java.io.*;
import java.net.*;

public class PingLatencyUnitHelper {
  private static boolean verbose = false;
  private static boolean vverbose = false;


 /** 
 *  Write the specified PRACTI files. Then wait until reading done. Then write
 
 *  more stuff. Then die. When restarted, read the old stuff and write some 
 
 *  different stuff.
 
 **/ 
  public static void main(String s[]) {
    doIt();
  }

 /** 
 *  
 
 **/ 
  private static void doIt(){
    try{
      BarrierClient bc = new BarrierClient("127.0.0.1", PingLatencyUnit.BARRIER_PORT, 1);
      ServerSocket ss = new HeartbeatServerSocket(PingLatencyUnit.TEST_PORT);
      bc.sendBarrierRequest(0, 1); // 1 We are up; helper is up 


      Socket incoming = ss.accept();
      incoming.setTcpNoDelay(true);
      TaggedInputStream tis = new TaggedInputStream(incoming.getInputStream());
    
      Socket sock = new HeartbeatSocket("127.0.0.1", PingLatencyUnit.TEST_PORT2);
      sock.setTcpNoDelay(true);
      assert(sock.getTcpNoDelay());
      OutputStream os = new ConstrainedOutputStream(sock.getOutputStream(), -1);
      TaggedOutputStream tos = new TaggedOutputStream(os);
      CatchupStreamStartMsg ball = null;

      int ii;

      Integer ball2 = null;
      for(ii = 0; ii < PingLatencyUnit.ITER; ii++){
        try{
          ball2 = (Integer)tis.readTaggedObject();
        }
        catch(ClassNotFoundException cnf){
          assert(false);
        }
        tos.writeObject(ball2);
      }


      for(ii = 0; ii < PingLatencyUnit.ITER; ii++){
        try{
          ball = (CatchupStreamStartMsg)tis.readTaggedObject();
        }
        catch(ClassNotFoundException cnf){
          assert(false);
        }
        tos.writeObject(ball);
      }
    }

    catch(IOException e){
      assert(false);
    }
    if(verbose){
      System.out.println("Helper shutting down");
    }
    try{
      Thread.sleep(2000);
    }
    catch(InterruptedException ie){
      // ignore
    }
    System.exit(0);
    
  }





}
