package code;
//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
/**
 * TBD: Update class name
 */
public class PreciseInvUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public PreciseInvUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

 /** 
 *  test basic functions
 
 **/ 
  public void testBasicFunction(){
    PreciseInv pi = null;
    PreciseInv pi2 = null;
    PreciseInv pi3 = null;
    PreciseInv pi4 = null;
    ObjInvalTarget it1 = null;
    AcceptVV vv = null;
    AcceptStamp[] as = null;

    
    pi = new PreciseInv(new ObjInvalTarget(new ObjId("obj1"), 10, 20),
                        new AcceptStamp(190, new NodeId(200)));
    System.out.println("pi = " + pi);
    System.out.println("AcceptStamp = " + pi.getAcceptStamp());
    System.out.println("InvalTarget = " + pi.getInvalTarget());
    System.out.println("NodeId = " + pi.getNodeId());
    System.out.println();
    System.out.println("pi.getStartVV() = " + pi.getStartVV());
    System.out.println("pi.getEndVV() = " + pi.getEndVV());
    System.out.println("pi.isCommitted() = " + pi.isCommitted());
    System.out.println();

    // Test chop/clone methods
    System.out.println("pi.clone() = " + pi.clone());
    System.out.println("pi.cloneChopStartTime(190) = " +
                       pi.cloneChopStartTime(190));
    System.out.println("pi.cloneChopEndTime(190) = " +
                       pi.cloneChopEndTime(190));
    System.out.println("pi.isCommitted() = " + pi.isCommitted());
    System.out.println();

    // Test the clone with intersection routines
    it1 = new ObjInvalTarget(new ObjId("obj1"), 9, 15);
/* MDD  System.out.println("pi.cloneIntersectInvalTarget(" + it1 + ") = " +
   pi.cloneIntersectInvalTarget(it1));*/
    pi2 = new PreciseInv(it1,
                         new AcceptStamp(190, new NodeId(200)));
    System.out.println("pi2 = " + pi2);
    System.out.println("pi.cloneIntersectInvaltargetChopStartEnd(" +
                       "pi2) = " +
                       pi.cloneIntersectInvaltargetChopStartEnd(pi2));
    System.out.println();

    pi3 = new PreciseInv(new ObjInvalTarget(new ObjId("obj1"), 10, 20),
                         new AcceptStamp(190, new NodeId(200)));
    pi4 = new PreciseInv(it1,
                         new AcceptStamp(190, new NodeId(200)));
    System.out.println("pi3 = " + pi3);
    System.out.println("pi4 = " + pi4);
    System.out.println("pi3.cloneIntersectInvaltargetChopStartEnd(" +
                       "pi4) = " +
                       pi3.cloneIntersectInvaltargetChopStartEnd(pi4));
    System.out.println("p3.isCommitted() = " + pi3.isCommitted());
    System.out.println();

    // Test getOneWriterSubsetFrom()
    System.out.println("pi = " + pi);
    System.out.println("pi.getOneWriterSubsetFrom(200, 500) = " +
                       pi.getOneWriterSubsetFrom(new NodeId(200), 190));

    // Test isIncludedBy()
    as = new AcceptStamp[1];
    as[0] = new AcceptStamp(200, new NodeId(200));
    vv = new AcceptVV(as);
    System.out.println("pi.isIncludedBy(" + vv + ") = " +
                       pi.isIncludedBy(vv));
    as[0] = new AcceptStamp(100, new NodeId(200));
    vv = new AcceptVV(as);
    System.out.println("pi.isIncludedBy(" + vv + ") = " +
                       pi.isIncludedBy(vv));
    as[0] = new AcceptStamp(200, new NodeId(300));
    vv = new AcceptVV(as);
    System.out.println("pi.isIncludedBy(" + vv + ") = " +
                       pi.isIncludedBy(vv));
    as = new AcceptStamp[2];
    as[0] = new AcceptStamp(200, new NodeId(200));
    as[1] = new AcceptStamp(200, new NodeId(300));
    vv = new AcceptVV(as);
    System.out.println("pi.isIncludedBy(" + vv + ") = " +
                       pi.isIncludedBy(vv));
    as[0] = new AcceptStamp(100, new NodeId(200));
    vv = new AcceptVV(as);
    System.out.println("pi.isIncludedBy(" + vv + ") = " +
                       pi.isIncludedBy(vv));
    System.out.println();

    // Ignoring testing anyComponentIncludedBy (visual inspection enough)
    // Ignoring testing isPrecise()
    // Ignoring testing newUnion()

    // Testing totalOrderCompare
    pi4 = new PreciseInv(it1,
                         new AcceptStamp(200, new NodeId(200)));
    System.out.println("pi3 = " + pi3);
    System.out.println("pi4 = " + pi4);
    System.out.println("pi3.totalOrderCompare(pi3) = " +
                       pi3.totalOrderCompare(pi3));
    System.out.println("pi4.totalOrderCompare(pi4) = " +
                       pi4.totalOrderCompare(pi4));
    System.out.println("pi3.totalOrderCompare(pi4) = " +
                       pi3.totalOrderCompare(pi4));
    System.out.println("pi4.totalOrderCompare(pi3) = " +
                       pi4.totalOrderCompare(pi3));
    System.out.println();

    pi3 = new PreciseInv(it1,
                         new AcceptStamp(200, new NodeId(300)));
    System.out.println("pi3 = " + pi3);
    System.out.println("pi3.totalOrderCompare(pi4) = " +
                       pi3.totalOrderCompare(pi4));
    System.out.println("pi4.totalOrderCompare(pi3) = " +
                       pi4.totalOrderCompare(pi3));
    pi3 = new PreciseInv(it1,
                         new AcceptStamp(200, new NodeId(300)));
    System.out.println("pi3 = " + pi3);
    System.out.println("pi3.totalOrderCompare(pi3) = " +
                       pi3.totalOrderCompare(pi3));
    System.out.println("pi3.totalOrderCompare(pi4) = " +
                       pi3.totalOrderCompare(pi4));
    System.out.println("pi4.totalOrderCompare(pi3) = " +
                       pi4.totalOrderCompare(pi3));

    // Test getStart()/getEnd();
    pi4 = new PreciseInv(it1,
                         new AcceptStamp(190, new NodeId(300)));
    System.out.println("pi3 = " + pi3);
    System.out.println("pi4 = " + pi4);
    System.out.println("pi3.getStart() = " + pi3.getStart());
    System.out.println("pi3.getEnd() = " + pi3.getEnd());
    System.out.println("pi4.getStart() = " + pi4.getStart());
    System.out.println("pi4.getEnd() = " + pi4.getEnd());
  }
  
  public void
  testEquals(){
    PreciseInv pi1 = null;
    PreciseInv pi2 = null;

    // Test 1: pi equals itself
    pi1 = new PreciseInv(new ObjInvalTarget(new ObjId("/a"), 10, 20),
                         new AcceptStamp(100, new NodeId(1)),
                         new AcceptStamp(100, new NodeId(1)),
                         false);
    assert(pi1.equals(pi1));

    // Test 2: Test equals on separate but equal objects
    pi1 = new PreciseInv(new ObjInvalTarget(new ObjId("/a"), 10, 20),
                         new AcceptStamp(100, new NodeId(1)),
                         new AcceptStamp(100, new NodeId(1)),
                         false);
    pi2 = new PreciseInv(new ObjInvalTarget(new ObjId("/a"), 10, 20),
                         new AcceptStamp(100, new NodeId(1)),
                         new AcceptStamp(100, new NodeId(1)),
                         false);
    assert(pi1.equals(pi2));
    assert(pi2.equals(pi1));

    // Test 3: Test equals on separate objects
    pi1 = new PreciseInv(new ObjInvalTarget(new ObjId("/a"), 10, 20),
                         new AcceptStamp(100, new NodeId(1)),
                         new AcceptStamp(100, new NodeId(1)),
                         false);
    pi2 = new PreciseInv(new ObjInvalTarget(new ObjId("/b"), 10, 20),
                         new AcceptStamp(100, new NodeId(1)),
                         new AcceptStamp(100, new NodeId(1)),
                         false);
    assert(!pi1.equals(pi2));
    assert(!pi2.equals(pi1));
    assert (!pi1.isCommitted());
    assert (!pi2.isCommitted());
  }
  
  public void testSerialization(){
    ObjInvalTarget hit1 = null;
    
    PreciseInv ii1 = null;
    PreciseInv ii2 = null;
    AcceptStamp as1 = null;
    
    ByteArrayOutputStream baos = null;
    ByteArrayInputStream bais = null;
    ObjectOutputStream oos = null;
    ObjectInputStream ois = null;

    // Test 1
    // Try a simple invalidate
    try{
      baos = new ByteArrayOutputStream();
      oos = new ObjectOutputStream(baos);
      
      ii1 = new PreciseInv(new ObjInvalTarget(new ObjId("/b"),
                                              0,
                                              2),
                           new AcceptStamp(1, new NodeId(10)),
                           new AcceptStamp(10, new NodeId(10)),
                           true);

      //System.out.println("test " + ii1);
      oos.writeObject(ii1);
      oos.flush();
      oos.close();
      baos.flush();
      baos.close();

      bais = new ByteArrayInputStream(baos.toByteArray());
      ois = new ObjectInputStream(bais);
      try{
        ii2 = (PreciseInv)(ois.readObject());
      }catch(ClassNotFoundException ce){
        ce.printStackTrace();
        assert false;
      }
      //System.out.println("get " + ii2);
      assert(ii1 != ii2);
      assert(ii2.equals(ii1));
      assert(ii1.equals(ii2));
    }catch(IOException e){
      e.printStackTrace();
      System.out.println("" + e);
      assert(false);
    }
  }
  
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(PreciseInvUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "PreciseInvUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}
//---------------------------------------------------------------------------
/* $Log$*/
//---------------------------------------------------------------------------
