package code;
//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;

/**
 * TBD: Update class name
 */
public class PreciseSetUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public PreciseSetUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /* 
     * TBD: Insert other fixture code here
     * e.g., this.objectUnderTest = new ClassToBeTested(...);
     */
  }

  protected void tearDown() throws Exception{
    /* 
     * TBD: Insert other fixture cleanup code here
     */
    super.tearDown();
  }

 /** 
 *  Test lots of stuff...
 
 **/ 
  public void testStuff(){
    PreciseSet ps = null;
    PreciseSet ps1 = null;
    PreciseSet ps2 = null;
    PreciseSet ps3 = null;
    PreciseSet ps4 = null;
    PreciseSet newPS = null;
    PreciseSet newPS2 = null;
    PreciseSet newChildPS = null;
    PreciseSet clonedPS1 = null;
    PreciseSet clonedPS2 = null;
    PreciseSet clonedPS3 = null;
    PreciseSet clonedPS4 = null;

    IncommingConnection ic1 = null;
    IncommingConnection ic2 = null;
    IncommingConnection ic3 = null;
    IncommingConnection ic4 = null;

    SubscriptionSet ss1 = null;
    SubscriptionSet ss2 = null;
    SubscriptionSet ss3 = null;


    Vector vec1 = null;
    Vector vec2 = null;

    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    AcceptStamp[] as4 = null;
    AcceptStamp[] as5 = null;
    AcceptVV vv1 = null;
    AcceptVV vv2 = null;
    AcceptVV vv3 = null;
    AcceptVV vv4 = null;
    AcceptVV vv5 = null;

    Env.verifyAssertEnabled();
    //    System.out.println("Testing PreciseSet...");
    
    makePractiConfig();
    //Config.readConfig("ufs.config");
    // Test 1
    
    ps = new PreciseSet("", "");
    assert(ps.children.isEmpty());
    assert(ps.getMyLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));
    assert(ps.getOtherChildrenLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));
    assert(ps.getLiveCons().isEmpty());
    assert(ps.getOtherChildrenLiveCons().isEmpty());
    newPS = ps.split("apple");
    assert(ps.children.size() == 1);
    assert(ps.children.get("apple") == newPS);
    assert(newPS.children.isEmpty());
    assert(newPS.getMyLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));
    assert(newPS.getOtherChildrenLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));
    assert(newPS.getLiveCons().isEmpty());
    assert(newPS.getOtherChildrenLiveCons().isEmpty());

    vec2 = ps.getChildrenVector();
    assert(vec2.size() == 1);
    assert(vec2.elementAt(0) == newPS);

    // Test 2
    
    ps = new PreciseSet("", "");
    newPS = ps.split("apple");
    assert(newPS.getName().equals("apple"));
    assert(newPS.getFullName().equals("/apple"));
    
    vec1 = new Vector();
    ps.addAllChildren(vec1);
    assert(vec1.size() == 2);
    ps1 = (PreciseSet)vec1.get(0);
    ps2 = (PreciseSet)vec1.get(1);
    assert((ps1.name.equals("") && ps2.name.equals("apple")) ||
           (ps1.name.equals("apple") && ps2.name.equals("")));
    assert(ps.getChild("apple") == newPS);
    
    vec2 = ps.getChildrenVector();
    assert(vec2.size() == 1);
    assert(vec2.elementAt(0) == newPS);
    

    // Test 3
    ps = new PreciseSet("", "");
    newPS = ps.split("apple");
    newChildPS = newPS.split("banana");
    assert(newPS.getName().equals("apple"));
    assert(newPS.getFullName().equals("/apple"));
    assert(newChildPS.getName().equals("banana"));
    assert(newChildPS.getFullName().equals("/apple/banana"));
    vec1 = new Vector();
    ps.addAllChildren(vec1);
    assert(vec1.size() == 3);
    ps1 = (PreciseSet)vec1.get(0);
    ps2 = (PreciseSet)vec1.get(1);
    ps3 = (PreciseSet)vec1.get(2);
    assert(ps1.name.equals("") ||
           ps1.name.equals("apple") ||
           ps1.name.equals("banana"));
    assert(ps2.name.equals("") ||
           ps2.name.equals("apple") ||
           ps2.name.equals("banana"));
    assert(ps3.name.equals("") ||
           ps3.name.equals("apple") ||
           ps3.name.equals("banana"));
    assert((ps1 != ps2) || (ps2 != ps3) || (ps1 != ps3));
    assert(ps.children.size() == 1);
    assert(newPS.children.size() == 1);
    assert(newChildPS.children.isEmpty());
    assert(ps.getChild("apple") == newPS);
    assert(newPS.getChild("banana") == newChildPS);
    assert(newChildPS.children.isEmpty());
    vec2 = ps.getChildrenVector();
    assert(vec2.size() == 1);
    assert(vec2.elementAt(0) == newPS);
    vec2 = newPS.getChildrenVector();
    assert(vec2.size() == 1);
    assert(vec2.elementAt(0) == newChildPS);

    // Test 4
    
    ps = new PreciseSet("", "");
    newPS = ps.split("apple");
    newPS2 = ps.split("cherry");
    newChildPS = newPS.split("banana");
    assert(newPS.getName().equals("apple"));
    assert(newPS.getFullName().equals("/apple"));
    assert(newPS2.getName().equals("cherry"));
    assert(newPS2.getFullName().equals("/cherry"));
    assert(newChildPS.getName().equals("banana"));
    assert(newChildPS.getFullName().equals("/apple/banana"));
    assert(ps.children.size() == 2);
    assert(newPS.children.size() == 1);
    assert(newChildPS.children.isEmpty());
    assert(newPS2.children.isEmpty());
    vec1 = new Vector();
    ps.addAllChildren(vec1);
    assert(vec1.size() == 4);
    vec2 = ps.getChildrenVector();
    assert(vec2.size() == 2);
    assert(((vec2.elementAt(0) == newPS) && (vec2.elementAt(1) == newPS2)) ||
           ((vec2.elementAt(0) == newPS2) && (vec2.elementAt(1) == newPS)));
    assert(vec2.elementAt(0) != vec2.elementAt(1));
    vec2 = newPS.getChildrenVector();
    assert((vec2.size() == 1) && (vec2.elementAt(0) == newChildPS));
    vec2 = newPS2.getChildrenVector();
    assert(vec2.isEmpty());

    // Test 5
    
    ps = new PreciseSet("", "");
    newPS = ps.split("apple");
    newPS2 = ps.split("cherry");
    newChildPS = newPS.split("banana");
    clonedPS1 = new PreciseSet("", "");
    PreciseSet newPSx = clonedPS1.split("apple");
    PreciseSet newPS2x = clonedPS1.split("cherry");
    PreciseSet newChildPSx = newPSx.split("banana");
    assert(ps != clonedPS1);
    assert(ps.name.equals(clonedPS1.name) &&
           ps.fullName.equals(clonedPS1.fullName) &&
           
           ps.getMyLpVV().equals(
             clonedPS1.getMyLpVV()) &&
           ps.getOtherChildrenLpVV().equals(clonedPS1.getOtherChildrenLpVV()) &&
           (ps.children != clonedPS1.children) &&
           (ps.children.size() == clonedPS1.children.size()));
    clonedPS2 = clonedPS1.getChild("apple");
    assert((clonedPS2 != null) &&
           (newPS != clonedPS2) &&
           newPS.name.equals(clonedPS2.name) &&
           newPS.fullName.equals(clonedPS2.fullName) &&
           
           newPS.getMyLpVV().equals(
             clonedPS2.getMyLpVV()) &&
           newPS.getOtherChildrenLpVV().equals(clonedPS2.getOtherChildrenLpVV()) &&
           (newPS.children != clonedPS2.children) &&
           (newPS.children.size() == clonedPS2.children.size()));
    clonedPS3 = clonedPS1.getChild("cherry");
    assert((clonedPS3 != null) &&
           (newPS2 != clonedPS3) &&
           newPS2.name.equals(clonedPS3.name) &&
           newPS2.fullName.equals(clonedPS3.fullName) &&
           // (newPS2.isr != clonedPS3.isr) &&
           newPS2.getMyLpVV().equals(
             clonedPS3.getMyLpVV()) &&
           newPS2.getOtherChildrenLpVV().equals(clonedPS3.getOtherChildrenLpVV()) &&
           (newPS2.children != clonedPS3.children) &&
           (newPS2.children.size() == clonedPS3.children.size()));
    clonedPS4 = clonedPS2.getChild("banana");
    assert((clonedPS4 != null) &&
           (newChildPS != clonedPS4) &&
           newChildPS.name.equals(clonedPS4.name) &&
           newChildPS.fullName.equals(clonedPS4.fullName) &&
           //(newChildPS.isr != clonedPS4.isr) &&
           newChildPS.getMyLpVV().equals(
             clonedPS4.getMyLpVV()) &&
           newChildPS.getOtherChildrenLpVV().equals(
             clonedPS4.getOtherChildrenLpVV()) &&
           (newChildPS.children != clonedPS4.children) &&
           (newChildPS.children.size() == clonedPS4.children.size()));

    // Test 6
    //isr = new InterestSetRecord();
    ps = new PreciseSet("", "");
    assert(ps.equals(ps));
    newPS = ps.split("apple");
    newPS2 = ps.split("cherry");
    newChildPS = newPS.split("banana");
    assert(ps.equals(ps));
    clonedPS1 = new PreciseSet("", "");
    newPSx = clonedPS1.split("apple");
    newPS2x = clonedPS1.split("cherry");
    newChildPSx = newPSx.split("banana");
    assert(ps.equals(clonedPS1));
    assert(clonedPS1.equals(ps));
    ps3 = clonedPS1.split("kiwi");
    assert(ps3.equals(ps3));
    assert(!ps.equals(clonedPS1));
    ps4 = ps.split("kiwi");
    assert(ps4 != ps3);
    assert(ps4.equals(ps3));
    assert(ps.equals(clonedPS1));

    //test 7-- updateMyLpVV, updateOtheChildrenLpVV updateAllChildLpVV
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(1, new NodeId(200));
    as1[1] = new AcceptStamp(1, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(2, new NodeId(200));
    as2[1] = new AcceptStamp(2, new NodeId(300));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(3, new NodeId(200));
    as3[1] = new AcceptStamp(3, new NodeId(300));
    
    vv1 = new AcceptVV(as1);
    vv2 = new AcceptVV(as2);
    vv3 = new AcceptVV(as3);

    ps = new PreciseSet("", "");
    newPS2 = ps.split("cherry");
    assert(newPS2.getName().equals("cherry"));
    assert(newPS2.getFullName().equals("/cherry"));
    assert(newPS2.getMyLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));
    assert(newPS2.getOtherChildrenLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));
    ps.updateMyLpVV(vv1);
    ps.updateOtherChildrenLpVV(vv2);
    assert(ps.getMyLpVV().includes(vv1));
    assert(vv1.includes(ps.getMyLpVV()));
    assert(ps.getOtherChildrenLpVV().includes(vv2));
    assert(vv2.includes(ps.getOtherChildrenLpVV()));
    assert(newPS2.getMyLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));
    assert(newPS2.getOtherChildrenLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));

    newPS = ps.split("apple");
    assert(newPS.getMyLpVV().includes(vv2));
    assert(vv2.includes(newPS.getMyLpVV()));
    assert(newPS.getOtherChildrenLpVV().includes(vv2));
    assert(vv2.includes(newPS.getOtherChildrenLpVV()));

    newChildPS = newPS.split("banana");
    assert(newChildPS.getMyLpVV().includes(vv2));
    assert(vv2.includes(newChildPS.getMyLpVV()));
    assert(newChildPS.getOtherChildrenLpVV().includes(vv2));
    assert(vv2.includes(newChildPS.getOtherChildrenLpVV()));

    ps.updateAllChildLpVV(vv3);
    assert(ps.getMyLpVV().includes(vv1));
    assert(vv1.includes(ps.getMyLpVV()));
    assert(ps.getOtherChildrenLpVV().includes(vv3));
    assert(vv3.includes(ps.getOtherChildrenLpVV()));
    assert(newPS.getMyLpVV().includes(vv3));
    assert(vv3.includes(newPS.getMyLpVV()));
    assert(newPS.getOtherChildrenLpVV().includes(vv3));
    assert(vv3.includes(newPS.getOtherChildrenLpVV()));
    assert(newPS.getMyLpVV().includes(vv3));
    assert(vv3.includes(newPS.getMyLpVV()));
    
    assert(newPS2.getOtherChildrenLpVV().includes(vv3));
    assert(vv3.includes(newPS2.getOtherChildrenLpVV()));
    assert(newChildPS.getMyLpVV().includes(vv3));
    assert(vv3.includes(newChildPS.getMyLpVV()));
    assert(newChildPS.getOtherChildrenLpVV().includes(vv3));
    assert(vv3.includes(newChildPS.getMyLpVV()));
    assert(ps.getChild("apple") == newPS);
    assert(ps.getChild("cherry") == newPS2);
    assert(ps.getChild("apple").getChild("banana") == newChildPS);
    
    //test 8-- getChildMinLpVV getSubtreeMinLpVV()
    as1 = new AcceptStamp[4];
    as1[0] = new AcceptStamp(1, new NodeId(200));
    as1[1] = new AcceptStamp(2, new NodeId(300));
    as1[2] = new AcceptStamp(3, new NodeId(400));
    as1[3] = new AcceptStamp(4, new NodeId(500));

    as2 = new AcceptStamp[4];
    as2[0] = new AcceptStamp(4, new NodeId(200));
    as2[1] = new AcceptStamp(1, new NodeId(300));
    as2[2] = new AcceptStamp(2, new NodeId(400));
    as2[3] = new AcceptStamp(3, new NodeId(500));

    as3 = new AcceptStamp[4];
    as3[0] = new AcceptStamp(3, new NodeId(200));
    as3[1] = new AcceptStamp(4, new NodeId(300));
    as3[2] = new AcceptStamp(1, new NodeId(400));
    as3[3] = new AcceptStamp(2, new NodeId(500));

    as4 = new AcceptStamp[4];
    as4[0] = new AcceptStamp(2, new NodeId(200));
    as4[1] = new AcceptStamp(3, new NodeId(300));
    as4[2] = new AcceptStamp(4, new NodeId(400));
    as4[3] = new AcceptStamp(1, new NodeId(500));

    as5 = new AcceptStamp[4];
    as5[0] = new AcceptStamp(1, new NodeId(200));
    as5[1] = new AcceptStamp(1, new NodeId(300));
    as5[2] = new AcceptStamp(1, new NodeId(400));
    as5[3] = new AcceptStamp(1, new NodeId(500));

    vv1 = new AcceptVV(as1);
    vv2 = new AcceptVV(as2);
    vv3 = new AcceptVV(as3);
    vv4 = new AcceptVV(as4);
    vv5 = new AcceptVV(as5);

    ps = new PreciseSet("", "");
    newPS = ps.split("apple");
    
    assert(newPS.getMyLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));
    assert(newPS.getOtherChildrenLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));
    
    ps.updateOtherChildrenLpVV(vv1);
    assert(ps.getOtherChildrenLpVV().equalsIgnoreNegatives(vv1));
    
    newPS.updateOtherChildrenLpVV(vv2);
    
    newPS2 = ps.split("cherry");
    assert(newPS2.getMyLpVV().equalsIgnoreNegatives(vv1));
    assert(newPS2.getOtherChildrenLpVV().equalsIgnoreNegatives(vv1));

    
    newPS2.updateOtherChildrenLpVV(vv3);

    newChildPS = newPS.split("banana");
    assert(newChildPS.getMyLpVV().equalsIgnoreNegatives(vv2));
    assert(newChildPS.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2));
    
    newChildPS.updateOtherChildrenLpVV(vv4);
    assert(newChildPS.getMyLpVV().equalsIgnoreNegatives(vv2));
    assert(newChildPS.getOtherChildrenLpVV().includes(vv4));
    
    ps = new PreciseSet("", "", AcceptVV.makeVVAllNegatives(), vv1);
    newPS = new PreciseSet("apple", "/apple", vv1, vv2);
    newPS2 = new PreciseSet("cherry", "/cherry", vv1, vv3);
    newChildPS = new PreciseSet("banana", "/banana", vv2, vv4);
    
    ps.children.put("apple", newPS);
    ps.children.put("cherry", newPS2);
    newPS.children.put("banana", newChildPS);
      
    assert(ps.getChild("apple") == newPS);
    assert(ps.getChild("cherry") == newPS2);
    assert(ps.getChild("apple").getChild("banana") == newChildPS);

    assert(ps.getChildMinLpVV().equalsIgnoreNegatives(vv5));
    as5 = new AcceptStamp[4];
    as5[0] = new AcceptStamp(2, new NodeId(200));
    as5[1] = new AcceptStamp(1, new NodeId(300));
    as5[2] = new AcceptStamp(2, new NodeId(400));
    as5[3] = new AcceptStamp(1, new NodeId(500));
    vv5 = new AcceptVV(as5);
    assert(newPS.getChildMinLpVV().equalsIgnoreNegatives(vv5));
    assert(newChildPS.getChildMinLpVV().equalsIgnoreNegatives(vv4));
    assert(newPS2.getChildMinLpVV().equalsIgnoreNegatives(vv3));
    assert(newChildPS.getSubtreeMinLpVV().equalsIgnoreNegatives(vv5));
    
    assert(ps.getSubtreeMinLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()));
    as5 = new AcceptStamp[4];
    as5[0] = new AcceptStamp(1, new NodeId(200));
    as5[1] = new AcceptStamp(1, new NodeId(300));
    as5[2] = new AcceptStamp(2, new NodeId(400));
    as5[3] = new AcceptStamp(1, new NodeId(500));
    vv5 = new AcceptVV(as5);
   
    assert(newPS.getSubtreeMinLpVV().equalsIgnoreNegatives(vv5));
    as5 = new AcceptStamp[4];
    as5[0] = new AcceptStamp(1, new NodeId(200));
    as5[1] = new AcceptStamp(2, new NodeId(300));
    as5[2] = new AcceptStamp(1, new NodeId(400));
    as5[3] = new AcceptStamp(2, new NodeId(500));
    vv5 = new AcceptVV(as5);
    assert(newPS2.getSubtreeMinLpVV().equalsIgnoreNegatives(vv5));

    //test 9 -- split(SubscriptionSet ss)
    ps = new PreciseSet("", "");
    ps.split(SubscriptionSet.makeSubscriptionSet("/apple/banana:/cherry"));
    assert(ps.getChild("apple").getChild("banana").getFullName().equals("/apple/banana"));
    assert(ps.getChild("cherry").getFullName().equals("/cherry"));
    ps.split(SubscriptionSet.makeSubscriptionSet("/cherry/dog/egg/*:/apple/group/*"));
    assert(ps.getChild("cherry").getChild("dog").getChild("egg").getFullName().equals("/cherry/dog/egg"));
    assert(ps.getChild("apple").getChild("group").getFullName().equals("/apple/group"));

    //test 10 -- addLiveConsToAllChildren, addLiveCons
    ps = new PreciseSet("", "");
    ps.split(SubscriptionSet.makeSubscriptionSet("/apple/banana:/cherry"));
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(1, new NodeId(200));
    as1[1] = new AcceptStamp(1, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(2, new NodeId(200));
    as2[1] = new AcceptStamp(2, new NodeId(300));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(3, new NodeId(200));
    as3[1] = new AcceptStamp(3, new NodeId(300));
    
    vv1 = new AcceptVV(as1);
    vv2 = new AcceptVV(as2);
    vv3 = new AcceptVV(as3);
    
    ic1 = new IncommingConnection(StreamId.makeNewStreamId(),
                                  SubscriptionSet.makeSubscriptionSet("/*"),
                                  vv1);
    
    ic2 = new IncommingConnection(StreamId.makeNewStreamId(),
                                  SubscriptionSet.makeSubscriptionSet("/apple/*"),
                                  vv2);

    ic3 = new IncommingConnection(StreamId.makeNewStreamId(),
                                  SubscriptionSet.makeSubscriptionSet("/apple/banana/*"),
                                  vv3);
    
    ps.addLiveConsToAllChildren(ic1);
    ps.getChild("apple").addLiveConsToAllChildren(ic2);
    ps.getChild("apple").getChild("banana").addLiveConsToAllChildren(ic3);
    
    vec1 = ps.getLiveCons();
    assert vec1.size() == 0;
    vec1 = ps.getOtherChildrenLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    
    newPS = ps.getChild("apple");
    newPS2 = ps.getChild("cherry");
    newChildPS = newPS.getChild("banana");
    
    vec1 = newPS.getLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    vec1 = newPS.getOtherChildrenLiveCons();
    assert vec1.size() == 2;
    assert (((vec1.elementAt(0) == ic1)&&(vec1.elementAt(1) == ic2)) ||
            ((vec1.elementAt(1) == ic1)&&(vec1.elementAt(0) == ic2)));

    vec1 = newPS2.getLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    vec1 = newPS2.getOtherChildrenLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    
    vec1 = newChildPS.getLiveCons();
    assert vec1.size() == 2;
    assert (((vec1.elementAt(0) == ic1)&&(vec1.elementAt(1) == ic2)) ||
            ((vec1.elementAt(1) == ic1)&&(vec1.elementAt(0) == ic2)));
    vec1 = newChildPS.getOtherChildrenLiveCons();
    assert vec1.size() == 3;
    assert ((vec1.elementAt(0) == ic1)||(vec1.elementAt(0) == ic2) || (vec1.elementAt(0) == ic3));
    assert ((vec1.elementAt(1) == ic1)||(vec1.elementAt(1) == ic2) || (vec1.elementAt(1) == ic3));
    assert ((vec1.elementAt(2) == ic1)||(vec1.elementAt(2) == ic2) || (vec1.elementAt(2) == ic3));

    ps = new PreciseSet("", "");
    ps.split(SubscriptionSet.makeSubscriptionSet("/apple/banana:/cherry"));
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(1, new NodeId(200));
    as1[1] = new AcceptStamp(1, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(2, new NodeId(200));
    as2[1] = new AcceptStamp(2, new NodeId(300));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(3, new NodeId(200));
    as3[1] = new AcceptStamp(3, new NodeId(300));
    
    vv1 = new AcceptVV(as1);
    vv2 = new AcceptVV(as2);
    vv3 = new AcceptVV(as3);
    
    ss1 = SubscriptionSet.makeSubscriptionSet(":/:/apple:/apple/*:/cherry:/cherry/*");
    ss2 = SubscriptionSet.makeSubscriptionSet("/dog:/dog/*:/apple/*");
    ss3 = SubscriptionSet.makeSubscriptionSet("/apple/banana/*:/apple/dog");
    
    ic1 = new IncommingConnection(StreamId.makeNewStreamId(), ss1, vv1);
    ic2 = new IncommingConnection(StreamId.makeNewStreamId(), ss2, vv2);
    ic3 = new IncommingConnection(StreamId.makeNewStreamId(), ss3, vv3);

    ps.addLiveCons(ss1, ic1);
    ps.addLiveCons(ss2, ic2);
    ps.addLiveCons(ss3, ic3);

    vec1 = ps.getLiveCons();
    
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    assert ps.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    vec1 = ps.getOtherChildrenLiveCons();
    assert vec1.size() == 0;
    assert ps.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives());

    newPS = ps.getChild("apple");
    newPS2 = ps.getChild("cherry");
    newChildPS = newPS.getChild("banana");
    
    vec1 = newPS.getLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    assert newPS.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    vec1 = newPS.getOtherChildrenLiveCons();
    assert vec1.size() == 2;
    assert (((vec1.elementAt(0) == ic1)&&(vec1.elementAt(1) == ic2)) ||
            ((vec1.elementAt(1) == ic1)&&(vec1.elementAt(0) == ic2)));
    assert newPS.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv2);

    vec1 = newPS2.getLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    assert newPS2.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    vec1 = newPS2.getOtherChildrenLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    assert newPS2.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1);
    
    vec1 = newChildPS.getLiveCons();
    assert vec1.size() == 2;
    assert (((vec1.elementAt(0) == ic1)&&(vec1.elementAt(1) == ic2)) ||
            ((vec1.elementAt(1) == ic1)&&(vec1.elementAt(0) == ic2)));
    assert newChildPS.getMyMaxLpVV().equalsIgnoreNegatives(vv2);
    vec1 = newChildPS.getOtherChildrenLiveCons();
    assert vec1.size() == 3;
    assert ((vec1.elementAt(0) == ic1)||(vec1.elementAt(0) == ic2) || (vec1.elementAt(0) == ic3));
    assert ((vec1.elementAt(1) == ic1)||(vec1.elementAt(1) == ic2) || (vec1.elementAt(1) == ic3));
    assert ((vec1.elementAt(2) == ic1)||(vec1.elementAt(2) == ic2) || (vec1.elementAt(2) == ic3));
    assert newChildPS.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv3);

    //test 11 -- removeLiveConsFromAllChildren, removeLiveCons, 
    ps = new PreciseSet("", "");
    ps.split(SubscriptionSet.makeSubscriptionSet("/apple/banana:/cherry"));
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(1, new NodeId(200));
    as1[1] = new AcceptStamp(1, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(2, new NodeId(200));
    as2[1] = new AcceptStamp(2, new NodeId(300));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(3, new NodeId(200));
    as3[1] = new AcceptStamp(3, new NodeId(300));
    as4 = new AcceptStamp[2];
    as4[0] = new AcceptStamp(2, new NodeId(200));
    as4[1] = new AcceptStamp(5, new NodeId(300));
    as5 = new AcceptStamp[2];
    as5[0] = new AcceptStamp(3, new NodeId(200));
    as5[1] = new AcceptStamp(5, new NodeId(300));

    vv1 = new AcceptVV(as1);
    vv2 = new AcceptVV(as2);
    vv3 = new AcceptVV(as3);
    vv4 = new AcceptVV(as4);
    vv5 = new AcceptVV(as5);

    ss1 = SubscriptionSet.makeSubscriptionSet(":/:/apple/banana:/apple/banana/*:/cherry:/cherry/*");
    ss2 = SubscriptionSet.makeSubscriptionSet("/dog:/dog/*:/apple/*");
    ss3 = SubscriptionSet.makeSubscriptionSet("/apple/banana/*:/apple/dog");
    
    ic1 = new IncommingConnection(StreamId.makeNewStreamId(), ss1, vv1);
    ic2 = new IncommingConnection(StreamId.makeNewStreamId(), ss2, vv3);
    ic3 = new IncommingConnection(StreamId.makeNewStreamId(), ss3, vv1);

    ps.addLiveCons(ss1, ic1);
    ps.addLiveCons(ss2, ic2);
    ps.addLiveCons(ss3, ic3);
    
    vec1 = ps.getLiveCons();
    assert vec1.size() == 1;
    assert ps.getMyLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives());

    ps.removeLiveConsFromAllChildren(ic1, vv2);
    
    newPS = ps.getChild("apple");
    newPS2 = ps.getChild("cherry");
    newChildPS = newPS.getChild("banana");

    vec1 = ps.getLiveCons();
    
    assert vec1.size() == 1;
    assert ps.getMyLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives());
    vec1 = ps.getOtherChildrenLiveCons();
    assert vec1.size() == 0;
    assert ps.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);

    vec1 = newPS.getLiveCons();
    assert vec1.size() == 0;
    assert newPS.getMyLpVV().equalsIgnoreNegatives(vv2);
    vec1 = newPS.getOtherChildrenLiveCons();
    assert vec1.size() == 1;
    assert (vec1.elementAt(0) == ic2);
    assert newPS.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);

    vec1 = newPS2.getLiveCons();
    assert vec1.size() == 0;
    assert newPS2.getMyLpVV().equalsIgnoreNegatives(vv2);
    vec1 = newPS2.getOtherChildrenLiveCons();
    assert vec1.size() == 0;
    assert newPS2.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);

    vec1 = newChildPS.getLiveCons();
    assert vec1.size() == 1;
    assert (vec1.elementAt(0) == ic2);
    assert newChildPS.getMyLpVV().equalsIgnoreNegatives(vv2);
    vec1 = newChildPS.getOtherChildrenLiveCons();
    assert vec1.size() == 2;
    assert (((vec1.elementAt(0) == ic3)&&(vec1.elementAt(1) == ic2)) ||
            ((vec1.elementAt(1) == ic3)&&(vec1.elementAt(0) == ic2)));
    assert newChildPS.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);

    ps.removeLiveCons(SubscriptionSet.makeSubscriptionSet("/apple/dog:/apple/banana:/apple/banana/*"),
                      ic2,
                      vv4);

    vec1 = ps.getLiveCons();
    assert vec1.size() == 1;
    assert ps.getMyLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives());
    vec1 = ps.getOtherChildrenLiveCons();
    assert vec1.size() == 0;
    assert ps.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);

    vec1 = newPS.getLiveCons();
    assert vec1.size() == 0;
    assert newPS.getMyLpVV().equalsIgnoreNegatives(vv2);
    vec1 = newPS.getOtherChildrenLiveCons();
    assert vec1.size() == 0;
    assert newPS.getOtherChildrenLpVV().equalsIgnoreNegatives(vv3);

    vec1 = newPS2.getLiveCons();
    assert vec1.size() == 0;
    assert newPS2.getMyLpVV().equalsIgnoreNegatives(vv2);
    vec1 = newPS2.getOtherChildrenLiveCons();
    assert vec1.size() == 0;
    assert newPS2.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);

    vec1 = newChildPS.getLiveCons();
    assert vec1.size() == 0;
    assert newChildPS.getMyLpVV().equalsIgnoreNegatives(vv4);
    vec1 = newChildPS.getOtherChildrenLiveCons();
    assert vec1.size() == 1;
    assert (vec1.elementAt(0) == ic3);
    assert newChildPS.getOtherChildrenLpVV().equalsIgnoreNegatives(vv4);
    assert newChildPS.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv4);

    assert ps.getSubtreeMinLpVV().equalsIgnoreNegatives(vv1);
    assert newPS.getSubtreeMinLpVV().equalsIgnoreNegatives(vv2);
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(2, new NodeId(200));
    as1[1] = new AcceptStamp(3, new NodeId(300));
    assert newPS.getChildMinLpVV().equalsIgnoreNegatives(new AcceptVV(as1));
    assert newPS2.getSubtreeMinLpVV().equalsIgnoreNegatives(vv2);
    assert newChildPS.getSubtreeMinLpVV().equalsIgnoreNegatives(vv4);
    assert newChildPS.getChildMinLpVV().equalsIgnoreNegatives(vv4);
    
    //test 12  -- join

    
    ps.join();
    
    assert ps.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    assert ps.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);
    assert ps.children.size() == 0;


    //System.out.println("...Finished");

  }

  //---------------------------------------------------------------------------
  // Serialize a PS and then see if it properly updated lpVVs based on
  // connections...
  //---------------------------------------------------------------------------
  public void testSerialize(){
    PreciseSet ps, newPS, newPS2, newChildPS;
    AcceptVV vv1, vv2, vv3;
    AcceptStamp[] as1, as2, as3;
    Vector vec1;
    SubscriptionSet ss1, ss2, ss3;
    IncommingConnection ic1, ic2, ic3;

    ps = new PreciseSet("", "");
    ps.split(SubscriptionSet.makeSubscriptionSet("/apple/banana:/cherry"));
    as1 = new AcceptStamp[2];
    as1[0] = new AcceptStamp(1, new NodeId(200));
    as1[1] = new AcceptStamp(1, new NodeId(300));
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(2, new NodeId(200));
    as2[1] = new AcceptStamp(2, new NodeId(300));
    as3 = new AcceptStamp[2];
    as3[0] = new AcceptStamp(3, new NodeId(200));
    as3[1] = new AcceptStamp(3, new NodeId(300));
    
    vv1 = new AcceptVV(as1);
    vv2 = new AcceptVV(as2);
    vv3 = new AcceptVV(as3);
    
    ss1 = SubscriptionSet.makeSubscriptionSet(":/:/apple:/apple/*:/cherry:/cherry/*");
    ss2 = SubscriptionSet.makeSubscriptionSet("/dog:/dog/*:/apple/*");
    ss3 = SubscriptionSet.makeSubscriptionSet("/apple/banana/*:/apple/dog");
    
    ic1 = new IncommingConnection(StreamId.makeNewStreamId(), ss1, vv1);
    ic2 = new IncommingConnection(StreamId.makeNewStreamId(), ss2, vv2);
    ic3 = new IncommingConnection(StreamId.makeNewStreamId(), ss3, vv3);

    ps.addLiveCons(ss1, ic1);
    ps.addLiveCons(ss2, ic2);
    ps.addLiveCons(ss3, ic3);


    //
    // Check ps
    //
    vec1 = ps.getLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    assert ps.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    vec1 = ps.getOtherChildrenLiveCons();
    assert vec1.size() == 0;
    assert ps.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives());

    PreciseSet deserialized = serializeForTest(ps);
    sanitySerializeTest(ps, deserialized);
    assert deserialized.getMyMaxLpVV().equalsIgnoreNegatives(vv1); 
    assert deserialized.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives());

    
    


    newPS = ps.getChild("apple");
    newPS2 = ps.getChild("cherry");
    newChildPS = newPS.getChild("banana");
    
    //
    // Check newPS
    //
    vec1 = newPS.getLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    assert newPS.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    vec1 = newPS.getOtherChildrenLiveCons();
    assert vec1.size() == 2;
    assert (((vec1.elementAt(0) == ic1)&&(vec1.elementAt(1) == ic2)) ||
            ((vec1.elementAt(1) == ic1)&&(vec1.elementAt(0) == ic2)));
    assert newPS.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv2);
    deserialized = serializeForTest(newPS);
    sanitySerializeTest(newPS, deserialized);
    assert deserialized.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    assert deserialized.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv2);


    //
    // Check newPS2
    //
    vec1 = newPS2.getLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    assert newPS2.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    vec1 = newPS2.getOtherChildrenLiveCons();
    assert vec1.size() == 1;
    assert vec1.elementAt(0) == ic1;
    assert newPS2.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1);
    deserialized = serializeForTest(newPS2);
    sanitySerializeTest(newPS2, deserialized);
    assert deserialized.getMyMaxLpVV().equalsIgnoreNegatives(vv1);
    assert deserialized.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1);
    
    //
    // Check newChildPS
    //
    vec1 = newChildPS.getLiveCons();
    assert vec1.size() == 2;
    assert (((vec1.elementAt(0) == ic1)&&(vec1.elementAt(1) == ic2)) ||
            ((vec1.elementAt(1) == ic1)&&(vec1.elementAt(0) == ic2)));
    assert newChildPS.getMyMaxLpVV().equalsIgnoreNegatives(vv2);
    vec1 = newChildPS.getOtherChildrenLiveCons();
    assert vec1.size() == 3;
    assert ((vec1.elementAt(0) == ic1)||(vec1.elementAt(0) == ic2) || (vec1.elementAt(0) == ic3));
    assert ((vec1.elementAt(1) == ic1)||(vec1.elementAt(1) == ic2) || (vec1.elementAt(1) == ic3));
    assert ((vec1.elementAt(2) == ic1)||(vec1.elementAt(2) == ic2) || (vec1.elementAt(2) == ic3));
    assert newChildPS.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv3); 
    deserialized = serializeForTest(newChildPS);
    sanitySerializeTest(newChildPS, deserialized);
    assert deserialized.getMyMaxLpVV().equalsIgnoreNegatives(vv2);
    assert deserialized.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv3);
   
  }


//---------------------------------------------------------------------------
// Serialize and deserialize the specified precise set for testing.
//---------------------------------------------------------------------------
  private static PreciseSet serializeForTest(PreciseSet ps){
    try{
      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(bos);
      oos.writeObject(ps);
      oos.close();
      byte[] b = bos.toByteArray();
      ByteArrayInputStream bis = new ByteArrayInputStream(b);
      ObjectInputStream ois = new ObjectInputStream(bis);
      PreciseSet deserialized = (PreciseSet)ois.readObject();
      return deserialized;
    }
    catch(Exception e){
      assert(false);
      return null; // Make compiler happy...
    }
  }

//---------------------------------------------------------------------------
// Sanity check that serialized object is as expected:
// It should have no live connections but its effective
// lpVVs should be the same as its "pre-image" that may have
// had live connections
//---------------------------------------------------------------------------
  private static void sanitySerializeTest(PreciseSet preimage, PreciseSet deserialized){
    //
    // Live connections not serialized, but lpVV reflects state
    // of connections at time of serialization
    //
    VV vv1 = preimage.getMyMaxLpVV();
    Vector vec1 = deserialized.getLiveCons();
    assert vec1.size() == 0; 
    assert deserialized.getMyMaxLpVV().equalsIgnoreNegatives(vv1); 

    vv1 = preimage.getOtherChildrenMaxLpVV();
    vec1 = deserialized.getOtherChildrenLiveCons();
    assert vec1.size() == 0;
    assert deserialized.getOtherChildrenMaxLpVV().equalsIgnoreNegatives(vv1); 
  }



  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(PreciseSetUnit.class);
    return suite;
  }


  private static void makePractiConfig(){
    Config.createEmptyConfig();
    long NODE_0_ID = 0;
    long NODE_1_ID = 1;
    long NODE_2_ID = 2;
    long NODE_3_ID = 3;
    long NODE_4_ID = 4;
    String NODE_0_IP = "localhost";
    String NODE_1_IP = "localhost";
    String NODE_2_IP = "localhost";
    String NODE_3_IP = "localhost";
    String NODE_4_IP = "localhost";
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            NODE_0_IP,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "local-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            NODE_0_IP,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			   NODE_1_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_1_ID+".db",
			   "/*",
			   -1L,
			   NODE_1_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			   NODE_2_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_2_ID+".db",
			   "/*",
			   -1L,
			   NODE_2_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(NODE_3_ID),
			   NODE_3_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_3_ID+".db",
			   "/*",
			   -1L,
			   NODE_3_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   
   
   
   Config.addOneNodeConfig(new NodeId(NODE_4_ID),
			   NODE_4_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_4_ID+".db",
			   "/*",
			   -1L,
			   NODE_4_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   //Config.writeToFile(configPath);
  }

  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   PreciseSetUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "PreciseSetUnit";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new RandomAccessStateUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
  }

}
