package code;
 /** 
 **/ 
import java.util.Hashtable;
import java.rmi.*;
import java.rmi.server.*;
import java.io.*;

public class RMIClient
{
  //
  //RMI Naming.lookup is a very expeinsive operation
  //which might end of taking 1 sec or even worse
  //
  // turn on the cache has problem:
  //    if the remote object is destroyed and restarted again,
  //    the cached object(which is obsoleted)  will refuse any call
  // 
  // current solution:
  //    if an rmi call throws ConnectException,
  //    remove the cache so that
  //    next call will renew the object.   
  // 
  // cons: caller needs to retry at least once if any remote object is destroyed
  //       could authomatically retry once when get a ConnectException
  //       but it might waste time when the problem that cause ConnectException is
  //       not because of the cache problem
  //       so the current implementation just remove the cache if any
  //       leave the retry to the caller (since we already have p2runtime to do it)
  //
  private static final boolean useRMIServerCache = false;

  private Hashtable pool=null;

  private static final int RMITimeoutMS = 60000;
  public static final long ACCEPT_STAMP_TO_FILTER_MY_OWN_UPDATES = Long.MAX_VALUE;

  private static final boolean turnOffDemandReadCalls = false;
  protected static final boolean dbg = false;
  protected static final boolean dbgPerformance = false;
  protected static final boolean printTime = false;
  
  public static void main(String[] argv){
    /*   
    if(argv.length < 3){
      System.out.println("Usage: [configuration file] [local node id] " +
                         "[remote node id] ...");
      System.exit(-1);
    }
    NodeId myid = new NodeId((new Integer(argv[1])).intValue());
    Config.readConfig(argv[0]);

    NodeId[] remoteNodes = new NodeId[argv.length-2];
    for(int i=0; i<argv.length-2; i++){
      remoteNodes[i] = new NodeId((new Integer(argv[i+2])).intValue());
    }

    RMIClient rmiClient = new RMIClient();
    for(int i=0; i<argv.length-2; i++){
      try{
	  
        rmiClient.subscribe(null,
                            null,
                            null,
                            remoteNodes[i],
                            myid,
                            Config.getDNS(myid),
                            Config.getPortInval(myid),
                            1000,
                            10000,
                            0);

        rmiClient.subscribeBody(null,
                                null,
                                remoteNodes[i],
                                myid,
                                Config.getDNS(myid),
                                Config.getPortBody(myid),
                                1000);

        rmiClient.subscribeCheckpoint(null,
                                      null,
                                      null,
                                      remoteNodes[i],
                                      myid,
                                      Config.getDNS(myid),
                                      Config.getPortCP(myid),
				      false);
        rmiClient.issueDemandRead(null,
                                  100L,
                                  1000L,
                                  999L,
                                  remoteNodes[i],
                                  myid,
                                  Config.getDNS(myid),
                                  Config.getPortBody(myid));
      }catch(Exception e){
        e.printStackTrace();
        System.exit(-1);
      }
    }
*/
  }

  public RMIClient(){
    if(useRMIServerCache){
      pool = new Hashtable();
    }
    Env.inform("In RMIClient() constructor");
    if(false){
      Env.warn("Turning off RMI client timeouts for debugging");
    }
    else{
      /*
      System.setSecurityManager(new RMISecurityManager());
      try{
        RMISocketFactory.setSocketFactory(new RMITimeoutSocketFactory(RMITimeoutMS));
      }
      catch(java.io.IOException e){
        Env.warn("Cannot set timeout factory for RMI " +
                 "(ok if multiple tries on same node" + e);
      }
      */
    }
  }

 /** 
 *  Hashtable size grows as the number of server increases 
 *   
 *  tbd: retire old servers to save space 
 **/ 
  synchronized protected RMIServer getRMIServer(NodeId serverId)
  throws RMINetworkException, RMIApplicationException{
    
    RMIServer rmiServer = (RMIServer)pool.get(serverId);
    if(rmiServer == null){
      try{
	rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(serverId));
      }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
	
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
      pool.put(serverId, rmiServer);
    }
    assert rmiServer != null;
    return rmiServer;
  }

 /** 
 *  remove RMIServer from cache 
 **/ 
  synchronized protected void removeRMIServerFromCache(NodeId serverId){
    assert serverId != null;
    try{
      pool.remove(serverId);
  
    }catch(NullPointerException e){
      assert false;
    }
  }

/*  
  //
  // The RMIServer interface accessible via RMI with endVV
  //
  // Notice that this interface allows for an "external controller"
  // C that tells node A that B would like to subscribe to it
  //
  public void subscribe(SubscriptionSet ss, 
                        VV startVV, 
                        VV endVV, 
                        NodeId supplierNodeId,
                        NodeId subscriberNodeId, 
                        String subscriberNodeDNS, 
                        int subscriberPortInval, 
                        long subscriptionDurationMS,
                        long maxForceMS, 
                        long maxDelayMS) 
    throws RMINetworkException, RMIApplicationException
    {
      try{
        RMIServer rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
        rmiServer.subscribe(ss, 
                            startVV, 
                            endVV, 
                            
                            subscriberNodeId, 
                            subscriberNodeDNS, 
                            subscriberPortInval, 
                            subscriptionDurationMS, 
                            maxForceMS, maxDelayMS);
      }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        throw new RMIApplicationException(e);
      }
	
    }
*/    
  //
  // The RMIServer interface accessible via RMI
  //
  // Notice that this interface allows for an "external controller"
  // C that tells node A that B would like to subscribe to it
  //
  public void subscribe(SubscriptionSet ss, VV startVV, NodeId supplierNodeId,
                        NodeId subscriberNodeId, String subscriberNodeDNS, 
                        int subscriberPortInval, long subscriptionDurationMS,
                        long maxForceMS, long maxDelayMS) 
    throws RMINetworkException, RMIApplicationException
    {
      assert false;
/*  
    try{
        RMIServer rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
        rmiServer.subscribe(ss, startVV, null,  
                            subscriberNodeId, subscriberNodeDNS, 
                            subscriberPortInval, subscriptionDurationMS, 
                            maxForceMS, maxDelayMS);
      }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        throw new RMIApplicationException(e);
      }
*/	
    }
  
  public void subscribeBody(NodeId supplierNodeId,
                             NodeId subscriberNodeId, 
                             SubscriptionSet ss, 
                             VV startVV)
     throws RMINetworkException, RMIApplicationException {
     subscribeBody(ss, startVV, supplierNodeId, subscriberNodeId,
                   Config.getDNS(subscriberNodeId), 
                   Config.getPortBody(subscriberNodeId), 1000000000);
   }

  public void subscribeBody(SubscriptionSet ss, 
                            VV startVV, 
                            NodeId supplierNodeId,
                            NodeId subscriberNodeId, 
                            String subscriberNodeDNS, 
                            int subscriberPortBody, 
                            long subscriptionDurationMS) 
    throws RMINetworkException, RMIApplicationException
    {
      RMIServer rmiServer = null;
      try{
        
	if(useRMIServerCache){
	  rmiServer=getRMIServer(supplierNodeId);
	}else{
	  rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
	}
        rmiServer.subscribeBody(ss, startVV, subscriberNodeId, subscriberNodeDNS, 
                                subscriberPortBody, subscriptionDurationMS);
      }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
	if(useRMIServerCache){
	  //possible the cached server is destroyed at the remote node
	  removeRMIServerFromCache(supplierNodeId);
	}
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
    }

/*
  //
  // The RMIServer interface accessible via RMI with endVV
  //
  // Notice that this interface allows for an "external controller"
  // C that tells node A that B would like to subscribe to it
  //
  public void
  subscribeCheckpoint(String cpPath,
                      String[] exclChildNames,
                      VV startVV,
                      NodeId supplierNodeId,
                      NodeId subscriberNodeId,
                      String subscriberNodeDNS,
                      int portCheckpoint,
		      boolean withBody)
    throws RMINetworkException, RMIApplicationException{
    try{
      RMIServer rmiServer = null;

      rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
      rmiServer.subscribeCheckpoint(cpPath,
                                    exclChildNames,
                                    startVV,
                                    subscriberNodeId,
                                    subscriberNodeDNS,
                                    portCheckpoint,
				    withBody);
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
      throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      throw new RMIApplicationException(e);
    }
  }
*/    

    

 /** 
 *  ask supplier to  
 *  send the bodyMsg that includes "offset" and is at least as new as "as" to the receiver 
 *  
 *  return the number of bytes in the bodyMsg if success 
 *         0 if the bodyMsg is older than "as" 
 **/ 
  public int
  issueDemandRead(ObjId id,
                  long offset,
                  long length,
                  long requestId, 
                  NodeId supplierNodeId,
                  NodeId readerNodeId,
                  String readerNodeDNS,
                  int readerPortBody,
		  AcceptStamp as) 
    throws RMINetworkException, RMIApplicationException,
    ObjNotFoundException, IOException, ReadOfInvalidRangeException,
	   EOFException, ReadOfHoleException{
    RMIServer rmiServer = null;
    if(turnOffDemandReadCalls){
      return 100;
    }
    try{
     
      if(useRMIServerCache){
	rmiServer=getRMIServer(supplierNodeId);
      }else{
	rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
      }
      
      if(rmiServer != null){
        return rmiServer.issueDemandRead(id, offset, length, requestId, 
                                         readerNodeId, readerNodeDNS, 
                                         readerPortBody,
					 as);
      }else{
        throw new RMINetworkException("RMINetworkException: cannot find " +
                                      "rmiServer for issueDemandRead");
      }
    }catch(java.rmi.NotBoundException z){
      throw new RMINetworkException("RMINetworkException: cannot bind " +
                                    "rmiServer for issueDemandRead");
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      if(useRMIServerCache){
	//possible the cached server is destroyed at the remote node
	removeRMIServerFromCache(supplierNodeId);
      }
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      throw new RMINetworkException(b);
    }catch(UnknownHostException d){
      throw new RMINetworkException(d);
    }catch(UnableToConnectException f){
      throw new RMINetworkException(f);
    }catch(RemoteException e){
      throw new RMIApplicationException(e);
    }
    assert(false); // Return is here to make compiler happy
    return 0;
  }
 
  public Hashtable getStats(NodeId targetNodeId) 
    throws RMINetworkException, RMIApplicationException{
    Hashtable h = null;
    RMIServer rmiServer = null;
    try{
      
      if(useRMIServerCache){
	rmiServer=getRMIServer(targetNodeId);
      }else{
	rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(targetNodeId));
      }
      
      h = rmiServer.getStats();
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      if(useRMIServerCache){
	//possible the cached server is destroyed at the remote node
	removeRMIServerFromCache(targetNodeId);
      }
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
      // throw new RMINetworkException(c);
      System.err.println("Unable to contact " + targetNodeId +
                         " to get stats");
    }catch(UnknownHostException d){
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      throw new RMIApplicationException(e);
    }
    return h;
  }



/*
 *------------------------------------------------------------------
 *
 * requestSync --
 *
 *          Ask that <remoteNodeId> send a sync to <sendToNodeId>
 *          when <acceptStamp> has been applied to <remoteNodeId>'s
 *          local state.
 *
 * Arguments:
 *      type1 arg1 -- description.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
  public void requestSync(NodeId remoteNodeId, 
                          NodeId sendToNodeId, 
                          AcceptStamp acceptStamp)
    throws RMINetworkException, RMIApplicationException{
    RMIServer rmiServer = null;
    Env.dprintln(dbg, "rmiClient::requestSync from "+ remoteNodeId 
		 + " to " + sendToNodeId + " for " + acceptStamp); 
    try{
      if(useRMIServerCache){
	rmiServer=getRMIServer(remoteNodeId);
      }else{
	rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(remoteNodeId));
      }
      
      
      if(rmiServer != null){
        rmiServer.requestSync(sendToNodeId, acceptStamp);
        return;
      }else{
        throw new RMINetworkException("RMINetworkException: cannot find " +
                                      "rmiServer for issueDemandRead");
      }
    }catch(java.rmi.NotBoundException z){
      throw new RMINetworkException("RMINetworkException: cannot bind " +
                                    "rmiServer for issueDemandRead");
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      if(useRMIServerCache){
	//possible the cached server is destroyed at the remote node
	removeRMIServerFromCache(remoteNodeId);
      }
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      throw new RMINetworkException(b);
    }catch(UnknownHostException d){
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      throw new RMIApplicationException(e);
    }
    assert(false);
    return; // Return is here to make compiler happy
  }
  
  public void requestSync(NodeId remoteNodeId, 
                          NodeId sendToNodeId, 
                          AcceptVV acceptVV)
    throws RMINetworkException, RMIApplicationException{
    RMIServer rmiServer = null;

    try{
      if(useRMIServerCache){
	rmiServer=getRMIServer(remoteNodeId);
      }else{
	rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(remoteNodeId));
      }
      
      if(rmiServer != null){
        rmiServer.requestSync(sendToNodeId, acceptVV);
        return;
      }else{
        throw new RMINetworkException("RMINetworkException: cannot find " +
                                      "rmiServer for issueDemandRead");
      }
    }catch(java.rmi.NotBoundException z){
      throw new RMINetworkException("RMINetworkException: cannot bind " +
                                    "rmiServer for issueDemandRead");
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      if(useRMIServerCache){
	//possible the cached server is destroyed at the remote node
	removeRMIServerFromCache(remoteNodeId);
      }
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      throw new RMINetworkException(b);
    }catch(UnknownHostException d){
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      throw new RMIApplicationException(e);
    }
    assert(false);
    return; // Return is here to make compiler happy
  }

  public VV getCurrentVV(NodeId ofNodeId)
    throws RMINetworkException, RMIApplicationException{
    RMIServer rmiServer = null;
   
    try{
      if(useRMIServerCache){
	rmiServer=getRMIServer(ofNodeId);
      }else{
	rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(ofNodeId));
      }
      
      if(rmiServer != null){
        return rmiServer.getCurrentVV();
      }else{
        throw new RMINetworkException("RMINetworkException: cannot find " +
                                      "rmiServer for getCurrentVV");
      }
    }catch(java.rmi.NotBoundException z){
      throw new RMINetworkException("RMINetworkException: cannot bind " +
                                    "rmiServer for getCurrentVV");
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      if(useRMIServerCache){
	//possible the cached server is destroyed at the remote node
	removeRMIServerFromCache(ofNodeId);
      }
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      throw new RMINetworkException(b);
    }catch(UnknownHostException d){
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      throw new RMIApplicationException(e);
    }
    assert(false);
    return null; // Return is here to make compiler happy
  }


 /** 
 *  ****** callback ********* start 
 **/ 

 /** 
 *  subscribeInval()  -- 
 *       add a subscriptionset into a connection 
 *       if the connection does not exist, create a new connection. 
 *  
 *  issues:  
 *  1. "excludedChildren" 
 *  Do we need "excludeChildren" in this interface? 
 *  We merge the shipCheckpoint interface with the inval subscription. 
 *  In the shipCheckpoint we have the excluded children? Do we still need 
 *  it here? 
 *  
 *  as discussed with Amol, no, we don't need the excldChildren. We 
 *  need to change the shipCheckpoint code a little different. We need 
 *  to send any PTreeNode that is overlapped by the subscriptionset 
 *  and with the associated "other".lpvv = min ("other".lpvv, children that's not 
 *  included by the subscriptionset. 
 *  ==> need to think about the liveness: i.e. if a PTreeNode which is only partial overlapping 
 *      with any other nodes' PTreeNode, will it be precise eventually? 
 *  
 *  2. "duration" 
 *  as we now only have one connection, duration might not be necessary as  
 *  we have remove command, maybe the runtime should implement the duration 
 *  if needed by using the remove interface. 
 *  
 *  3. "maxForceMS", "maxDelayMS" 
 *  we only need one set of "maxForceMS", "maxDelayMS" as we now only have one stream 
 *  how to deal with multiple inputs with multiple subscription? 
 *   
 *  For simplicity, I just assume we only have one "maxForceMS", "maxDelayMS" for 
 *  one connection which is defined by default in the configure file. And there's no 
 *  duration constraint any more. 
 *  Note: "maxDelayMS" works naturally in the new protocol and make the prevVV advance 
 *        graduately even if there's no new interested precise invalidation. 
 *  
 *  4. "endVV" 
 *  I also errase the "endVV" argument because we have remove method, if the controller 
 *  knows when to stop the subscription, it should also be able to issue the remove  
 *  command later. 
 **/ 
  
//   public void 
//   subscribeInval(NodeId supplierNodeId,
//                  NodeId subscriberNodeId, 
//                  SubscriptionSet ss, 
//                  AcceptVV startVV,
//		  boolean catchupWithCP/*, 
//		  boolean includeAll*/)                            
//     throws RMINetworkException, RMIApplicationException{
//     subscribeInval(supplierNodeId, subscriberNodeId,
//		    Config.getDNS(subscriberNodeId), 
//		    Config.getPortInval(subscriberNodeId), 
//		    ss, startVV,
//		    catchupWithCP,
//		    false, 
//		    includeAll);//withBody
//   }

   public AcceptVV 
   subscribeInval(NodeId supplierNodeId,
                  NodeId subscriberNodeId, 
                  SubscriptionSet ss, 
                  AcceptVV startVV,
                  boolean catchupWithCP)                            
     throws RMINetworkException, RMIApplicationException{
     return subscribeInval(supplierNodeId, subscriberNodeId,
                    Config.getDNS(subscriberNodeId), 
                    Config.getPortInval(subscriberNodeId), 
                    ss, startVV,
                    catchupWithCP,
                    false/*, 
                    false*/);//withBody
   }
   
  public AcceptVV 
  subscribeInval(NodeId supplierNodeId,
                 NodeId subscriberNodeId,
                 String subscriberNodeDNS, 
                 int subscriberPortInval,
                 SubscriptionSet ss, 
                 AcceptVV startVV,
		 boolean catchupWithCP/*, 
		 boolean includeAll*/)
  throws RMINetworkException, RMIApplicationException{
    return this.subscribeInval(supplierNodeId,
                   subscriberNodeId,
                   subscriberNodeDNS,
                   subscriberPortInval,
                   ss,
                   startVV,
                   catchupWithCP,
                   false/*, //withBody
                   includeAll*/);
  }
  
//  public void 
//  subscribeInval(NodeId supplierNodeId,
//                 NodeId subscriberNodeId,
//                 String subscriberNodeDNS, 
//                 int subscriberPortInval,
//                 SubscriptionSet ss, 
//                 AcceptVV startVV,
//                 boolean catchupWithCP,
//                 boolean cpWithBody)
//    throws RMINetworkException, RMIApplicationException
//    {
//      subscribeInval(supplierNodeId,
//                 subscriberNodeId,
//                 subscriberNodeDNS, 
//                 subscriberPortInval,
//                 ss, 
//                 startVV,
//                 catchupWithCP,
//                 cpWithBody, 
//                 false);
//    }
  public AcceptVV 
  subscribeInval(NodeId supplierNodeId,
                 NodeId subscriberNodeId,
                 String subscriberNodeDNS, 
                 int subscriberPortInval,
                 SubscriptionSet ss, 
                 AcceptVV startVV,
                 boolean catchupWithCP,
                 boolean cpWithBody/*, 
                 boolean includeAll*/)
    throws RMINetworkException, RMIApplicationException
    {
    AcceptVV returnVV = null;
      if(dbg){
        Env.dprintln(dbg, "RMIClient::subscribeInval(senderID="+supplierNodeId.toString()
                     + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString()
                     + "startvv=" + startVV.toString());
      }
      
      long end, totalTime, start;
      if(dbgPerformance ||printTime){
	start = System.currentTimeMillis();
	Env.dprintln(dbgPerformance, " start@ "
		     + start + " ---rmiClient::subscribeInval(senderID="+supplierNodeId.toString()
                     + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString()
                     + "startvv=" + startVV.toString());
      }
      RMIServer rmiServer = null;
      try{

	if(useRMIServerCache){
          rmiServer=getRMIServer(supplierNodeId);
        }else{
          rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
        }
      
        
	if(dbgPerformance){
	  end = System.currentTimeMillis();
	  Env.dprintln(dbgPerformance, " Naminglookup****** "
		       + (end-start) + " ---rmiClient::subscribeInval(senderID="+supplierNodeId.toString()
		       + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString()
		       + "startvv=" + startVV.toString());
	}
        returnVV = rmiServer.subscribeInval(subscriberNodeId, 
                                 subscriberNodeDNS, 
                                 subscriberPortInval,
                                 ss, 
                                 startVV,
				 catchupWithCP,
				 cpWithBody/*, 
				 includeAll*/);
	
	if(dbgPerformance){
	  end = System.currentTimeMillis();
	  totalTime = (end-start);
	  Env.dprintln(dbgPerformance, "end@ " + end + "---- take @@@@@@@" + totalTime
		       + "ms " + "RMIClient::subscribeInval(senderID="+supplierNodeId.toString()
		       + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString()
		       + "startvv=" + startVV.toString());
	}
	
	return returnVV;
      }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
	if(useRMIServerCache){
	  //possible the cached server is destroyed at the remote node
	  removeRMIServerFromCache(supplierNodeId);
	}
	Env.dprintln(true, "RMIClient::subscribeInval(senderID="+supplierNodeId.toString()
                     + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString()
                     + "startvv=" + startVV.toString());
	//a.printStackTrace();
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
	//b.printStackTrace();
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
	//c.printStackTrace();
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
	//d.printStackTrace();
        throw new RMINetworkException(d);
      }catch(RemoteException e){
	//e.printStackTrace();
        throw new RMIApplicationException(e);
      }
      return returnVV;
    }

  
  public void subscribeInval(NodeId supplierNodeId,
      long subscriberNodeId, 
      String ss,
      boolean catchupWithCP)
throws RMINetworkException, RMIApplicationException
{
    this.subscribeInval(supplierNodeId, subscriberNodeId, ss, catchupWithCP, false);
}
 /** 
 *  subscribeInval -- fast case. Use startVV = <ACCEPT_STAMP_TO_FILTER_MY_OWN_UPDATES, nodeId> 
 *  and avoid sending complex subscriptionSet data structure 
 **/ 
 
  public void subscribeInval(NodeId supplierNodeId,
                             long subscriberNodeId, 
                             String subscriptionSetString,
			     boolean catchupWithCP,
			     boolean withBody)
    throws RMINetworkException, RMIApplicationException
  {
    if(dbg){
      Env.dprintln(dbg, "RMIClient::subscribeInval(senderID=" + supplierNodeId
                   + " recvId=" + subscriberNodeId 
                   + " subscriptionSet=" + subscriptionSetString);
    }

    long start = System.currentTimeMillis();
    if( dbgPerformance )
      {
	Env.dprintln(dbgPerformance, "start @ "+ start 
		     + " RMIClient::subscribeInval(senderID=" + supplierNodeId
                   + " recvId=" + subscriberNodeId 
                   + " subscriptionSet=" + subscriptionSetString);
      }
    RMIServer rmiServer = null;
    try{
      if(useRMIServerCache){
	rmiServer=getRMIServer(supplierNodeId);
      }else{
	rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
      }
      
      rmiServer.subscribeInval(subscriberNodeId, subscriptionSetString, catchupWithCP, withBody);
      long end = System.currentTimeMillis();
      long totalTime = (end-start);
      if( dbgPerformance ){
	Env.dprintln(dbgPerformance, "end@ " + end + " ----" 
		     + totalTime+ "ms " 
		     + "RMIClient::subscribeInval(senderID=" + supplierNodeId
		     + " recvId=" + subscriberNodeId 
		     + " subscriptionSet=" + subscriptionSetString);
      }
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      if(useRMIServerCache){
	//possible the cached server is destroyed at the remote node
	removeRMIServerFromCache(supplierNodeId);
      }
      // a.printStackTrace();
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      //b.printStackTrace();
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
      //c.printStackTrace();
      throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      //d.printStackTrace();
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      //e.printStackTrace();
      throw new RMIApplicationException(e);
    }
  }


 /** 
 *  removeSubscribInval -- 
 *     Remove subscriptionset from a connection at the sender side 
 *   
 *  if the remaining subscriptionset is emtpy, close the connection 
 *  it might be called because the receiver finds that the connection kicked off anyone 
 *  at the receiver side. 
 **/ 
  public void 
  removeSubscribeInval(NodeId supplierNodeId,
                       NodeId subscriberNodeId,
                       SubscriptionSet ss)
    throws RMINetworkException, RMIApplicationException
    {

      removeSubscribeInval(supplierNodeId, subscriberNodeId, 
                           Config.getDNS(subscriberNodeId), 
                           Config.getPortInval(subscriberNodeId),
                           ss);
    }


  public void 
  removeSubscribeInval(NodeId supplierNodeId,
                       NodeId subscriberNodeId,
                       String subscriberNodeDNS, 
                       int subscriberPortInval,
                       SubscriptionSet ss)
    throws RMINetworkException, RMIApplicationException
    {
      RMIServer rmiServer = null;
      try{
	if(useRMIServerCache){
	  rmiServer=getRMIServer(supplierNodeId);
	}else{
	rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
	}
        rmiServer.removeSubscribeInval(subscriberNodeId, 
                                       subscriberNodeDNS, 
                                       subscriberPortInval,
                                       ss);
      }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
	if(useRMIServerCache){
	  //possible the cached server is destroyed at the remote node
	  removeRMIServerFromCache(supplierNodeId);
	}
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        throw new RMIApplicationException(e);
      }
      
    }

 /** 
 *  removeConnection -- 
 *     Remove a connection at the sender side 
 *   
 *   
 *  it might be called because the receiver finds that the connection kicked off anyone 
 *  at the receiver side. or the recovery has finished 
 **/ 
  public void 
  removeConnection(NodeId supplierNodeId,
                   NodeId subscriberNodeId,
                   String subscriberNodeDNS, 
                   int subscriberPortInval)
    throws RMINetworkException, RMIApplicationException{
    RMIServer rmiServer = null;
    try{
      if(useRMIServerCache){
	rmiServer=getRMIServer(supplierNodeId);
      }else{
	rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
      }
       rmiServer.removeConnection(subscriberNodeId, 
				  subscriberNodeDNS, 
				  subscriberPortInval);
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      if(useRMIServerCache){
	//possible the cached server is destroyed at the remote node
	removeRMIServerFromCache(supplierNodeId);
      }
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
        throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      throw new RMIApplicationException(e);
    }
  }
  
 /** 
 *  removeConnection -- 
 *     Remove a connection at the sender side 
 *   
 *   
 *  it might be called because the receiver finds that the connection kicked off anyone 
 *  at the receiver side. or the recovery has finished 
 **/ 
  public void 
  removeConnection(NodeId supplierNodeId,
                   NodeId subscriberNodeId)
    throws RMINetworkException, RMIApplicationException{
    RMIServer rmiServer = null;
    try{
      if(useRMIServerCache){
        rmiServer=getRMIServer(supplierNodeId);
      }else{
        rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
      }
       rmiServer.removeConnection(subscriberNodeId, 
                                  Config.getDNS(subscriberNodeId), 
                                  Config.getPortInval(subscriberNodeId));
                                  //Config.getDNS(supplierNodeId), 
                                  //Config.getPortBody(supplierNodeId));
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){
      if(useRMIServerCache){
        //possible the cached server is destroyed at the remote node
        removeRMIServerFromCache(supplierNodeId);
      }
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
        throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      throw new RMIApplicationException(e);
    }
  }
  
 /** 
 *  removeSubscribeBody 
 *     Removes the body subscription set from the connection 
 *  
 **/ 
  public void
  removeSubscribeBody(NodeId supplierNodeId,
                      NodeId subscriberNodeId,
                      SubscriptionSet ss)
    throws RMINetworkException, RMIApplicationException{
    removeSubscribeBody(supplierNodeId, subscriberNodeId, 
                        Config.getDNS(subscriberNodeId), 
                        Config.getPortBody(subscriberNodeId),
                        ss);
      }

  public void
  removeSubscribeBody(NodeId supplierNodeId,
                      NodeId subscriberNodeId,
                      String subscriberNodeDNS,
                      int subscriberPortBody,
                      SubscriptionSet ss)
  throws RMINetworkException, RMIApplicationException
    {
      RMIServer rmiServer = null;
      try{
	if(useRMIServerCache){
	  rmiServer=getRMIServer(supplierNodeId);
	}else{
	  rmiServer = (RMIServer)Naming.lookup(Config.getRMIUrl(supplierNodeId));
	}
        rmiServer.removeSubscribeBody(subscriberNodeId, 
				      subscriberNodeDNS, 
				      subscriberPortBody,
				      ss);
      }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
	if(useRMIServerCache){
	  //possible the cached server is destroyed at the remote node
	  removeRMIServerFromCache(supplierNodeId);
	}
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        throw new RMIApplicationException(e);
      }
  }
  
  

 /** 
 *  ****** callback ********* end 
 **/ 

}

//---------------------------------------------------------------------------
/* $Log: RMIClient.java,v $
/* Revision 1.53  2007/11/28 08:11:34  nalini
/* safety policy module and example checked in
/*
/* Revision 1.52  2007/10/19 23:08:40  zjiandan
/* Coda demo for SOSP poster 2007.
/*
/* Revision 1.51  2007/10/07 04:47:04  zjiandan
/*  coda cooperative caching exp
/*
/* Revision 1.50  2007/10/06 18:44:06  zjiandan
/* *** empty log message ***
/*
/* Revision 1.49  2007/10/06 05:29:53  zjiandan
/* Add Coda java hack version.
/*
/* Revision 1.48  2007/09/10 23:52:22  zjiandan
/* upgrade to newest BerkeleyDB je version.
/*
/* Revision 1.47  2007/06/04 21:40:59  zjiandan
/* expose stream catchup type CP|LOG option to rmiClient.subscribeInval().
/*
/* Revision 1.46  2007/05/31 06:02:01  zjiandan
/* add AllPreciseSetsUnit
/*
/* Revision 1.45  2007/05/30 20:30:19  dahlin
/* Added checkpoint to SubscribeBWUnit. Changed outgoingconnection checkpoint 
/* send to not send body by default. Told barrier to close sockets when done with them.
/*
/* Revision 1.44  2007/04/04 20:17:22  zjiandan
/* fix rmi server cache bug.
/*
/* Revision 1.43  2007/04/02 21:11:38  zjiandan
/* snapshort for sosp2007.
/*
/* Revision 1.42  2007/03/16 07:10:18  zjiandan
/* fixed OutgoingConnection unittest.
/*
/* Revision 1.41  2007/03/15 21:58:31  dahlin
/* Added experimetn to test BW for subscribe for SOSP paper
/*
/* Revision 1.40  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.38  2007/03/06 18:25:51  zjiandan
/* Add optimization for CatchupInvalIterator, fixed SubscriptionSet, HierInvalTarget
/* and P2Runtime problems. Add aways split when receiving subtree ISStatus in Checkpoint.
/*
/* Revision 1.37  2007/03/02 04:20:54  zjiandan
/* sync
/*
/* Revision 1.36  2007/03/02 01:35:28  zjiandan
/* Yeah! Working Simplified TierStore.
/*
/* Revision 1.35  2007/02/27 04:44:41  zjiandan
/* change readOfHole interface such that read of hole will throw an
/* ReadOfHoleException with the position of the next written byte.
/*
/* Revision 1.34  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.33  2007/01/05 01:18:41  nalini
/* support for sync with VV added
/*
/* Revision 1.32  2006/08/16 21:26:18  dahlin
/* PicShareUnit test works on linux, too!
/*
/* Revision 1.31  2006/06/14 22:50:09  nalini
/* Changed nice sockets to normal sockets for outgoing body connections
/*
/* Revision 1.30  2006/06/13 03:49:19  nalini
/* RMI for P2 Runtime Implemented
/*
/* Revision 1.29  2006/04/22 07:59:53  nalini
/* Working Version of P2 Runtime: Works with JD's interfaces
/*
/* Revision 1.28  2006/04/21 06:52:12  zjiandan
/* *** empty log message ***
/*
/* Revision 1.27  2006/04/21 02:57:33  nalini
/* Merging Nalini's P2 code and JD's callback code
/*
/* Revision 1.26  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/*
/* Revision 1.25  2005/10/16 04:20:12  zjiandan
/* add "boolean withBody" parameter for Checkpoint exchange.
/*
/* Revision 1.24  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.23  2005/07/18 05:10:23  zjiandan
/* Embargoed Writes etc. features implementation plus
/* log overhead measurement with disk size and in-memory size.
/*
/* Revision 1.22  2005/03/22 23:00:03  zjiandan
/* Changes for TactExpt.
/*
/* Revision 1.21  2005/03/05 04:50:13  nayate
/* Added some testing code
/*
/* Revision 1.20  2005/03/04 05:52:19  nayate
/* Minor changes
/*
/* Revision 1.19  2005/03/01 04:41:47  nayate
/* Merged changes
/*
/* Revision 1.18  2005/03/01 04:36:46  nayate
/* Modified for new code
/*
/* Revision 1.17  2005/01/13 20:55:40  zjiandan
/* Reorganized sosp experiments files into sosp subdirectory under experiments.
/*
/* Revision 1.16  2005/01/10 03:47:47  zjiandan
/* Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments.
/*
/* Revision 1.15  2004/10/22 20:46:55  dahlin
/* Replaced TentativeState with RandomAccessState in DataStore; 
/* got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT 
/* (1) get compile-time error in rmic and 
/* (2) ./runSDIMSControllerTest fails [related to (1)?]
/*
/* Revision 1.14  2004/10/13 17:41:36  zjiandan
/* Initial implementation of PersistentLog tested with DataStore stubs.
/*
/* TBD: test recovery with integrated DataStore and RandomAccessState.
/*
/* Revision 1.13  2004/05/20 01:06:11  arun
/* added some code for recovery support in store. Added maxVV definition in COunterVV etc.
/*
/* Revision 1.12  2004/05/19 04:34:55  dahlin
/* SDIMSController test compiles and runs but deadlocks
/*
/* Revision 1.11  2004/05/19 03:09:01  dahlin
/* Fixed default constructor for URANode
/*
/* Revision 1.10  2004/05/19 02:14:44  dahlin
/* Making progress on SDIMSController spanning test
/*
/* Revision 1.9  2004/05/13 20:09:10  dahlin
/* When core has applied a bound inval, it tells originator of the write
/*
/* Revision 1.8  2004/05/13 01:15:33  nayate
/* Minor change in error handling code
/*
/* Revision 1.7  2004/05/12 20:44:24  lgao
/* Add rmi interface for distributed stats collection at the coordinator.
/*
/* Revision 1.6  2004/05/11 03:49:45  zjiandan
/* Made some changes to get the first version to work.
/*
/* Revision 1.5  2004/05/10 20:48:19  dahlin
/* Clarified RMI exceptions; full version of (stub) DemandReadWorker
/*
/* Revision 1.4  2004/05/08 22:18:57  dahlin
/* Partially complete version of SDIMSController (it should compile w/o error, though)
/*
/* Revision 1.3  2004/04/19 23:30:05  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
