package code;
/*
 * The RMIServer interface is really a control interface.
 * Other nodes "poke" this node via the RMIServer interface
 * to set up data connections for invalidations, updates,
 * checkpoint commit notifications, etc.
 */

import java.util.Hashtable;
import java.rmi.*;
import java.io.*;

public interface RMIServer extends java.rmi.Remote
{
/*
  //-------------------------------------------------------------------
  // a specified node (perhaps not the caller) would like
  // to start receiving invalidations, commit notifications,
  // and reliableNotifications from the called node.
  // The called node will connect to the appropriate ports
  // on nodeId and begin sending streams of information.
  //-------------------------------------------------------------------
  public void subscribe(SubscriptionSet ss, VV startVV, VV endVV, 
                        NodeId subscriberNodeId, 
                        String subscriberNodeDNS, int portInval, 
                        long subscriptionDurationMS, long maxForceMS,
                        long maxDelayMS)
    throws java.rmi.RemoteException;     
*/

 /** 
 *  ****** callback ********* start 
 **/ 
 /** 
 *  subscribeInval()  -- 
 *       add a subscriptionset into a connection 
 *       if the connection does not exist, create a new connection. 
 *  
 *  issues:  
 *  1. "excludedChildren" 
 *  Do we need "excludeChildren" in this interface? 
 *  We merge the shipCheckpoint interface with the inval subscription. 
 *  In the shipCheckpoint we have the excluded children? Do we still need 
 *  it here? 
 *  
 *  as discussed with Amol, no, we don't need the excldChildren. We 
 *  need to change the shipCheckpoint code a little different. We need 
 *  to send any PTreeNode that is overlapped by the subscriptionset 
 *  and with the associated "other".lpvv = min ("other".lpvv, children that's not 
 *  included by the subscriptionset. 
 *  ==> need to think about the liveness: i.e. if a PTreeNode which is only partial overlapping 
 *      with any other nodes' PTreeNode, will it be precise eventually? 
 *  
 *  2. "duration" 
 *  as we now only have one connection, duration might not be necessary as  
 *  we have remove command, maybe the runtime should implement the duration 
 *  if needed by using the remove interface. 
 *  
 *  3. "maxForceMS", "maxDelayMS" 
 *  we only need one set of "maxForceMS", "maxDelayMS" as we now only have one stream 
 *  how to deal with multiple inputs with multiple subscription? 
 *   
 *  For simplicity, I just assume we only have one "maxForceMS", "maxDelayMS" for 
 *  one connection which is defined by default in the configure file. And there's no 
 *  duration constraint any more. 
 *  Note: "maxDelayMS" works naturally in the new protocol and make the prevVV advance 
 *        graduately even if there's no new interested precise invalidation. 
 *  
 *  4. "endVV" 
 *  I also errase the "endVV" argument because we have remove method, if the controller 
 *  knows when to stop the subscription, it should also be able to issue the remove  
 *  command later. 
 **/ 
  public AcceptVV subscribeInval(NodeId subscriberNodeId, 
                             String subscriberNodeDNS, 
                             int portInval, 
                             SubscriptionSet ss,                     
                             AcceptVV startVV,
			     boolean catchupWithCP,
			     boolean cpWithBody/*, 
			     boolean includeAll*/)
    throws java.rmi.RemoteException;     

 /** 
 *  Optimize common case to get RMI cost down -- a nodeID at the configured 
 *  address, a 1-element subscriptionset, and startVV = start of time 
 *  except exclude everything from node. 
 **/ 
  public void subscribeInval(long nodeId, 
			     String subscriptionSetString,
			     boolean catchupWithCP,
			     boolean cpWithBody)
    throws java.rmi.RemoteException;     
 
 /** 
 *  removeSubscribInval -- 
 *     Remove subscriptionset from a connection at the sender side 
 *   
 *  Note: the sender will send imprecise invalidation in the following stream which 
 *        will automatically kick out the subscription set at the receiver side. 
 *        E.g. for removing, we only need to invoke it at the sender side 
 *  
 *  it might be called because the receiver finds that the connection kicked off anyone 
 *  at the receiver side. 
 **/ 
  void 
  removeSubscribeInval(NodeId subscriberNodeId,
                       String subscriberNodeDNS, 
                       int subscriberPortInval,
                       SubscriptionSet ss)
    throws java.rmi.RemoteException;    

 /** 
 *  removeSubscribeBody -- 
 *     Remove subscriptionset from a connection at the sender side 
 *   
 *     Currently does nothing 
 *  
 **/ 
  void 
  removeSubscribeBody(NodeId subscriberNodeId,
                       String subscriberNodeDNS, 
                       int subscriberPortInval,
                       SubscriptionSet ss)
    throws java.rmi.RemoteException;    

 /** 
 *  removeConnection -- 
 *     Remove a connection at the sender side 
 *   
 *   
 *  it might be called because the receiver finds that the connection kicked off anyone 
 *  at the receiver side. 
 **/ 
  void 
  removeConnection(NodeId subscriberNodeId,
                   String subscriberNodeDNS, 
                   int subscriberPortInval)
    throws java.rmi.RemoteException;    
  
 /** 
 *  ****** callback ********* end 
 **/ 

/*
  //-------------------------------------------------------------------
  // a specified node (perhaps not the caller) would like
  // to start receiving checkpoint from the called node.
  // The called node will connect to the appropriate ports
  // on nodeId and begin sending streams of information.
  //-------------------------------------------------------------------
  public void subscribeCheckpoint(String cpPath,
                                  String[] exclChildNames,
                                  VV startVV,
                                  NodeId subscriberNodeId, 
                                  String subscriberNodeDNS, 
                                  int portInval,
				  boolean withBody)
    throws java.rmi.RemoteException;     
*/  
 /** 
 *  Subscribe to data updates from a given SubscriptionSet. 
 *  The callee will connect to the specified node on the 
 *  specified port and begin sending updates (not necesarily 
 *  in any particular order.) 
 **/ 
  public void subscribeBody(SubscriptionSet ss, VV startVV, 
                            NodeId subscriberNodeId, String subscriberNodeDNS, 
                            int portBody,
                            long subscriptionDurationMS)
    throws java.rmi.RemoteException;

  //
  // An asynchronous demand read request. The callee should
  // send the most current version of the specified object
  // to the specified node's body port. (Notice that this
  // body send will look just like a prefetch except that
  // we will also include as a liveness hint a token <requestId>.
  // Demand read requests are blocking at the caller until
  // a "new enough" reply has been processed; if the reply
  // triggered by this demand read is not "new enough", 
  // the requestId token lets the caller know that it might
  // want to try issuing some more demandReads perhaps to
  // other nodes...
  //
  // Return the number of bytes (up to length) that
  // the asynchronously sent update will satisfy
  // (so that if the result we return will only be 
  // a partial result, the caller knows to also issue
  // a request for the rest.)
  //
  public int issueDemandRead(ObjId id, long offset, long length, 
                             long requestId, NodeId requestorNodeId, String nodeDNS,
                             int portBody, 
			     AcceptStamp as)
    throws java.rmi.RemoteException, ObjNotFoundException, 
    UnableToConnectException, IOException,
	   EOFException, ReadOfInvalidRangeException, ReadOfHoleException;

  //
  // Ask to send a sync message to nodeId once 
  // you have processed the message with the specified acceptStamp.
  // This is used to ensure reliability by checking to
  // see that bound writes have made it to specific nodes.
  //
  public void requestSync(NodeId requestorNodeId, AcceptStamp acceptStamp)
    throws java.rmi.RemoteException;
  
  public void requestSync(NodeId requestorNodeId, AcceptVV acceptVV)
    throws java.rmi.RemoteException;
  
  public VV getCurrentVV()
    throws java.rmi.RemoteException;

  // collecting stats from remote nodes
  public Hashtable getStats() throws java.rmi.RemoteException;

}

//---------------------------------------------------------------------------
/* $Log: RMIServer.java,v $
/* Revision 1.22  2007/06/04 21:40:59  zjiandan
/* expose stream catchup type CP|LOG option to rmiClient.subscribeInval().
/*
/* Revision 1.21  2007/03/15 21:58:31  dahlin
/* Added experimetn to test BW for subscribe for SOSP paper
/*
/* Revision 1.20  2007/02/27 04:44:41  zjiandan
/* change readOfHole interface such that read of hole will throw an
/* ReadOfHoleException with the position of the next written byte.
/*
/* Revision 1.19  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.18  2007/01/05 01:18:41  nalini
/* support for sync with VV added
/*
/* Revision 1.17  2006/11/18 05:23:17  nalini
/* new read interface implemented
/*
/* Revision 1.16  2006/04/21 02:57:33  nalini
/* Merging Nalini's P2 code and JD's callback code
/*
/* Revision 1.15  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/*
/* Revision 1.14  2005/10/16 04:20:12  zjiandan
/* add "boolean withBody" parameter for Checkpoint exchange.
/*
/* Revision 1.13  2005/03/22 23:00:03  zjiandan
/* Changes for TactExpt.
/*
/* Revision 1.12  2005/03/03 08:07:55  nayate
/* Added some checkpoint transfer code
/*
/* Revision 1.11  2005/03/01 04:41:02  nayate
/* Merged changes
/*
/* Revision 1.10  2005/03/01 04:34:16  nayate
/* Modified for new code
/*
/* Revision 1.9  2005/02/28 20:25:59  zjiandan
/* Added Garbage Collection code and part of Checkpoint exchange protocol code
/*
/* Revision 1.8  2005/01/13 20:55:40  zjiandan
/* Reorganized sosp experiments files into sosp subdirectory under experiments.
/*
/* Revision 1.7  2004/10/22 20:46:55  dahlin
/* Replaced TentativeState with RandomAccessState in DataStore; got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT (1) get compile-time error in rmic and (2) ./runSDIMSControllerTest fails [related to (1)?]
/*
/* Revision 1.6  2004/10/13 17:41:36  zjiandan
/* Initial implementation of PersistentLog tested with DataStore stubs.
/*
/* TBD: test recovery with integrated DataStore and RandomAccessState.
/*
/* Revision 1.5  2004/05/20 01:06:11  arun
/* added some code for recovery support in store. Added maxVV definition in COunterVV etc.
/*
/* Revision 1.4  2004/05/12 20:44:24  lgao
/* Add rmi interface for distributed stats collection at the coordinator.
/*
/* Revision 1.3  2004/04/19 23:30:05  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
