package code;
 /** 
 *  
 *  Note: run  
 *        rmic -d . RMIServerImpl 
 * / will generate the skeleton and stub classes 
 *        RMIServerImpl_Skel.class 
 *        RMIServerImpl_Stub.class 
 *  
 **/ 
import java.util.Hashtable;
import java.rmi.*;
import java.rmi.server.*;
import java.io.*;

import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.security.SecureCore;
import code.security.SecureImpreciseInv;
import code.security.SplitSecureImpreciseInv;

public class RMIServerImpl extends UnicastRemoteObject implements RMIServer
{
   public static final boolean useNewIterator = Core.useNewIterator;
  
  //
  // to test the raw performance of rmi call
  // set the testRawRMIPerformance to true
  // it will make every rmi call return immediately without doing anything.
  // 
  // note: leave it as false as always, only turn on for test.
  protected static final boolean testRawRMIPerformance = false;
  protected static final boolean turnOffSyncRequest = false;

  // exposed to overlog
  //static final boolean cpWithBody = false;//checkpoint goes with body as well
  //Note: by default this should be turned off.
  //      In any case if you want to turn this on,
  //      you should be aware that some unit tests might not work properly.
  //      In particular: subscribeBWInval won't work.
  //                     subscribeAndWait will wait for ever because
  //                     it is expecting an invalidate object instead of a valid object.
  //                     after the cp catchup.
  
  protected static final boolean doStats = false;
  static final boolean dbgDemandReadFailure = false;
  protected static final boolean dbgPerformance = false;
  protected static final boolean dbgInvalSub = false;
  boolean dbgVerbose = false;
  public static void main(String[] argv){
    if(argv.length < 2){
      System.out.println("Usage: [configuration file] [local node id]");
      System.exit(-1);
    }
    Config.readConfig(argv[0]);
    try{
      (new RMIServerImpl(null, new LocalController(null))).start();
    } catch (Exception e){
      e.printStackTrace();
      System.exit(-1);
    }
  }

  protected Core _core;
  protected Controller controller;
  protected boolean started;
  protected StreamPool demandStreams;  // A list of all outbound streams for
  // sending bodies. Keyed by nodeDNS and
  // port. Need this because streams are
  // shared by subscriptions and by demand
  // read replies (and send unordered msgs).
  //NiceStreamPool prefetchStreams;

  protected SyncPool syncRequestBuffers;

  
  protected OutgoingConnectionPool ocp = null;//callback
  protected OutgoingInvalConnectionPool icp = null; //new callback
  protected OutgoingBodyConnectionPool bcp;

  protected RMIServerImpl() throws RemoteException{
    
  }
  
  public RMIServerImpl(Core core, Controller controller_) 
    throws java.rmi.RemoteException{
    
    if(core == null){
      System.err.println("null is passed in as the Core");
    }
    _core = core;
    assert(controller_ != null);
    this.controller = controller_;
    // Don't forget to call start() after calling the constructor
    // (start needs to reference "this" so can't be merged in).
    started = false;
    //prefetchStreams = new NiceStreamPool(core.getMyNodeId());
    demandStreams = new StreamPool(core.getMyNodeId());
    syncRequestBuffers = new SyncPool(_core);

    if(doStats){
      Env.warn("Performance warning: Stats turned on in RMIServerImpl. "
               + " Extra copy being made of all RMIs");
    }
    if(useNewIterator){
      icp = new OutgoingInvalConnectionPool(core, controller);
    }else{
      ocp = new OutgoingConnectionPool(core, controller);//callback
    }
    bcp = new OutgoingBodyConnectionPool(core, controller, demandStreams);
  }

  public void start(){
    //	System.setSecurityManager(new RMISecurityManager());
    try{
      
	//Env.inform("RMIServerImpl my service name is " 
        //         + Config.getRMIServiceName(_core.getMyNodeId()));

      Naming.rebind(Config.getRMIServiceName(_core.getMyNodeId()), this);
      started = true;
    } catch (Exception e){
      e.printStackTrace();
      //
      // The worlds most useful error message:
      //
      System.err.println("*****************\n"
                         + "RMIServerImpl:start -- did you "
                         + "remember to run \'rmiregistry &\'?"
                         + "\nDid you remember to remake rmic "
                         + " after any changes?\n"
                         + "*****************");
      System.exit(-1);
    }
    //    Env.printDebug("RMIServer is now ready !");
  }

/*
  //
  // The RMIServer interface accessible via RMI
  //
  public void subscribe(SubscriptionSet ss, VV startVV, VV endVV, 
                        NodeId nodeId, String nodeDNS, 
                        int portInval, long subDurationMS, 
                        long maxForceMS, long maxDelayMS)
    throws java.rmi.RemoteException {
	
    if(dbgVerbose) System.err.println("subscribe: \t" +
                                      startVV.toString() + "\t" +
                                      nodeId.toString()  + "\t" +
                                      nodeDNS + "\t" +
                                      portInval + "\t" +
                                      subDurationMS + "\t" +
                                      maxForceMS + "\t" + maxDelayMS);
    SubscribeInvalWorker t = new SubscribeInvalWorker(_core, controller, 
                                                      ss, 
                                                      startVV, endVV,
                                                      nodeId, nodeDNS,
                                                      portInval, 
                                                      subDurationMS,
                                                      maxForceMS,
                                                      maxDelayMS);
    t.start();
  }

*/
 /** 
 *  ****** callback ********* start 
 **/ 
 /** 
 *  subscribeInval()  -- 
 *       add a subscriptionset into a connection 
 *       if the connection does not exist, create a new connection. 
 *  
 *  issues:  
 *  1. "excludedChildren" 
 *  Do we need "excludeChildren" in this interface? 
 *  We merge the shipCheckpoint interface with the inval subscription. 
 *  In the shipCheckpoint we have the excluded children? Do we still need 
 *  it here? 
 *  
 *  as discussed with Amol, no, we don't need the excldChildren. We 
 *  need to change the shipCheckpoint code a little different. We need 
 *  to send any PTreeNode that is overlapped by the subscriptionset 
 *  and with the associated "other".lpvv = min ("other".lpvv, children that's not 
 *  included by the subscriptionset. 
 *  ==> need to think about the liveness: i.e. if a PTreeNode which is only partial overlapping 
 *      with any other nodes' PTreeNode, will it be precise eventually? 
 *  
 *  2. "duration" 
 *  as we now only have one connection, duration might not be necessary as  
 *  we have remove command, maybe the runtime should implement the duration 
 *  if needed by using the remove interface. 
 *  
 *  3. "maxForceMS", "maxDelayMS" 
 *  we only need one set of "maxForceMS", "maxDelayMS" as we now only have one stream 
 *  how to deal with multiple inputs with multiple subscription? 
 *   
 *  For simplicity, I just assume we only have one "maxForceMS", "maxDelayMS" for 
 *  one connection which is defined by default in the configure file. And there's no 
 *  duration constraint any more. 
 *  Note: "maxDelayMS" works naturally in the new protocol and make the prevVV advance 
 *        graduately even if there's no new interested precise invalidation. 
 *  
 *  4. "endVV" 
 *  I also errase the "endVV" argument because we have remove method, if the controller 
 *  knows when to stop the subscription, it should also be able to issue the remove  
 *  command later. 
 **/ 
  public AcceptVV subscribeInval(NodeId subscriberNodeId, 
                             String subscriberNodeDNS, 
                             int subscriberPortInval, 
                             SubscriptionSet ss,                     
                             AcceptVV startVV,
			     boolean catchupWithCP,
			     boolean cpWithBody/*, 
			     boolean includeAll*/)
    throws java.rmi.RemoteException{

    AcceptVV returnVV = null;
    if(testRawRMIPerformance){
      return returnVV;
    }
    long start, end, totalTime;
    if(dbgPerformance){
      start = System.currentTimeMillis();
      Env.dprintln(dbgPerformance, " start@ "+ start + " ---rmiServer::subscribeInval("
		   + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString() 
		   + "startvv=" + startVV.toString());
    }

    if(dbgInvalSub){
      Env.dprintln(dbgInvalSub, "RMIServerImpl:: SubscribeInval "
                   + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString() 
		   + "startvv=" + startVV.toString());
    }
    if(useNewIterator){
      returnVV = icp.addToConnection(subscriberNodeId, subscriberNodeDNS, 
			subscriberPortInval, ss, startVV, cpWithBody, catchupWithCP/*, includeAll*/);
    }else{
      ocp.addToConnection(subscriberNodeId, subscriberNodeDNS, 
			  subscriberPortInval, ss, startVV, cpWithBody, catchupWithCP);
    }
    if(doStats){
      Stats.countBytes("RMIServer:subscribeInval", subscriberNodeId);
      Stats.countBytes("RMIServer:subscribeInval", subscriberNodeDNS);
      Stats.countBytes("RMIServer:subscribeInval", new Integer(subscriberPortInval));
      Stats.countBytes("RMIServer:subscribeInval", ss);
      Stats.countBytes("RMIServer:subscribeInval", startVV);
    }

    if(dbgPerformance){
      end = System.currentTimeMillis();
      totalTime = (end-start);
      Env.dprintln(dbgPerformance, " @@@@@@@ "+ totalTime + " ---rmiServer::subscribeInval("
		   + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString());
    }
    return returnVV;
  }

 /** 
 *  Optimize common case to get RMI cost down -- a nodeID at the configured 
 *  address, a 1-element subscriptionset, and startVV = start of time 
 *  except exclude everything from node. 
 **/ 
  public void subscribeInval(long nodeId, 
			     String subscriptionSetString, 
			     boolean catchupWithCP,
			     boolean cpWithBody)
    throws java.rmi.RemoteException{
    if(testRawRMIPerformance){
      return;
    }
    long start, end, totalTime;
    if(dbgPerformance){
      start = System.currentTimeMillis();
      Env.dprintln(dbgPerformance, " start@ "+ start + " ---rmiServer::subscribeInval("
		   + " receiverId="+ nodeId + "SS= "+ subscriptionSetString);
    }
    NodeId nid = new NodeId(nodeId);
    if(SangminConfig.forkjoin){
      nid = new BranchID(nid.getIDint());
    }
    
    String dns = Config.getDNS(nid);
    int portInval = Config.getPortInval(nid);
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet(subscriptionSetString);
    AcceptStamp asa[] = new AcceptStamp[1];
    asa[0] = new AcceptStamp(RMIClient.ACCEPT_STAMP_TO_FILTER_MY_OWN_UPDATES, 
                             nid);
    AcceptVV startVV = new AcceptVV(asa);
    if(useNewIterator){
      icp.addToConnection(nid, dns, portInval, ss, startVV, cpWithBody, catchupWithCP, false);
    }else{
      ocp.addToConnection(nid, dns, portInval, ss, startVV, cpWithBody, catchupWithCP);
    }    
    if(doStats){
      Stats.countBytes("RMIServer:subscribeInvalQuick", new Long(nodeId));
      Stats.countBytes("RMIServer:subscribeInvalQuick", subscriptionSetString);
    }
    
    if(dbgPerformance){
      end = System.currentTimeMillis();
      totalTime = (end-start);
      Env.dprintln(dbgPerformance, " @@@@@@@ "+ totalTime + " ---rmiServer::subscribeInval("
		   + " receiverId="+ nodeId + "SS= "+ subscriptionSetString);
    }
  }


 /** 
 *  removeSubscribInval -- 
 *     Remove subscriptionset from a connection at the sender side 
 *  
 *  Note: the sender will send imprecise invalidation in the following stream which 
 *        will automatically kick out the subscription set at the receiver side. 
 *        E.g. for removing, we only need to invoke it at the sender side 
 *  
 *  it might be called because the receiver finds that the connection kicked off anyone 
 *  at the receiver side. 
 **/ 
  public void 
  removeSubscribeInval(NodeId subscriberNodeId,
                       String subscriberNodeDNS, 
                       int subscriberPortInval,
                       SubscriptionSet ss)
    throws java.rmi.RemoteException{
    if(testRawRMIPerformance){
      return;
    }

    if(dbgInvalSub){
      Env.dprintln(dbgInvalSub, "RMIServerImpl:: removeSubscribeInval "
                   + " receiverId="+ subscriberNodeId.toString() + "SS= "+ ss.toString());
    }
    if(useNewIterator){
      icp.removeFromConnection(subscriberNodeId, subscriberNodeDNS, subscriberPortInval, ss);
    }else{
      ocp.removeFromConnection(subscriberNodeId, subscriberNodeDNS, subscriberPortInval, ss);
    }
    if(doStats){
      Stats.countBytes("RMIServer:removeSubscribeInval", subscriberNodeId);
      Stats.countBytes("RMIServer:removeSubscribeInval", subscriberNodeDNS);
      Stats.countBytes("RMIServer:removeSubscribeInval", new Integer(subscriberPortInval));
      Stats.countBytes("RMIServer:removeSubscribeInval", ss);
    }
  }

 /** 
 *  removeConnection -- 
 *     Remove a connection at the sender side 
 *   
 *   
 *  it might be called because the receiver finds that the connection kicked off anyone 
 *  at the receiver side. or the recovery has finished 
 **/ 
  public void 
  removeConnection(NodeId subscriberNodeId,
                   String subscriberNodeDNS, 
                   int subscriberPortInval)
    throws java.rmi.RemoteException{
    if(testRawRMIPerformance){
      return;
    }
    if(useNewIterator){
      icp.removeConnection(subscriberNodeId, subscriberNodeDNS, subscriberPortInval);
    }else{
      ocp.removeConnection(subscriberNodeId, subscriberNodeDNS, subscriberPortInval);
    }
    if(doStats){
      Stats.countBytes("RMIServer:removeConnection", subscriberNodeId);
      Stats.countBytes("RMIServer:removeConnection", subscriberNodeDNS);
      Stats.countBytes("RMIServer:removeConnection", new Integer(subscriberPortInval));
    }
  }


 /** 
 *  ****** callback ********* end 
 **/ 

 /** 
 *  subscribeBody  
 *    - adds subscription set inot a body connection 
 *    - if the connection does not exist, creats a new connection 
 *    - note: startVV is ignored by underlying layer 
 **/ 

  public void
  subscribeBody(NodeId subscriberNodeId, 
		String subscriberNodeDNS, 
		int subscriberPortBody, 
		SubscriptionSet ss,
		AcceptVV startVV)
    throws java.rmi.RemoteException{
    if(testRawRMIPerformance){
      return;
    }
    bcp.addToConnection(subscriberNodeId, subscriberNodeDNS,
			subscriberPortBody, ss, startVV);
    if(doStats){
      Stats.countBytes("RMIServer:subscribeBody", subscriberNodeId);
      Stats.countBytes("RMIServer:subscribeBody", subscriberNodeDNS);
      Stats.countBytes("RMIServer:subscribeBody", new Integer(subscriberPortBody));
      Stats.countBytes("RMIServer:subscribeBody", ss);
      Stats.countBytes("RMIServer:subscribeBody", startVV);
    }
  } 
 /** 
 *   Old interface - retained so that it doesn't break previous tests 
 **/ 

  public void subscribeBody(SubscriptionSet ss, VV startVV, 
                            NodeId nodeId, String nodeDNS, int portBody,
                            long subscriptionDurationMS)
  throws java.rmi.RemoteException{
    if(testRawRMIPerformance){
      return;
    }
    bcp.addToConnection(nodeId, nodeDNS, portBody, ss, startVV);
    if(doStats){
      Stats.countBytes("RMIServer:subscribeBody", ss);
      Stats.countBytes("RMIServer:subscribeBody", startVV);
      Stats.countBytes("RMIServer:subscribeBody", nodeId);
      Stats.countBytes("RMIServer:subscribeBody", nodeDNS);
      Stats.countBytes("RMIServer:subscribeBody", new Integer(portBody));
      Stats.countBytes("RMIServer:subscribeBody", new Long(subscriptionDurationMS));
    }
  }



 /** 
 *  removeSubscribeBody -- 
 *     Remove subscriptionset from a connection at the sender side 
 *   
 *     TODO: need to send a special message to inform receiver that the SS has 
 *     been removed from the connection. 
 *  
 **/ 
  public  void 
  removeSubscribeBody(NodeId subscriberNodeId,
		      String subscriberNodeDNS, 
		      int subscriberPortBody,
		      SubscriptionSet ss)
  throws java.rmi.RemoteException {
    if(testRawRMIPerformance){
      return;
    }
    bcp.removeFromConnection(subscriberNodeId, subscriberNodeDNS, 
			     subscriberPortBody, ss);
    if(doStats){
      Stats.countBytes("RMIServer:removeSubscribeBody", subscriberNodeId);
      Stats.countBytes("RMIServer:removeSubscribeBody", subscriberNodeDNS);
      Stats.countBytes("RMIServer:removeSubscribeBody", new Integer(subscriberPortBody));
      Stats.countBytes("RMIServer:removeSubscribeBody", ss);
    }

  }

 /** 
 *  removeBodyConnection -- 
 *     Remove a body connection at the sender side 
 *   
 *  Note: if the ss for a connection is empty, the connection is *NOT* 
 *  automatically removed.  Controller needs to explicity drop the connection. 
 **/ 

  public void 
  removBodyConnection(NodeId subscriberNodeId,
                   String subscriberNodeDNS, 
                   int subscriberPortBody)
    throws java.rmi.RemoteException{
    if(testRawRMIPerformance){
      return;
    }
    bcp.removeConnection(subscriberNodeId, subscriberNodeDNS, subscriberPortBody);
    if(doStats){
      Stats.countBytes("RMIServer:removeBodyConnection", subscriberNodeId);
      Stats.countBytes("RMIServer:removeBodyConnection", subscriberNodeDNS);
      Stats.countBytes("RMIServer:removeBodyConnection", new Integer(subscriberPortBody));
    }
  }
 
  
 /** 
 *  shutdown any sender workers 
 **/ 
  public void 
  close(){
    if(ocp != null){
      ocp.shutdownAll();
    }
    if(icp != null){
      icp.shutdownAll();
    }
    bcp.shutdownAll();  
  }


 /** 
 *  send the bodyMsg that includes "offset" and is at least as new as "as" to the receiver 
 *  
 *  return the number of bytes in the bodyMsg if success 
 *         0 if the bodyMsg is older than "as" 
 **/ 
  public int 
  issueDemandRead(ObjId id, long offset, long length, long requestId,
                  NodeId nodeId, String nodeDNS, int portDemand, AcceptStamp as)
    throws java.rmi.RemoteException, ObjNotFoundException, 
	   UnableToConnectException, IOException, ReadOfInvalidRangeException, EOFException, 
	   ReadOfHoleException {
    if(testRawRMIPerformance){
      return -1;
    }
    if ( dbgDemandReadFailure )
      {
	Env.dprintln(dbgDemandReadFailure, "issueDemandRead is called: id=" + id 
				+ "offset="+offset + "length=" +length + "receiver="+nodeId + "as="+as);
      } 
    if(doStats){
      Stats.countBytes("RMIServer:issueDemandRead", id);
      Stats.countBytes("RMIServer:issueDemandRead", new Long(offset));
      Stats.countBytes("RMIServer:issueDemandRead", new Long(length));
      Stats.countBytes("RMIServer:issueDemandRead", new Long(requestId));
      Stats.countBytes("RMIServer:issueDemandRead", nodeId);
      Stats.countBytes("RMIServer:issueDemandRead", nodeDNS);
      Stats.countBytes("RMIServer:issueDemandRead", new Integer(portDemand));
      Stats.countBytes("RMIServer:issueDemandRead", as);
    }

   BodyMsg bodyMsg = null;
   try{ 
    //System.err.println("RMISERVERIMPL:Receive call for demand read from " + nodeId + " for object" + id);
    //read exactOffset parameter should be "false" because we want to send the 
    //receiver the whole data corresponding to the invalidate instead of just 
    //the required subset of the data starting from the offset.
     
     bodyMsg = _core.read(id, offset, length, false, false, false, 0);
    if (as.gt(bodyMsg.getAcceptStamp())){
      if ( dbgDemandReadFailure )
	{
	  Env.dprintln(dbgDemandReadFailure, " bodyMsg: " + bodyMsg + " is older than as:" + as);
	}
      return 0;
    }
    
    bodyMsg.setIsDemand(true);
    bodyMsg.setRequestId(requestId);
    if( dbgDemandReadFailure )
      Env.dprintln(dbgDemandReadFailure, "issueDemandRead success: id=" + id 
		 + "offset="+offset + "length=" +length + "receiver="+nodeId + "as="+as
		 + "bodyMsg=" + bodyMsg);
    
    try{
	demandStreams.send(nodeDNS, portDemand, bodyMsg);
	_core.cancelPrefetchRequest(id, offset, length, nodeId);
	//System.err.println("RMISERVERIMPL:Done sending to  " + nodeId + " for object" + id);
    } 
    catch (UnableToConnectException utce){
	Env.printStackTrace(utce);
	throw utce;
    }
  }
    catch (ObjNotFoundException ofe){
      Env.printStackTrace(ofe);
      throw ofe;
    } catch (ReadOfInvalidRangeException roire){
      Env.printStackTrace(roire);
      throw roire;
    } catch (ReadOfHoleException rohe){
	Env.printStackTrace(rohe);
        throw rohe;
    } catch(EOFException eofe){
        Env.printStackTrace(eofe);
	throw eofe;
    } 
    return bodyMsg.getBody().getLength();
    
  }
  
    
  public void requestSync(NodeId nodeId, AcceptStamp acceptStamp)
    throws java.rmi.RemoteException{
    if(testRawRMIPerformance || turnOffSyncRequest){
      return;
    }
    //
    // It is really tempting to have just one thread
    // and one queue for pending syncs, but that seems
    // fragile -- (a) a buggy node that sends us a high
    // timestamp could starve the other nodes (b) 
    // we are not guaranteed that acceptStamps are
    // similar at different nodes, so again we could
    // have starvation. So, one queue and one thread
    // per node. Sigh. Shouldn't be too many of them
    // in any event.
    //
    
    assert(syncRequestBuffers != null);
    SyncRequestQ q = syncRequestBuffers.get(nodeId);
    q.enqueue(new SyncRequestForAS(nodeId, acceptStamp));
    if(doStats){
      Stats.countBytes("RMIServer:requestSync", nodeId);
      Stats.countBytes("RMIServer:requestSync", acceptStamp);
    }
    
    //System.out.println("sync called in rmiclient.");
    return;
  }

  public void requestSync(NodeId nodeId, AcceptVV acceptVV)
    throws java.rmi.RemoteException{
    //
    // It is really tempting to have just one thread
    // and one queue for pending syncs, but that seems
    // fragile -- (a) a buggy node that sends us a high
    // timestamp could starve the other nodes (b) 
    // we are not guaranteed that acceptStamps are
    // similar at different nodes, so again we could
    // have starvation. So, one queue and one thread
    // per node. Sigh. Shouldn't be too many of them
    // in any event.
    //
    assert(syncRequestBuffers != null);
    SyncRequestQ q = syncRequestBuffers.get(nodeId);
    q.enqueue(new SyncRequestForVV(nodeId, acceptVV));
    if(doStats){
      Stats.countBytes("RMIServer:requestSync", nodeId);
      Stats.countBytes("RMIServer:requestSync", acceptVV);
    }
  }

  public VV getCurrentVV()
    throws java.rmi.RemoteException{
    if(testRawRMIPerformance){
      return null;
    }
    if(doStats){
      Stats.countBytes("RMIServer::getCurrentVV", _core.getCurrentVV());
    }
    return _core.getCurrentVV();
  }
  
  public Hashtable getStats() throws RemoteException{
    if(doStats){
      Stats.countBytes("RMIServer::getStats", Stats.getStats());
    }
    return Stats.getStats();
  }
}

//---------------------------------------------------------------------------
/* $Log: RMIServerImpl.java,v $
/* Revision 1.69  2007/11/05 23:32:42  zjiandan
/* fix SubscribeBWunit.
/*
/* Revision 1.68  2007/10/07 04:47:04  zjiandan
/*  coda cooperative caching exp
/*
/* Revision 1.67  2007/10/06 05:29:53  zjiandan
/* Add Coda java hack version.
/*
/* Revision 1.66  2007/09/12 19:08:38  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.65  2007/06/04 21:40:59  zjiandan
/* expose stream catchup type CP|LOG option to rmiClient.subscribeInval().
/*
/* Revision 1.64  2007/05/30 20:30:19  dahlin
/* Added checkpoint to SubscribeBWUnit. Changed outgoingconnection checkpoint send to not send body by default. Told barrier to close sockets when done with them.
/*
/* Revision 1.63  2007/04/02 21:11:39  zjiandan
/* snapshort for sosp2007.
/*
/* Revision 1.62  2007/03/17 02:42:03  nalini
/* disabled stats
/*
/* Revision 1.61  2007/03/16 07:10:18  zjiandan
/* fixed OutgoingConnection unittest.
/*
/* Revision 1.60  2007/03/15 21:58:31  dahlin
/* Added experimetn to test BW for subscribe for SOSP paper
/*
/* Revision 1.59  2007/03/11 04:16:54  zjiandan
/* Add timeout into read interface and expose acceptstamp in LocalInterface.write.
/*
/* Revision 1.58  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.56  2007/03/06 18:25:51  zjiandan
/* Add optimization for CatchupInvalIterator, fixed SubscriptionSet, HierInvalTarget
/* and P2Runtime problems. Add aways split when receiving subtree ISStatus in Checkpoint.
/*
/* Revision 1.55  2007/02/27 04:44:41  zjiandan
/* change readOfHole interface such that read of hole will throw an
/* ReadOfHoleException with the position of the next written byte.
/*
/* Revision 1.54  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.53  2007/01/05 01:18:41  nalini
/* support for sync with VV added
/*
/* Revision 1.52  2006/12/08 21:36:26  nalini
/* reverting to the old read interface
/*
/* Revision 1.50  2006/09/12 22:18:05  dahlin
/* Working to get the unit tests to all run. Up to RandomAccessState now go through. Note that to encourage people to run RASUnit, I have changed the parameters to --quick-- versions that are less extensive tests.
/*
/* Revision 1.49  2006/09/01 21:32:24  dahlin
/* PicSharReader test now works for case when writer dies and restarts
/*
/* Revision 1.48  2006/08/16 21:26:18  dahlin
/* PicShareUnit test works on linux, too!
/*
/* Revision 1.47  2006/06/14 22:50:09  nalini
/* Changed nice sockets to normal sockets for outgoing body connections
/*
/* Revision 1.46  2006/06/13 03:49:19  nalini
/* RMI for P2 Runtime Implemented
/*
/* Revision 1.45  2006/06/02 22:40:02  nalini
/* merged support for adding and removing ss for outgoing body streams
/*
/* Revision 1.44.2.1  2006/06/02 22:18:13  nalini
/* Supports addition and removeal of SS from Outgoing Body Streams
/*
/* Revision 1.44  2006/04/22 07:59:53  nalini
/* Working Version of P2 Runtime: Works with JD's interfaces
/*
/* Revision 1.43  2006/04/21 07:19:27  zjiandan
/* add close method for shutdown system.
/*
/* Revision 1.42  2006/04/21 02:57:33  nalini
/* Merging Nalini's P2 code and JD's callback code
/*
/* Revision 1.41  2006/04/20 03:52:53  zjiandan
/* Callbacks merged with runTime.
/*
/* Revision 1.40  2005/10/16 04:20:12  zjiandan
/* add "boolean withBody" parameter for Checkpoint exchange.
/*
/* Revision 1.39  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.38  2005/03/22 23:00:03  zjiandan
/* Changes for TactExpt.
/*
/* Revision 1.37  2005/03/22 06:08:28  nayate
/* Changed code to remove demand-fetched object from the priority queue
/*
/* Revision 1.36  2005/03/21 05:22:02  nayate
/* Turned off some debugging output
/*
/* Revision 1.35  2005/03/11 16:49:10  ypraveen
/* Was not compiling due to a missing semi-colon; fixed it
/*
/* Revision 1.34  2005/03/10 20:49:49  lgao
/* *** empty log message ***
/*
/* Revision 1.33  2005/03/03 08:07:55  nayate
/* Added some checkpoint transfer code
/*
/* Revision 1.32  2005/03/01 04:42:40  nayate
/* Modifications due to new code
/*
/* Revision 1.31  2005/02/28 20:25:59  zjiandan
/* Added Garbage Collection code and part of Checkpoint exchange protocol code
/*
/* Revision 1.30  2005/01/13 20:55:40  zjiandan
/* Reorganized sosp experiments files into sosp subdirectory under experiments.
/*
/* Revision 1.29  2005/01/10 03:47:47  zjiandan
/* Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments.
/*
/* Revision 1.28  2004/11/02 22:12:55  zjiandan
/* change bind to rebind for recovery test.
/*
/* Revision 1.27  2004/10/22 20:46:55  dahlin
/* Replaced TentativeState with RandomAccessState in DataStore; got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT (1) get compile-time error in rmic and (2) ./runSDIMSControllerTest fails [related to (1)?]
/*
/* Revision 1.26  2004/10/13 17:41:36  zjiandan
/* Initial implementation of PersistentLog tested with DataStore stubs.
/*
/* TBD: test recovery with integrated DataStore and RandomAccessState.
/*
/* Revision 1.25  2004/07/28 20:18:26  dahlin
/* encapsulated byte[] bodies in ImmutableBytes for safety
/*
/* Revision 1.24  2004/07/07 21:16:00  nayate
/* Minor change to debugging output
/*
/* Revision 1.23  2004/05/26 12:28:11  arun
/* sdims debugging
/*
/* Revision 1.22  2004/05/21 13:37:20  nayate
/* Minor changes (removed some debugging information)
/*
/* Revision 1.21  2004/05/21 13:11:38  nayate
/* Fixed applyWrite bug
/*
/* Revision 1.20  2004/05/20 22:52:05  nayate
/* Minor changes
/*
/* Revision 1.19  2004/05/20 19:26:48  nayate
/* Fixed bug that failed to initialize syncRequestBuffers
/*
/* Revision 1.18  2004/05/20 04:10:57  dahlin
/* Passes SDIMSController spanning tree self test
/*
/* Revision 1.17  2004/05/20 01:54:43  nayate
/* Replaced "System.out.println" with "Env.printDebug"
/*
/* Revision 1.16  2004/05/20 01:06:11  arun
/* added some code for recovery support in store. Added maxVV definition in COunterVV etc.
/*
/* Revision 1.15  2004/05/20 00:47:34  dahlin
/* Fixed several bugs to make inval log exchange work (biggest one: ISIterator handling case when an single-writer log exists but has no records in it; also added some debugging tools
/*
/* Revision 1.14  2004/05/19 04:34:55  dahlin
/* SDIMSController test compiles and runs but deadlocks
/*
/* Revision 1.13  2004/05/19 03:09:01  dahlin
/* Fixed default constructor for URANode
/*
/* Revision 1.12  2004/05/19 02:25:44  dahlin
/* Testing fix
/*
/* Revision 1.11  2004/05/18 08:52:12  nayate
/* Changed "System.out.println" to "Env.debugPrintln" and turned off the debug
/* flag
/*
/* Revision 1.10  2004/05/15 00:23:17  lgao
/* Add flag to distingurish demand fetch from prefetch data.
/*
/* Revision 1.9  2004/05/14 21:20:00  dahlin
/* Retry logic for upward path on body push spanning tree
/*
/* Revision 1.8  2004/05/14 20:49:00  dahlin
/* SDIMSController logic for Body connections (incoming)
/*
/* Revision 1.7  2004/05/14 19:23:21  dahlin
/* Cleanup spanning tree logic; add update bodies
/*
/* Revision 1.6  2004/05/14 00:12:43  zjiandan
/* Changes for second experiments.
/*
/* Revision 1.5  2004/05/12 20:44:24  lgao
/* Add rmi interface for distributed stats collection at the coordinator.
/*
/* Revision 1.4  2004/04/30 19:24:42  nayate
/* Removed some unnecessary checks
/*
/* Revision 1.3  2004/04/19 23:30:05  lgao
/* Initial implementation of the RMI package and modification to Makefile.
/*
/* Revision 1.2  2004/04/15 20:04:25  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
//---------------------------------------------------------------------------
