package code;
import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.server.*;

 /** 
 *  
 *  To enable timeouts of RMI calls, replace the default socket factory 
 *  with this new one that provides timeouts by calling 
 *  
 *   RMISocketFactory.setSocketFactory(new RMITimeoutSocketFactory(timeoutMS)); 
 *   
 *  before making any RMI calls. 
 *  
 *  This class's code draws heavily from code posted by Stu Halloway at 
 *  https: 
 *   
 **/ 

public class RMITimeoutSocketFactory extends RMISocketFactory 
{

    private int timeoutMS;

    public 
	RMITimeoutSocketFactory(int timeoutMS_) 
    {
	this.timeoutMS = timeoutMS_;
    }


    public Socket 
	createSocket(String host, int port) 
	throws IOException 
    {
	Socket ret = getDefaultSocketFactory().createSocket(host, port);
	ret.setTcpNoDelay(true);
	ret.setSoTimeout(timeoutMS);
	return ret;
    }


    public ServerSocket 
	createServerSocket(int port) throws IOException 
    {
	return getDefaultSocketFactory().createServerSocket(port);
    }

}

//---------------------------------------------------------------------------
/* $Log: RMITimeoutSocketFactory.java,v $
/* Revision 1.2  2004/05/11 17:22:04  nayate
/* (1) Added "setTcpNoDelay(true)" calls at socket creation
/* (2) Changed "ObjectOutputStream" to "TaggedOutputStream" where appropriate
/*
/* Revision 1.1  2004/05/08 22:20:17  dahlin
/* Partially complete version of SDIMSController (it should compile w/o error, though)
/*
 */
//---------------------------------------------------------------------------
