package code;

import junit.textui.TestRunner;
import code.utils.junit.*;

import com.sleepycat.je.*;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;

import java.io.File;
import java.io.IOException;
import java.io.EOFException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.IllegalArgumentException;
import java.util.Random;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Iterator;

public class RandomAccessStateUnitMT extends MultiThreadedTestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  private String path;
  private boolean verbose;
  private boolean vverbose;
  private RandomAccessState ras;
  private static final boolean quick = true;


  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public RandomAccessStateUnitMT(String s){
    super(s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();

    path = RandomAccessStateUnit.path;
    verbose = RandomAccessStateUnit.verbose;
    vverbose = RandomAccessStateUnit.vverbose;

    if(verbose){
      System.out.println("RandomAccessStateUnitMT test...");
    }
    RandomAccessStateUnit.selfTestCleanup(path); // Start from known state
    ras = new RandomAccessState(path, 30000000);
    //ras.overrideDoExpensiveSanityChecks(true);

  }

  protected void tearDown() throws Exception{
    ras.close();
    RandomAccessStateUnit.selfTestCleanup(path);
    super.tearDown();
  }


  /* 
   * TBD: Insert functions called testX for some X
   * TBD: Create instance of class to be tested and
   *      pass to worker threads
   */
  public void testX16(){
    int nThreads = 16;
    int nPasses = 100;
    if(quick){
      nThreads = 4;
      nPasses = 10;
    }
    int ii;
    Hashtable t = new Hashtable();
    if(verbose){
      System.out.print("Test16...");
    }

    assert(t.size() == 0);
    TestCaseRunnable tcr[] = new TestCaseRunnable[nThreads];
    for(ii = 0; ii < nThreads; ii++){
      tcr[ii] = new Test16Worker(ras, t, nPasses);
    }

    /*
     * Runs all of the worker threads and waits
     * for them to finish.
     */
    runTestCaseRunnables(tcr);
    
    //
    // Double check no duplicates entered.
    // Each thread should create exactly 1 new id per pass.
    //
    assert(t.size() == nThreads * nPasses);

    if(verbose){
      System.out.println("...Test16 SUCCEEDS.");
    }
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containin every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static junit.framework.Test suite(){
    junit.framework.TestSuite suite 
      = new junit.framework.TestSuite(RandomAccessStateUnitMT.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "TestEmpty";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }



 /** 
 **/ 
 /** 
 * 
 
 *  class Test16Worker 
 
 * 
 
 **/ 
 /** 
 **/ 
  class Test16Worker extends TestCaseRunnable{
  
    RandomAccessState ras;
    Hashtable t; // Note that Java's Hashtable is synchronized
    int nPasses;

    public 
    Test16Worker(RandomAccessState ras, Hashtable t, int nPasses){
      this.ras = ras;
      this.t = t;
      this.nPasses = nPasses;
    }

    public void runTestCase(){
      int maxRetry = 10000;
      int retryCount;
      long fnum;
      int ii;
      Long fnumL;
      for(ii = 0; ii < nPasses; ii++){
        if(Thread.currentThread().isInterrupted()){
          return;
        }
        retryCount = 0;
        fnum = ras.SENTINAL_SMALL_FILE_NUM; // impossible for makeNewFnum to return this
        while(fnum == ras.SENTINAL_SMALL_FILE_NUM && retryCount < maxRetry){
          try{
            fnum = ras.dbgMakeNewFNum();
          }
          catch(DatabaseException e){ 
            //
            // This is almost certainly com.sleepycat.je.txn.LockTimeoutException.
            // We should check for this, but it appears that this class is private
            // to je.
            if(retryCount == maxRetry){
              fail();
            }
            retryCount++;
            continue; // retry
          }
        }
        if(fnum == ras.SENTINAL_SMALL_FILE_NUM){
          assert(retryCount == maxRetry);
          fail("TEST 16 FAILS -- retryMax reached");
        }
        fnumL = new Long(fnum);
        if(t.get(fnumL) != null){
          fail("TEST 16 FAILS -- duplicate " + fnum);
        }
        t.put(fnumL, fnumL);
        if(ii % 10 == 0){
          if(vverbose){
            System.out.print(".");
          }
        }
      }
      //System.out.println("TEST16 worker done");
    }

  }




}
