package code;
 /** 
 *  Randomly select someone to supply read misses 
 **/ 
import java.util.Random;
import java.util.Enumeration;
import java.util.HashSet;

public class RandomReadDirectory implements ReadDirectory
{
private Random random; // Used in stub version only
private int nNodes; // Used in stub version only


public RandomReadDirectory()
{
    random = new Random();
    Enumeration allNodes = Config.getKnownNodeIds();
    nNodes = 0;
    while(allNodes.hasMoreElements()){
	allNodes.nextElement();
	nNodes++;
    }
}



/*
 *------------------------------------------------------------------
 *
 * getTarget --
 *
 *          Choose someone to supply this data. Sometimes choose
 *          myNodeId just for debugging fun.
 *
 * Arguments:
 *      PendingDemandRequest -- the data being requested along
 *                              w/ info on the request (e.g.,
 *                              # retries, etc.)
 *
 * Results:
 *      Return the NodeId we should use or INVALID_NODE_ID on
 *      error or on miss.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public NodeId
getTarget(PendingDemandRequest pdr)
{
    Enumeration allNodes = Config.getKnownNodeIds();
    long index = random.nextLong() % nNodes;
    if(index < 0){
	index = index * -1;
    }
    assert(index >= 0 && index < nNodes);
    int ii = 0;
    NodeId current;
    while(allNodes.hasMoreElements()){
	current = (NodeId)allNodes.nextElement();
	if(ii == index){
	    return current;
	}
	ii++;
    }
    assert(false); // Not reached
    return null;
}

public void insert(DirectoryUpdate du)
{
    // Ignore updates to directory -- we just do random searches
    // anyhow
}

public void inval(DirectoryUpdate du)
{
    // Ignore updates to directory -- we just do random searches
    // anyhow
}



public static void 
main(String s[])
{
    System.err.print("DemandReadWorker self test...");
    test();
    System.err.println("DemandReadWorker self test SUCCEEDS");
}

static void
test()
{
    int KNOWN_N_NODES = 4;
    NodeId n = new NodeId(1);
    Config.readConfig("test/stub-demand-read-worker-test.config");
    int ii;
    HashSet seen = new HashSet();
    RandomReadDirectory dir = new RandomReadDirectory();
    assert(dir.nNodes == KNOWN_N_NODES);
    for(ii = 0; ii < 1000; ii++){
	NodeId t = dir.getTarget(null);
	seen.add(t);
    }
    assert(seen.size() == KNOWN_N_NODES);
}

}

//---------------------------------------------------------------------------
/* $Log: RandomReadDirectory.java,v $
/* Revision 1.4  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.3  2004/05/19 02:14:44  dahlin
/* Making progress on SDIMSController spanning test
/*
/* Revision 1.2  2004/05/11 00:46:56  dahlin
/* Added read-miss-directory updates to SDIMSController
/*
/* Revision 1.1  2004/05/10 23:55:42  dahlin
/* Moved SDIMS read requests into ReadDirectory class for modularity and extensibility
/*
 */
//---------------------------------------------------------------------------


