package code;
 /** 
 *  Select someone to supply read misses 
 **/ 

public interface ReadDirectory
{
/*
 *------------------------------------------------------------------
 *
 * getTarget --
 *
 *          Choose someone to supply this data. The node selected
 *          should be able to supply the first byte of the specified
 *          data. The caller should regard the result as a hint
 *          and be prepared to retry this lookup if the specified
 *          node doesn't have the data.
 *
 * Arguments:
 *      PendingDemandRequest -- the data being requested along
 *                              w/ info on the request (e.g.,
 *                              # retries, etc.)
 *
 * Results:
 *      Return the NodeId we should use or INVALID_NODE_ID on
 *      error or on miss.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public NodeId getTarget(PendingDemandRequest pdr);

public void insert(DirectoryUpdate du);
public void inval(DirectoryUpdate du);

}
//---------------------------------------------------------------------------
/* $Log: ReadDirectory.java,v $
/* Revision 1.3  2004/05/13 14:15:34  dahlin
/* Fixed ^M formatting
/*
/* Revision 1.2  2004/05/11 00:46:56  dahlin
/* Added read-miss-directory updates to SDIMSController
/*
/* Revision 1.1  2004/05/10 23:55:42  dahlin
/* Moved SDIMS read requests into ReadDirectory class for modularity and extensibility
/*
 */
//---------------------------------------------------------------------------
