package code;

 /** 
 *  ReadOfHoleException : Thrown when a read trying to read a hole in the file 
 **/ 
public class ReadOfHoleException extends Exception
{
  private String errStr;
  private long nextValidBytePosition;
 /** 
 *  Constructor 
 **/ 
  public ReadOfHoleException(String errorString, long next)
  {
    this.errStr = errorString;
    this.nextValidBytePosition = next;
  }
  
 /** 
 *  Constructor 
 **/ 
  public ReadOfHoleException(long next)
  {
    this.errStr = "read of Hole!";
    this.nextValidBytePosition = next;
  }
  
 /** 
 *  return nextValidBytePosition 
 **/ 
  public long getNextValidBytePosition()
  {
    return this.nextValidBytePosition;
  }
  
 /** 
 *  Convert this exception to a string 
 **/ 
  public String toString()
  {
    return(this.errStr + " next available data is at: " 
	   + this.nextValidBytePosition);
  }
  
  
}

//---------------------------------------------------------------------------
/* $Log: ReadOfHoleException.java,v $
/* Revision 1.2  2007/02/27 04:44:41  zjiandan
/* change readOfHole interface such that read of hole will throw an
/* ReadOfHoleException with the position of the next written byte.
/*
/* Revision 1.1  2006/11/18 05:23:33  nalini
/* new read interface implemented
/*
*/
//---------------------------------------------------------------------------
