package code;
 /** 
 *  ReadOfInvalidRangeException -- thrown when a read hits a range of bytes 
 *   in the INVALID state 
 **/ 
public class ReadOfInvalidRangeException extends Exception
{
    private String errStr;
    private AcceptStamp accept; // Accept stamp of write that caused
                                // range to be invalid.

 /** 
 *  Constructor 
 **/ 
    public ReadOfInvalidRangeException(String errorString, AcceptStamp as)
    {
	this.errStr = errorString;
	this.accept = as;
    }

 /** 
 *  Constructor 
 **/ 
    public ReadOfInvalidRangeException(AcceptStamp as)
    {
	this.errStr = "";
	this.accept = as;
    }

 /** 
 *  Convert this exception to a string 
 **/ 
    public String toString()
    {
	return("ReadOfInvalidRangeException:" + this.errStr
	       + " [invalidated by " + accept.toString() + "]");
    }

 /** 
 *  Return the invalidation that caused this range to 
 *  be invalid. 
 **/ 
    public AcceptStamp getAcceptStamp()
    {
	return (AcceptStamp)accept.clone(); // AcceptStamp is immutable -- just returns a ref
    }
}

//---------------------------------------------------------------------------
/* $Log: ReadOfInvalidRangeException.java,v $
/* Revision 1.2  2006/08/15 21:46:24  dahlin
/* Added PicShare Reader and a simple unit test.
/*
/* Revision 1.1  2004/08/18 22:46:00  dahlin
/* ReadOfInvalidRangeException needed by RandomAccessState
/* 
*/
//---------------------------------------------------------------------------
