package code;

/** 
 * Block reads during log roll-back. (We should not issue any local 
 * reads, but we may receive remote requests.) 

 * This blocking is done using a helper class to avoid adding 
 * serialization/locking to Core (see comment on synchronization 
 * model at start of this file.) 

 * We also provide a method to return current status -- whereas 
 * read requests wait until recovery complete, we want requests 
 * that we *know* to have been locally initiated from  
 * LocalInterface to die (so that we don't forget to run 
 * recovery on core right after constructor...) 
 **/ 
public class RecoveryStatus{
  protected boolean recoveryComplete;

  public RecoveryStatus(){
    recoveryComplete = false;
  }

 /** 
 *  Used for reads -- reads may be remote, so they may arrive during recovery 
 **/ 
  public synchronized void waitRecovery(){
    while(!recoveryComplete){
      try{
        wait();
      }
      catch(InterruptedException ie){
      }
    }
  }

  public synchronized void recoveryDone(){
    recoveryComplete = true;
    notifyAll();
  }

 /** 
 *  Used for writes -- assert(recoveryDone.get()) since writes must be local 
 *  events so don't issue them until recovery is done (main point -- 
 *  don't forget to run recovery after core constructor. 
 *  
 *  Note that applying invalidations is part of recovery, so we neither 
 *  wait nor assert on them... 
 **/ 
  public synchronized boolean get(){
    return recoveryComplete;
  }


}