package code;
/* 
 * ResultStats.java
 * 
 *  Used to calculate simple statistics of a set of +ve numbers numbers
 */


import java.util.*;

public class ResultStats {
  private ArrayList data = new ArrayList(); 
  private int count;   // Number of numbers that have been entered.
  private double sum;  // The sum of all the items that have been entered.
  private double squareSum;  // The sum of the squares of all the items.
  private double min = Double.MAX_VALUE; // min of all the items that have been entered 
  private double max = 0.0; // max of all the items that have been entered
  private boolean alreadyIgnored = false; // ignore the first 
  public static boolean logData = false;

  public void enter(double item){
    if(logData)Env.logWrite("TIME " + item);
    data.add(new Double(item));
    count++;
    sum += item;
    squareSum += item*item;

    if(item < min) {
      min = item;
    }
    if(item > max) {
      max = item;
    }
  }

  public ArrayList getAll(){
    return data;
  }
  
  public int getCount(int ignoreFirst){
    if(count >= ignoreFirst) {
      return  count-ignoreFirst;
    }
    return -1;
  }

  public double getSum(int ignoreFirst){
    if(count >= ignoreFirst) {
      double newSum = sum;
      for(int i=0; i< ignoreFirst; i++){
        double item = ((Double) data.get(i)).doubleValue();
        newSum = newSum - item;
      }
      return newSum;
    }
    return -1;
  }

  public double getSquareSum(int ignoreFirst){
    if(count >= ignoreFirst) {
      double newSquareSum = squareSum;
      for(int i = 0; i < ignoreFirst; i++){
        double item = ((Double) data.get(i)).doubleValue();
        newSquareSum = newSquareSum - (item*item);
      }
      return newSquareSum;
    }
    return -1;
  }

  public double getMean(int ignoreFirst){
    return getSum(ignoreFirst)/getCount(ignoreFirst);
  }

  public double getStandardDeviation(int ignoreFirst){
    double mean = getMean(ignoreFirst);
    return Math.sqrt(getSquareSum(ignoreFirst)/getCount(ignoreFirst) - mean*mean);
  }

  public double getMin(int ignoreFirst){
    if(ignoreFirst == 0) return min;

    if(count >= ignoreFirst){      
      // now to iterate thro all data to get the minimum
      double newMin = Double.MAX_VALUE;
      Iterator it = data.iterator();
      for(int ii=0; ii< ignoreFirst; ii++){
        it.next(); // ignore the first one
      }

      while(it.hasNext()){
        double item = ((Double) it.next()).doubleValue();
        if(item < newMin) {
          newMin = item;
        }
      }

      return newMin;
    }
    return -1;
  }

  public double getMax(int ignoreFirst){
    if(ignoreFirst == 0) return max;

    if(count >= ignoreFirst){
      // now to iterate thro all data to get the minimum
      double newMax = 0.0;
      Iterator it = data.iterator();
      for(int ii=0; ii < ignoreFirst; ii++){
        it.next(); // ignore the first one
      }
      while(it.hasNext()){
        double item = ((Double) it.next()).doubleValue();
        if(item > newMax) {
          newMax = item;
        }
      }
      return newMax;
    }
    return -1;
  }


  public String toString(){
    String str = "";
    if(count != 0) {
      str += "M:" + getMean(0) + 
      "\tMin:" + getMin(0) + 
      "\tMax:" + getMax(0) + 
      "\tSD:" + getStandardDeviation(0);
    } else {
      str +=  "M: -1.0" +
      "\tMin: -1.0" +
      "\tMax: -1.0" +
      "\tSD: -1.0" ;
    }
    return str;
  }

  public String getSummary(int ignoreFirst){
    String str = "";
    if(count != 0) {
      str += "M:" + getMean(ignoreFirst) + 
      "\tMin:" + getMin(ignoreFirst) + 
      "\tMax:" + getMax(ignoreFirst) + 
      "\tSD:" + getStandardDeviation(ignoreFirst);
    } else {
      str +=  "M: -1.0" +
      "\tMin: -1.0" +
      "\tMax: -1.0" +
      "\tSD: -1.0" ;
    }
    return str;
  }


  // sorts the list and ignores the max 10% of the list
  public String getAverage90(){
    List list = Collections.synchronizedList(new ArrayList(data));
    Collections.sort(list);

    int n = (int)((double)list.size() * 0.9);
    Iterator it = list.iterator();
    int nCount = 0; double nSum =0;
    for(int ii = 0; ii < n; ii++){
      nCount++;
      nSum += ((Double)it.next()).doubleValue();
    }

    double nAvg = nSum/nCount;

    return "Avg90: " + nAvg;  
  }

  public String getAllData(){
    return data.toString();
  }

}