package code;

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
import rice.pastry.PastryNode ;
import rice.pastry.NodeHandle ;
import rice.pastry.NodeName ;
import rice.pastry.AML.* ;
import rice.pastry.AML.messaging.* ;
import rice.pastry.hdht.HdhtWirePastryNodeFactory ;
import rice.pastry.standard.IPNodeIdFactory ;

import java.net.*;
import java.util.Random ;
import java.util.Vector ;
import java.util.Enumeration ;
import java.io.* ;

public class SDIMSInterface
{
    PastryNode localNode = null ;
    DHTAMLInterface intf = null ;
    AML aml = null ;
  private NodeId myNodeId = null;
    //
    // This work queue collects spanning tree triggers
    //   from continuous probes
    //
    WorkQueue spanTreeTriggerQ = null;
    // 
    // This worker thread empties the triggers from the work queue
    //    NOTE: currently just one worker. if needed, we will create
    //          a bunch later
    SDIMSSpanningTreeTriggerWorker spanTreeTriggerWorker = null ;

    int port = -1 ;// local port on which this SDIMS runs
    int bsport = -1 ;// port on which the bootstrap node runs
    String bshost = null ;  // the DNS reachable name of the bootstrap host.
    String nname = null ; // HDHT name for the local node.
    int queryNum = 0 ;

    static String readDirAttrType = "DATA_LOCATION" ;
    static String spanningDirAttrType = "SPANNING_TREE" ;

    //
    // bootstrap node id .. wait till this node is up before starting local sdims
    //
    NodeId bsNodeId = null ;

    //
    // last node id.. wait till this node is up before returning back from the makeLocalNode() routine
    //
    NodeId lastNodeId = null ;

    //
    //  port number at which a sdims node listens to let other nodes knwo when it is ready
    //
    //  UGHHH: currently it will be simply sdimsPort+1
    int coordPort = -1 ;

  public SDIMSInterface(Controller c, NodeId myNodeId_)
    {
	assert(false);
        this.myNodeId = myNodeId_;
	init() ;
    }

    public SDIMSInterface(NodeId myNodeId) {
      this.myNodeId = myNodeId;
	// when nothing is specified... read from the Config
	nname = Config.getSdimsNodeName(myNodeId) ;
	assert(nname != null) ;
	port = Config.getSdimsPort(myNodeId) ;
	assert(port != -1) ;

	Vector sortedIds = Config.getSortedKnownNodeIds() ;
	int myPos = getMyNodeIdPosition(sortedIds) ;

	if(myPos == 0) {
	    // I am the bootstrap node.. go ahead and do the work right away
	}
	else {
	    // wait till the previous node is up and use it as the bootstrap node
	    bsNodeId = getNodeIdAtPos(sortedIds, myPos-1) ;
	    assert(bsNodeId!=null) ;

	    bshost = Config.getDNS(bsNodeId) ;
	    assert(bshost != null) ;

	    bsport = Config.getSdimsPort(bsNodeId) ;
	    assert(bsport > 0) ;
	}
	lastNodeId = getNodeIdAtPos(sortedIds, sortedIds.size() - 1) ;


	init() ;
    }

  public NodeId getMyNodeId(){
    return this.myNodeId;
  }
    public NodeId getNodeIdAtPos(Vector vec, int pos) {
	assert(vec != null) ;
	assert(pos >= 0 && pos < vec.size()) ;

	return (NodeId) vec.get(pos) ;
    }

    public int getMyNodeIdPosition(Vector sortedVec) {
	for(int ii = 0 ; ii < sortedVec.size() ; ii++) {
	    NodeId nid = (NodeId) sortedVec.get(ii) ;
	    
	    if(nid.equals(myNodeId)) {
		return ii ;
	    }
	}
	assert(false) ;
	return -1 ;
    }

  public SDIMSInterface(Controller c, NodeId myNodeId_, 
			  String nname_, int port_,
			  String bshost_, int bsport_)
    {
	//assert(false);
      this.myNodeId = myNodeId_;
	nname = nname_ ;
	port = port_ ;
	bshost = bshost_ ;
	bsport = bsport_ ;
	init() ;
    }

    private void init() {
	assert(spanTreeTriggerQ == null) ;
	assert(spanTreeTriggerWorker == null) ;

	spanTreeTriggerQ = new WorkQueue("spanning tree triggers queue") ;
	spanTreeTriggerWorker = new 
	    SDIMSSpanningTreeTriggerWorker(spanTreeTriggerQ) ;
	spanTreeTriggerWorker.start() ;

	//
	// stop log messages from SDIMS package
	//
	rice.pastry.Log.init( (new String("-verbosity:0")).split(":")) ;
    }

    public WorkQueue getSpanTreeWorkQ() {
	return spanTreeTriggerQ ;
    }

    /*
     *   Creates a pastry node that bootstraps with the supplied bootstrap node or 
     *      starts a new DHT network
     *   Then creates the 
     */
    private void makeLocalSDIMS() {
	assert(nname != null) ;
	assert(port != 0) ;

	// change the IPNodeIDFactory to one based on node names.
	HdhtWirePastryNodeFactory factory = new HdhtWirePastryNodeFactory(new IPNodeIdFactory(port), port, nname);

	// check that the bsnode is completely up! by contacting on the coordPort
	if(bsNodeId != null) {
	    String bsName = Config.getDNS(bsNodeId)  ;
	    assert(bsName != null) ;
	    
	    int bsCoPort = Config.getSdimsPort(bsNodeId) + 1;
	    assert(bsCoPort > 1) ;
	    
	    Socket bsConn = null ;
	    
	    while(bsConn == null) {
		try{
		    bsConn = new Socket(bsName, bsCoPort) ;
		}
		catch(UnknownHostException e) {
		    System.out.println(e) ;
		    assert(false) ;
		}
		catch(SecurityException e) {
		    System.out.println(e) ;
		    assert(false) ;
		}
		catch(IOException e) {
		}
		if(bsConn == null) {
		    try{
			System.out.println("Could not contact "+bsName+":"+bsCoPort+"  sleeping for couple of secs");
			Thread.sleep(2000) ; // sleep for couple of secs
		    }
		    catch(Exception e) {
		    }
		}
	    }
	    
	    // nwo sure that the bootstrap node is up!.. just close the connection.. do not do anything here
	    try {
		bsConn.close() ;
	    }
	    catch(Exception e) {
	    }		
	}

	// form the inet structure for bootstrap
	InetSocketAddress addr = null;
	NodeHandle bshandle = null ;
	if( bshost != null && bsport != -1) {
	    if(bshost == null) {
		bshost = "localhost" ;
	    }
	    addr = new InetSocketAddress(bshost, bsport);
	    bshandle = factory.getNodeHandle(addr);
	    
	    while(bshandle == null) { 
		System.out.println("The bootstrap node supplied "+bshost+":"+bsport+" is not reachable. Will sleep and try again") ;
		try{
		    Thread.sleep(2000) ; // 2 sec sleep
		}
		catch(Exception e) {
		    System.out.println(e) ;
		}
		bshandle = factory.getNodeHandle(addr) ;
	    }
	}
	
	localNode = factory.newNode(bshandle); // internally initiateJoins
	assert(localNode != null) ;

	aml = new AML(localNode) ;
	intf = new DHTAMLInterface(localNode, aml) ;

	// We wait till this localPastryNode is ready
	synchronized(localNode) {
	    while (!localNode.isReady()) {
		try {
		    localNode.wait();
		} catch(InterruptedException e) {
		    System.out.println(e);
		}
	    }
	}

	// 
	//  TBD: without this sleep, SDIMS barfs in errors.. 
	//       It does not handle the case when multiple nodes start simultaneously
	//       will fix this later! - Praveen 5/22 10:21 pm
	// 
	try{
	    Thread.sleep(2000) ;
	}
	catch(Exception e) {
	}

	// now start a socketserver 
	if(lastNodeId != null && !lastNodeId.equals(this.myNodeId)) {
	    // wait for connection from the following node.
	    try {
		ServerSocket waitSocket = new ServerSocket(port+1) ;
		Socket s  = waitSocket.accept() ;
		System.out.println("got connection from "+s.getRemoteSocketAddress()) ;
		s.close() ;
	    } 
	    catch( Exception e ) {
		System.out.println( e );
		assert(false) ;
	    }
	}
	else if(lastNodeId != null) {
	    // this is the last node.. then let other nodes connect you
	    // wait for connection from the following node.
	    int count = Config.getNumNodes() - 1;
	    try {
		ServerSocket waitSocket = new ServerSocket(port+1) ;
		while(count > 0) {
		    Socket s  = waitSocket.accept() ;
		    System.out.println("got connection from "+s.getRemoteSocketAddress()) ;
		    s.close() ;
		    count -- ;
		}
	    } 
	    catch( Exception e ) {
		System.out.println( e );
		assert(false) ;
	    }
	}
	else {
	    assert(false) ;
	}

	// now try to connect to the last node
	if(lastNodeId != null && !lastNodeId.equals(this.myNodeId)) {
	    String lastNodeName = Config.getDNS(lastNodeId)  ;
	    assert(lastNodeName != null) ;
	    
	    int lastNodeCoPort = Config.getSdimsPort(lastNodeId) + 1;
	    assert(lastNodeCoPort > 1) ;
	    
	    Socket lastNodeConn = null ;
	    
	    while(lastNodeConn == null) {
		try{
		    lastNodeConn = new Socket(lastNodeName, lastNodeCoPort) ;
		}
		catch(UnknownHostException e) {
		    System.out.println(e) ;
		    assert(false) ;
		}
		catch(SecurityException e) {
		    System.out.println(e) ;
		    assert(false) ;
		}
		catch(IOException e) {
		}
		try{
		    Thread.sleep(2000) ; // sleep for couple of secs
		}
		catch(Exception e) {
		}
	    }
	    // nwo sure that the last node is up!.. just close the connection.. do not do anything here
	    try{
		lastNodeConn.close() ;
	    }
	    catch(Exception e) {
	    }		
	}

	//if (Log.ifp(5)) System.out.println("created " + pNode);
	//return pNode;
    }

    //
    //  safe to call multiple times. No side effects even if
    //  sdims is already started.
    //
    public void start() {
	getLocalNode() ;
    }

    /*
     *   This routine to be called by any worker making SDIMS calls!
     */
    public synchronized PastryNode getLocalNode() {
	if(localNode != null) return localNode ;

	// start the node
	makeLocalSDIMS();
	assert(localNode != null && aml!=null && intf != null) ;

	// We wait till this localPastryNode is ready
	synchronized(localNode) {
	    while (!localNode.isReady()) {
		try {
		    localNode.wait();
		} catch(InterruptedException e) {
		    System.out.println(e);
		}
	    }
	}


	// We wait till this localPastryNode is ready
	synchronized(localNode) {
	    while (!localNode.isReady()) {
		try {
		    localNode.wait();
		} catch(InterruptedException e) {
		    System.out.println(e);
		}
	    }
	}

	installAggrFuncs() ;

	// sleep for 10 seconds so that everyone is ready
	try{
	    Thread.sleep(10000) ; // 10 sec sleep
	}
	catch(Exception e) {
	    System.out.println(e) ;
	}
	return localNode ;
    }

    private void installAggrFuncs() {
	//AggrFunc naf = new SDIMSRDAggrFunc(readDirAttrType) ;
      AggrFunc naf = new SDIMSSDNodeNearAggrFunc(readDirAttrType, this.myNodeId) ;
	NodeHandle nh = localNode.getLocalHandle() ;
	InstallMessage imsg = new InstallMessage(intf.getAddress(), nh, naf) ;
	nh.receiveMessage(imsg) ;

	//naf = new SDIMSSDAggrFunc(spanningDirAttrType) ;
	naf = new SDIMSSDNodeNearAggrFunc(spanningDirAttrType, this.myNodeId) ;
	imsg = new InstallMessage(intf.getAddress(), nh, naf) ;
	nh.receiveMessage(imsg) ;	
    }

    public void sendUpdateMessage(String attrType, String attrName, 
				  Object value) {
	assert(localNode != null) ;
	assert(attrType!=null) ;
	assert(attrType.equals(readDirAttrType) || 
	       attrType.equals(spanningDirAttrType)) ;
	assert(attrName != null) ;
	// value can be null.. e.g., unsubscribe, file deleted, etc.,

	NodeHandle nh = localNode.getLocalHandle() ;
	UpdateMessage umsg = new UpdateMessage(intf.getAddress(), nh, attrType, attrName, value) ;
	System.out.println("UMessage: "+umsg) ;
	nh.receiveMessage(umsg) ;
    }

    // need to make this synchronized because of queryNum param! 
    public synchronized void sendProbeMessage(String attrType, String attrName, 
				 boolean continuous, 
				 boolean reaggregate,
				 ProbeCallBack pcb, long timeoutMS) {
	assert(localNode != null) ;
	assert(attrType!=null) ;
	assert(attrType.equals(readDirAttrType) || 
	       attrType.equals(spanningDirAttrType)) ;
	assert(attrName != null) ;

	NodeHandle nh = localNode.getLocalHandle() ;
	assert(false); //MDD: Next line doesn't compile any more nh.getNodeName() -- fix it!
	LocalProbeMessage pmsg = new LocalProbeMessage(intf.getAddress(), nh, 
						       attrType, attrName, 
						       "MDD: Used to be 'nh.getNodeName().toString()' but that causes compile error", 
						       queryNum++, pcb) ;
	pmsg.level = 160 ;
	pmsg.continuous = continuous ;
	if(reaggregate) {
	    pmsg.up = 160 ;
	    pmsg.down = 160 ;
	}
	System.out.println("Pmessage: "+pmsg) ;
	nh.receiveMessage(pmsg) ;
    }

    /*
     *
     *  Note on the execution ---
     *    Once DHT starts, a thread starts listening on the port for messages
     *    So control-c or a kill is needed to stop the system -- which throws exceptions.. IGNORE these.
     */
    public static void main(String[] args) {
	// for printing log messages
	rice.pastry.Log.init(args) ;

	// start couple of threads that call getLocalNode() on single SDIMSInterface object;
	//   only one instance should start
	SDIMSInterface sdims1 = new SDIMSInterface(null, new NodeId(1),
                                                   "begonia.cs", 5009, null, 0) ;
	SDIMSInterface sdims2 = new SDIMSInterface(null, new NodeId(2),
                                                   "balsam.cs", 5010, "begonia", 5009) ;

	TestWorkerThread w1 = new TestWorkerThread(sdims1, 1) ;
	TestWorkerThread w2 = new TestWorkerThread(sdims1, 2) ;

	w1.start() ;
	w2.start() ;

	// start two SDIMSinterfaces and couple of threads for each
	//   check that both nodes interact well - form DHT, etc.,
	TestWorkerThread w3 = new TestWorkerThread(sdims2, 3) ;
	w3.start() ;
    }
}

class TestProbeCallBack implements ProbeCallBack {
    // add workqueue later
    WorkQueue wq ;
    SDIMSInterface sdims ;
    int chan ;
    NodeId myId ;

    public TestProbeCallBack(SDIMSInterface sdims_, int chan_, NodeId myId_) {
	sdims = sdims_ ;
	chan = chan_ ;
	myId = myId_ ;
    }

    public void onAnswer(ProbeMessage msg, Object answer) {
	Vector entries = (Vector) answer ;
	AncestorMIBEntry amib = null;
	for(int ii = 0 ; ii < entries.size() ; ii++) {
	    amib = (AncestorMIBEntry)(entries.get(ii)) ;
	    if(amib.value != null && !((NodeId) amib.value).equals(myId)) {
		System.out.println("ContProbeRes: "+sdims.getLocalNode()+"  channel "+ chan +": got parent: "+amib.value) ;
		return ;
	    }
	}
	System.out.println("ContProbeRes: "+sdims.getLocalNode()+"  channel "+ chan +": parent is "+amib.value) ;
    }
}

class TestWorkerThread extends Thread {
    SDIMSInterface sdims ;
    int index ;
    NodeId myId ;

    public TestWorkerThread(SDIMSInterface sdims_, int num) {
	sdims = sdims_ ;
	index = num ;
	myId = new NodeId(index) ;
    }
    
    public void run() {
	Random rand = new Random(index) ;
	// call the get local handle here
	PastryNode pNode = sdims.getLocalNode() ;
	assert(pNode != null) ;
	System.out.println("Thread "+index+": Got pNode "+pNode) ;

	if(index == 2) return ;

	// put continuous probes for both channels
	sdims.sendProbeMessage(sdims.spanningDirAttrType, "CHAN1",
			       true,
			       false,
			       new TestProbeCallBack(sdims, 1, myId), 20000) ;

	sdims.sendProbeMessage(sdims.spanningDirAttrType, "CHAN2",
			       true,
			       false,
			       new TestProbeCallBack(sdims, 2, myId), 20000) ;

	//
	// for every t seconds, randomly toggle subscription to a channel
	//

	//
	// variables to maintain subscription status
	//
	boolean chanSub[] = new boolean[2] ;
	chanSub[0] = false ;
	chanSub[1] = false ;

	for(int ii = 0 ; ii < 4 ; ii++) {
	    int channel = rand.nextInt(2) + 1 ;
	    String attrName = "CHAN"+channel ;
	    if(chanSub[channel-1] == false) { // not subscribed previously
		chanSub[channel-1] = true ;
		// subscribe
		System.out.println("Thread "+index+" subscribing to channel "+attrName) ;
		sdims.sendUpdateMessage(sdims.spanningDirAttrType, attrName,
					myId) ;
	    }
	    else {
		chanSub[channel-1] = false ;
		// unsubscribe
		System.out.println("Thread "+index+" unsubscribing from channel "+attrName) ;
		sdims.sendUpdateMessage(sdims.spanningDirAttrType, attrName,
					null) ;
	    }
	    try{
		Thread.sleep(10000) ; // sleep ten secs
	    }
	    catch(Exception e) {
		System.out.println(e) ;
	    }		
	}
	System.exit(1) ;
    }
}


//---------------------------------------------------------------------------
/* $Log: SDIMSInterface.java,v $
/* Revision 1.12  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.10  2005/06/14 23:05:08  dahlin
/* I *think* I've fixed the memory leak for the RandomAccessStateUnit tests
/*
/* Revision 1.9  2004/05/27 01:54:26  ypraveen
/* Node near aggregation function
/*
/* Revision 1.8  2004/05/24 20:57:32  ypraveen
/* Changes to the testing code
/*
/* Revision 1.7  2004/05/23 05:38:00  ypraveen
/* Added code to ensure that sdims on nodes start in order. Quite a bit of hack. Will clean it up later.
/*
/* Revision 1.6  2004/05/21 06:07:00  ypraveen
/* stopping log messages from sdims package
/*
/* Revision 1.5  2004/05/21 04:58:34  ypraveen
/* Couple of asserts and name changes
/*
/* Revision 1.4  2004/05/21 03:14:34  ypraveen
/* Added a workqueue where the spanning tree changes notified by continuous probes
/* are stored. Also added a thread that does consume this work.
/*
/* Revision 1.3  2004/05/20 20:59:32  ypraveen
/* * added a getLocalNode() that starts the SDIMS on this node
/* * added sendUpdateMessage and sendProbeMessage routines that are
/*   to be used by ReadDirectory, SpanningDirectory, etc.,
/* * currently a test program checks the spanning tree aggregation.
/*    -- succeeds with continuous probes working fine. albeit lots of redundant triggers.
/*
 */
//---------------------------------------------------------------------------
