package code;
import rice.pastry.AML.AggrFunc;
import java.util.Random  ;

/**
 * SDIMSRDAggrFunc.java
 *   SDIMS Read Directory Aggregation Function definition
 *
 *   Currently.. randomly chooses one of the child's values
 *
 * @author Praveen Yalagandula
 * @version
 */

public class SDIMSRDAggrFunc extends AggrFunc {
    
    public SDIMSRDAggrFunc(String attrType, int tup) {
	super(attrType) ;
	up = tup ;
	down = 0 ;
    }

    public SDIMSRDAggrFunc(String attrType) {
	super(attrType) ;
	up = 160 ;
	down = 0 ;
    }

    public SDIMSRDAggrFunc(String attrType, int tup, int tdown) {
	super(attrType) ;
	up = tup ;
	down = tdown ;
    }

    // similar to SDNodeNearAggrFunc.java
    //    choose one with nodeid nearby
    // 
    // Issue 1: flash-crowd case
    //  assume the values of the following format
    //    value = (nodeid, false) ; // willget case
    //    value = (nodeid, true) ; // gotIt case
    //
    //  give preference to gotIts over willGet
    //  
    
    // Issue 2: avoiding fat tree case
    //   goal: ensure each node has only few children
    //   
    //   (check mike notes for direction here)
    // 
    public Object aggregate(Object[] args) {
	//   Choose a node with node id closest to my node id
        /*
	NodeId myId = Config.getMyNodeId() ;
	int myIdInt = new Integer(myId.toString()).intValue() ;

	assert(myId != null) ;

	assert(args.length > 0) ;
	// NodeId smallId = (NodeId)args[0] ;
	// int mindiff = Math.abs(new Integer(smallId.toString()).intValue() - myIdInt) ;

	NodeId smallId = null ;
	int mindiff = 1000000 ; // a large default value
	boolean gotit = false ;

	for(int ii = 0 ; ii < args.length ; ii++) {
	    SDIMSReadDirValue val = (SDIMSReadDirValue) args[ii] ;	    
	    NodeId thisId = val.getNodeId() ;
	    int diff = Math.abs(new Integer(thisId.toString()).intValue() - myIdInt) ;

	    if( (!gotit && (val.isGotIt() || diff < mindiff)) ||
		(gotit && val.isGotIt() && diff < mindiff ) ) {
		smallId = thisId ;
		mindiff = diff ;
		gotit = val.isGotIt() ;
	    }
	}
	return new SDIMSReadDirValue(smallId, gotit) ;
	*/
	assert false; //Stub. Jiandan commented the above code 
	              //because we don't have Config.getMyNodeId() any more.
	return null;  
    }
    
} // SDIMSRDAggrFunc

//---------------------------------------------------------------------------
/* $Log: SDIMSRDAggrFunc.java,v $
/* Revision 1.5  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.4  2005/09/13 17:20:42  ypraveen
/* *** empty log message ***
/*
/* Revision 1.3  2004/05/20 20:54:35  ypraveen
/* Trivial Aggregation Functions for Read directory and spanning directory; also added cvs logging here
/*
 */
//---------------------------------------------------------------------------
