package code;

import rice.pastry.PastryNode ;
import rice.pastry.NodeHandle ;
import rice.pastry.NodeName ;
import rice.pastry.AML.* ;
import rice.pastry.AML.messaging.* ;


import java.net.*;
import java.util.Vector ;
 /** 
 *  Use SDIMS to select someone to supply read misses 
 **/ 

public class SDIMSReadDirectory implements ReadDirectory
{
    private SDIMSInterface sdims;
    private final static boolean TBD = false;

    public SDIMSReadDirectory(SDIMSInterface sdims_)
    {
	sdims = sdims_;
    }

/*
 *------------------------------------------------------------------
 *
 * getTarget --
 *
 *          Choose someone to supply this data. The node selected
 *          should be able to supply the first byte of the specified
 *          data. The caller should regard the result as a hint
 *          and be prepared to retry this lookup if the specified
 *          node doesn't have the data.
 *
 * Arguments:
 *      PendingDemandRequest -- the data being requested along
 *                              w/ info on the request (e.g.,
 *                              # retries, etc.)
 *
 * Results:
 *      Return the NodeId we should use or INVALID_NODE_ID on
 *      error or on miss.
 *
 * Side effects:
 *      None.
 *
 *------------------------------------------------------------------
 */
public NodeId 
getTarget(PendingDemandRequest pdr)
{
    
    //    assert(TBD);
    /*
     * Future: ask SDIMS who to ask
     *

      SDIMSType type = SDIMSInterface.DATA_LOCATION;
      SDIMSName name = pdr.getObjId();
      probeSubKey = pdr.getOffset();
      boolean reaggregate = false;
      if(r.getRetryCount() > 0){
        reaggregate = true;
      }
      SDIMSValue answer = sdims.probe(type, key, probeSubKey, reaggregate);
      NodeId nodeId = answer to node id
      return nodeId;
    */
    //return null;
    NodeId myId = sdims.getMyNodeId() ;
    boolean reaggregate = false;
    String attrType = sdims.readDirAttrType; 
    String attrName = pdr.getObjId().getPath();
    SDIMSRDProbeCallBack pcb = 
	new SDIMSRDProbeCallBack(pdr.getOffset(),
				 pdr.getLength(),
                                 myId) ;
    if(pdr.getRetryCount() > 0){
        reaggregate = true;
    }
    sdims.sendProbeMessage(attrType, attrName, 
			   false, /* continuous */
			   reaggregate,
			   pcb,
			   0) ; 
    // this blocks till the answer is available
    NodeId answer = pcb.getAnswer() ;
    if(answer == null) {
	answer = myId ;
    }
    System.out.println("Target to read from will be "+answer) ;
    return answer ;  
}

public void insert(DirectoryUpdate du)
{
    // Do not comment the following line!
    PastryNode pn = sdims.getLocalNode() ;
    assert(pn != null) ;

    System.out.println("Insert called with DU: "+du) ;
    
    NodeId myId = sdims.getMyNodeId();
    String attrType = sdims.readDirAttrType;
    String attrName = du.getObjId().getPath();
    long offset = du.getOffset() ;
    long length = du.getLength() ;

    //Object value = new SDIMSReadDirUpdate(myId, offset, length) ;
    Object value = myId ;

    assert(value != null) ;

    assert(du.getAction() == du.INSERT) ;
    
    // Should we probe first, add the insert to
    //  the previous update and then perform update?
    sdims.sendUpdateMessage(attrType, attrName, value) ;
    //assert(TBD);
}


public void inval(DirectoryUpdate du)
{
    // Do not comment the following line!
    PastryNode pn = sdims.getLocalNode() ;
    assert(pn != null) ;
    
    System.out.println("Inval called with DU: "+du) ;
    NodeId myId = sdims.getMyNodeId();
    String attrType = sdims.readDirAttrType;
    String attrName = du.getObjId().getPath();
    long offset = du.getOffset() ;
    long length = du.getLength() ;

    assert(du.getAction() == du.INVAL) ;

    // Should we probe first, add the insert to
    //  the previous update and then perform update?
    sdims.sendUpdateMessage(attrType, attrName, 
			    null) ;
    //assert(TBD);
}


public static void main(String[] args) {
    // start threads that does different works
}

}

/*
 *  This call back returns answer to the thread
 */
class SDIMSRDProbeCallBack implements ProbeCallBack {
    long offset ;
    long length ;
    boolean firstTime = true ; // firstTime.. notify the thread that created us
    Object lastAnswer = null ;
  NodeId myNodeId;
  public SDIMSRDProbeCallBack(long offset_, long length_, NodeId myid) {
	offset = offset_ ;
	length = length_ ;
        myNodeId = myid;
    }

    //
    //  This routine to be called by the read directory worker thread
    //   waiting to get an answer
    //
    public synchronized NodeId getAnswer() {
	while(firstTime) {
	    try{
		wait() ;
	    }catch(InterruptedException i){
		assert(false);
	    }
	}
	return (NodeId)lastAnswer ;
    }

    //
    // wake the spanning tree worker
    //
    public synchronized void doWork(ProbeMessage pmsg, Object newAnswer) {
	//System.out.println("Got answer "+newAnswer+" lastanswer was "+lastAnswer) ;
	if(firstTime) {
	    firstTime = false ;
	    lastAnswer = newAnswer ;
	    // wake up the thread
	    notify() ;
	}
    }

    //
    // called by sdims when answer comes back
    //
    public void onAnswer(ProbeMessage msg, Object answer) {
	Vector entries = (Vector) answer ;
	
	for(int ii = 0 ; ii < entries.size() ; ii++) {
	    AncestorMIBEntry amib = (AncestorMIBEntry)(entries.get(ii)) ;
	    if(amib.value != null) {
		NodeId oth = (NodeId) amib.value;
		if(!oth.equals(myNodeId)) {
		    doWork(msg, amib.value) ;
		    return ;
		}
	    }
	}
	AncestorMIBEntry amib = (AncestorMIBEntry)(entries.get(entries.size()-1)) ;
	doWork(msg, (NodeId)amib.value) ;
	return ;
    }
}

//---------------------------------------------------------------------------
/* $Log: SDIMSReadDirectory.java,v $
/* Revision 1.7  2005/10/13 00:24:24  zjiandan
/* remove Config.getMy* fixed Garbage Collection and Checkpoint exchange code
/*
/* Revision 1.5  2004/05/23 23:50:53  ypraveen
/* First cut read directory. Need to write some unit tests
/*
/* Revision 1.4  2004/05/13 20:33:25  dahlin
/* Clarified pseudocode -- code review with praveen
/*
/* Revision 1.3  2004/05/13 20:15:38  dahlin
/* Fixed ^M formatting
/*
/* Revision 1.2  2004/05/11 00:46:56  dahlin
/* Added read-miss-directory updates to SDIMSController
/*
/* Revision 1.1  2004/05/10 23:55:42  dahlin
/* Moved SDIMS read requests into ReadDirectory class for modularity and extensibility
/*
 */
//---------------------------------------------------------------------------
